/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassPatch;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.MethodRef;
import java.lang.reflect.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;

public class MakeMemberPublicPatch
extends ClassPatch {
    private final JavaRef member;
    private String type;
    private int oldFlags;
    private int newFlags;

    public MakeMemberPublicPatch(ClassMod classMod, JavaRef ref) {
        super(classMod);
        this.member = ref;
        this.optional = true;
        if (ref instanceof FieldRef) {
            this.type = "field";
        } else if (ref instanceof MethodRef) {
            this.type = "method";
        } else {
            throw new IllegalArgumentException("unexpected type: " + ref.getClass().getName());
        }
    }

    @Override
    public String getDescription() {
        int added = ~this.oldFlags & this.newFlags;
        int removed = this.oldFlags & ~this.newFlags;
        StringBuilder s = new StringBuilder();
        s.append("make ").append(this.type).append(" ").append(this.member.getName()).append(" ");
        boolean first = true;
        for (String flag : Modifier.toString(AccessFlag.toModifier(removed)).split("\\s+")) {
            if (flag.equals("") || AccessFlag.isPublic(added) && (flag.equals("protected") || flag.equals("private")) || AccessFlag.isProtected(added) && flag.equals("private")) continue;
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append("not ").append(flag);
        }
        for (String flag : Modifier.toString(AccessFlag.toModifier(added)).split("\\s+")) {
            if (flag.equals("")) continue;
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(flag);
        }
        return s.toString();
    }

    @Override
    public boolean apply(ClassFile classFile) throws BadBytecode {
        this.classMod.classFile = classFile;
        this.classMod.methodInfo = null;
        JavaRef target = this.map(this.member);
        boolean patched = false;
        if (target instanceof FieldRef) {
            for (Object o : classFile.getFields()) {
                FieldInfo fi = (FieldInfo)o;
                if (!fi.getName().equals(target.getName()) || !fi.getDescriptor().equals(target.getType())) continue;
                this.oldFlags = fi.getAccessFlags();
                this.newFlags = this.getNewFlags(this.oldFlags);
                if (this.oldFlags == this.newFlags) continue;
                fi.setAccessFlags(this.newFlags);
                patched = true;
            }
        } else if (target instanceof MethodRef) {
            for (Object o : classFile.getMethods()) {
                MethodInfo mi = (MethodInfo)o;
                if (!mi.getName().equals(target.getName()) || !mi.getDescriptor().equals(target.getType())) continue;
                this.oldFlags = mi.getAccessFlags();
                this.newFlags = this.getNewFlags(this.oldFlags);
                if (this.oldFlags == this.newFlags) continue;
                mi.setAccessFlags(this.newFlags);
                patched = true;
            }
        }
        if (patched) {
            this.recordPatch();
        }
        return patched;
    }

    public int getNewFlags(int oldFlags) {
        return oldFlags & 0xFFFFFFF9 | 1;
    }
}

