/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.DeleteProfileDialog;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MainForm;
import com.prupe.mcpatcher.MinecraftInstallation;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.ModList;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

class MainMenu {
    private final MainForm mainForm;
    final JMenuBar menuBar;
    private final JMenu file;
    private final JMenuItem origFile;
    private final JMenuItem outputFile;
    private final JMenuItem exit;
    private final JMenu mods;
    private final JMenuItem addMod;
    private final JMenuItem removeMod;
    private final JMenuItem enableAll;
    private final JMenuItem disableAll;
    private final JMenuItem moveUp;
    private final JMenuItem moveDown;
    private final JMenu profile;
    private final JMenuItem save;
    private final JMenuItem load;
    private final JMenuItem delete;
    private final JMenu game;
    private final JMenuItem patch;
    private final JMenuItem unpatch;
    private final JMenuItem test;
    private final JMenu convert;
    JMenuItem convertItem;

    MainMenu(MainForm mainForm1) {
        this.mainForm = mainForm1;
        this.menuBar = new JMenuBar();
        this.file = new JMenu("File");
        this.file.setMnemonic('F');
        this.menuBar.add(this.file);
        this.origFile = new JMenuItem("Select input file...");
        this.origFile.setMnemonic('i');
        MainMenu.copyActionListener(this.origFile, this.mainForm.origBrowseButton);
        this.file.add(this.origFile);
        this.outputFile = new JMenuItem("Select output file...");
        this.outputFile.setMnemonic('o');
        MainMenu.copyActionListener(this.outputFile, this.mainForm.outputBrowseButton);
        this.file.add(this.outputFile);
        this.file.addSeparator();
        this.exit = new JMenuItem("Exit");
        this.exit.setMnemonic('x');
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(((MainMenu)MainMenu.this).mainForm.frame, 201));
            }
        });
        this.file.add(this.exit);
        this.mods = new JMenu("Mods");
        this.mods.setMnemonic('M');
        this.menuBar.add(this.mods);
        this.addMod = new JMenuItem("Add...");
        this.addMod.setMnemonic('A');
        MainMenu.copyActionListener(this.addMod, this.mainForm.addButton);
        this.mods.add(this.addMod);
        this.removeMod = new JMenuItem("Remove");
        this.removeMod.setMnemonic('R');
        MainMenu.copyActionListener(this.removeMod, this.mainForm.removeButton);
        this.mods.add(this.removeMod);
        this.mods.addSeparator();
        this.enableAll = new JMenuItem("Enable all");
        this.enableAll.setMnemonic('E');
        this.mods.add(this.enableAll);
        this.enableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModList modList = MCPatcher.modList;
                if (modList != null) {
                    modList.enableValidMods(true);
                    MainMenu.this.mainForm.redrawModListCheckboxes();
                }
            }
        });
        this.disableAll = new JMenuItem("Disable all");
        this.disableAll.setMnemonic('D');
        this.mods.add(this.disableAll);
        this.disableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModList modList = MCPatcher.modList;
                if (modList != null) {
                    modList.disableAll();
                    MainMenu.this.mainForm.redrawModListCheckboxes();
                }
            }
        });
        this.mods.addSeparator();
        this.moveUp = new JMenuItem("Move up");
        this.moveUp.setMnemonic('u');
        MainMenu.copyActionListener(this.moveUp, this.mainForm.upButton);
        this.mods.add(this.moveUp);
        this.moveDown = new JMenuItem("Move down");
        this.moveDown.setMnemonic('d');
        MainMenu.copyActionListener(this.moveDown, this.mainForm.downButton);
        this.mods.add(this.moveDown);
        this.mods.addSeparator();
        this.profile = new JMenu("Profile");
        this.profile.setMnemonic('r');
        this.menuBar.add(this.profile);
        this.save = new JMenuItem("Save profile...");
        this.save.setMnemonic('S');
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String profileName;
                int i = 0;
                while (true) {
                    profileName = "Custom Profile";
                    if (i > 0) {
                        profileName = profileName + " " + i;
                    }
                    if (Config.instance.findProfileByName(profileName, false) == null) break;
                    ++i;
                }
                Object result = JOptionPane.showInputDialog(((MainMenu)MainMenu.this).mainForm.frame, "Enter a name for this profile:", "Profile name", 3, null, null, profileName);
                if (result != null && result instanceof String && !result.equals("")) {
                    profileName = (String)result;
                    String currentProfile = Config.instance.getConfigValue("selectedProfile");
                    if (profileName.equals(currentProfile)) {
                        return;
                    }
                    if (Config.instance.findProfileByName(profileName, false) != null) {
                        int confirm = JOptionPane.showConfirmDialog(((MainMenu)MainMenu.this).mainForm.frame, String.format("Profile \"%s\" exists.  Overwrite?", profileName), "Confirm overwrite", 0);
                        if (confirm != 0) {
                            return;
                        }
                        Config.instance.deleteProfile(profileName);
                    }
                    MCPatcher.modList.updateProperties();
                    Config.instance.selectProfile(profileName);
                    MainMenu.this.mainForm.updateControls();
                }
            }
        });
        this.profile.add(this.save);
        this.load = new JMenu("Select profile");
        this.load.setMnemonic('e');
        this.profile.add(this.load);
        this.delete = new JMenu("Delete profile");
        this.delete.setMnemonic('D');
        this.profile.add(this.delete);
        this.game = new JMenu("Game");
        this.game.setMnemonic('G');
        this.menuBar.add(this.game);
        this.patch = new JMenuItem("Patch");
        this.patch.setMnemonic('P');
        MainMenu.copyActionListener(this.patch, this.mainForm.patchButton);
        this.game.add(this.patch);
        this.unpatch = new JMenuItem("Unpatch");
        this.unpatch.setMnemonic('U');
        MainMenu.copyActionListener(this.unpatch, this.mainForm.undoButton);
        this.game.add(this.unpatch);
        this.game.addSeparator();
        this.test = new JMenuItem("Test Minecraft");
        this.test.setMnemonic('T');
        MainMenu.copyActionListener(this.test, this.mainForm.testButton);
        this.game.add(this.test);
        this.convert = new JMenu("Convert Texture Pack");
        this.convert.setMnemonic('C');
        this.convert.setForeground(Color.RED);
        this.menuBar.add(this.convert);
        this.convertItem = new JMenuItem("Convert 1.4 to 1.5...");
        this.convertItem.setMnemonic('5');
        this.convertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.mainForm.showTexturePackConverter(15);
            }
        });
        this.convert.add(this.convertItem);
        this.convertItem = new JMenuItem("Convert 1.5 to 1.6...");
        this.convertItem.setMnemonic('6');
        this.convertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.mainForm.showTexturePackConverter(16);
            }
        });
        this.convert.add(this.convertItem);
        this.updateControls(true);
    }

    private static void copyActionListener(JMenuItem item, final JButton button) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    for (ActionListener listener : button.getActionListeners()) {
                        listener.actionPerformed(e);
                    }
                }
            }
        });
    }

    void updateControls(boolean busy) {
        JMenuItem item;
        this.file.setEnabled(!busy);
        this.mods.setEnabled(!busy);
        this.profile.setEnabled(!busy);
        this.game.setEnabled(!busy);
        this.convert.setEnabled(!busy);
        this.origFile.setEnabled(this.mainForm.origBrowseButton.isEnabled());
        this.outputFile.setEnabled(this.mainForm.outputBrowseButton.isEnabled());
        this.addMod.setEnabled(this.mainForm.addButton.isEnabled());
        this.removeMod.setEnabled(this.mainForm.removeButton.isEnabled());
        this.moveUp.setEnabled(this.mainForm.upButton.isEnabled());
        this.moveDown.setEnabled(this.mainForm.downButton.isEnabled());
        this.patch.setEnabled(this.mainForm.patchButton.isEnabled());
        this.unpatch.setEnabled(this.mainForm.undoButton.isEnabled());
        this.test.setEnabled(this.mainForm.testButton.isEnabled());
        this.load.removeAll();
        this.delete.removeAll();
        if (!busy && Config.instance != null) {
            ArrayList<String> profiles = Config.instance.getProfiles();
            Collections.sort(profiles, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    MinecraftVersion v1 = null;
                    MinecraftVersion v2 = null;
                    if (Config.isDefaultProfile(o1)) {
                        v1 = MinecraftVersion.parseVersion(o1);
                    }
                    if (Config.isDefaultProfile(o2)) {
                        v2 = MinecraftVersion.parseVersion(o2);
                    }
                    if (v1 == null && v2 == null) {
                        return o1.compareTo(o2);
                    }
                    if (v1 == null) {
                        return 1;
                    }
                    if (v2 == null) {
                        return -1;
                    }
                    return v1.compareTo(v2);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            final String currentProfile = Config.instance.getConfigValue("selectedProfile");
            for (final String profile : profiles) {
                JRadioButtonMenuItem item2 = new JRadioButtonMenuItem(profile, profile.equals(currentProfile));
                item2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File jar;
                        if (profile.equals(currentProfile)) {
                            return;
                        }
                        MCPatcher.modList.updateProperties();
                        Config.instance.selectProfile(profile);
                        boolean modsOk = false;
                        String version = Config.getVersionForDefaultProfile(profile);
                        if (version != null && !version.equals(MCPatcher.minecraft.getVersion().getProfileString()) && (jar = MinecraftInstallation.getJarPathForVersion(version)) != null && jar.isFile()) {
                            try {
                                modsOk = MCPatcher.setMinecraft(jar, false);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (!modsOk) {
                            MCPatcher.getAllMods();
                        }
                        MainMenu.this.mainForm.updateModList();
                    }
                });
                buttonGroup.add(item2);
                this.load.add(item2);
                JMenuItem item1 = new JMenuItem(profile);
                item1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (profile.equals(currentProfile)) {
                            return;
                        }
                        DeleteProfileDialog dialog = new DeleteProfileDialog(profile);
                        int result = JOptionPane.showConfirmDialog(((MainMenu)MainMenu.this).mainForm.frame, dialog.getPanel(), "Confirm profile delete", 0);
                        if (result == 0) {
                            Config.instance.deleteProfile(profile);
                            dialog.deleteInstallations();
                            MainMenu.this.mainForm.updateControls();
                        }
                    }
                });
                item1.setEnabled(!profile.equals(currentProfile));
                this.delete.add(item1);
            }
        }
        if (this.load.getSubElements().length == 0) {
            item = new JMenuItem("(none)");
            item.setEnabled(false);
            this.load.add(item);
        } else {
            this.load.setEnabled(true);
        }
        if (this.delete.getSubElements().length == 0) {
            item = new JMenuItem("(none)");
            item.setEnabled(false);
            this.delete.add(item);
        } else {
            this.delete.setEnabled(true);
        }
    }
}

