/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ConstPoolUtils;
import javassist.bytecode.ConstPool;

public abstract class JavaRef
implements Comparable<JavaRef> {
    protected final String className;
    protected final String name;
    protected final String type;

    public JavaRef(String className, String name, String type) {
        this.className = className == null ? null : className.replaceAll("/", ".");
        this.name = name;
        this.type = type;
        if (type != null) {
            ConstPoolUtils.checkTypeDescriptorSyntax(type);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.format("%s{className='%s', name='%s', type='%s'}", this.getClass().getName(), this.className, this.name, this.type);
    }

    abstract boolean checkEqual(ConstPool var1, int var2);

    private static int compareString(String a, String b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        return b == null ? 1 : a.compareTo(b);
    }

    @Override
    public int compareTo(JavaRef that) {
        int c = JavaRef.compareString(this.className, that.className);
        if (c != 0) {
            return c;
        }
        c = JavaRef.compareString(this.name, that.name);
        if (c != 0) {
            return c;
        }
        c = JavaRef.compareString(this.type, that.type);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof JavaRef && this.compareTo((JavaRef)o) == 0;
    }

    public int hashCode() {
        return (this.className == null ? 0 : this.className.hashCode()) + (this.name == null ? 0 : this.name.hashCode()) + (this.type == null ? 0 : this.type.hashCode());
    }
}

