/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassSignature;
import com.prupe.mcpatcher.ConstPoolUtils;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.MethodRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;

public class InterfaceSignature
extends ClassSignature {
    private final JavaRef[] methods;
    private boolean interfaceOnly;
    private boolean abstractOnly;
    private boolean exactMatch;

    public InterfaceSignature(ClassMod classMod, JavaRef ... methods) {
        this(classMod, Arrays.asList(methods));
    }

    public InterfaceSignature(ClassMod classMod, List<JavaRef> methods) {
        super(classMod);
        ArrayList<JavaRef> tmpMethods = new ArrayList<JavaRef>();
        for (JavaRef method : methods) {
            if (method == null) continue;
            if (method instanceof MethodRef || method instanceof InterfaceMethodRef) {
                tmpMethods.add(method);
                continue;
            }
            throw new IllegalArgumentException("invalid type " + method.getClass().getSimpleName());
        }
        this.methods = tmpMethods.toArray(new JavaRef[tmpMethods.size()]);
        this.interfaceOnly = true;
    }

    public InterfaceSignature setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
        return this;
    }

    public InterfaceSignature setAbstractOnly(boolean abstractOnly) {
        this.abstractOnly = abstractOnly;
        return this;
    }

    public InterfaceSignature setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
        return this;
    }

    @Override
    public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
        if (this.interfaceOnly && !classFile.isInterface()) {
            return false;
        }
        if (this.abstractOnly && !classFile.isAbstract()) {
            return false;
        }
        List obfMethods = classFile.getMethods();
        if (obfMethods.size() < this.methods.length) {
            return false;
        }
        if (this.exactMatch && obfMethods.size() > this.methods.length) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            block5: for (int j = 0; j < this.methods.length; ++j) {
                JavaRef method = this.methods[j];
                MethodInfo obfMethod = (MethodInfo)obfMethods.get(j);
                switch (i) {
                    case 0: {
                        if (InterfaceSignature.isPotentialTypeMatch(this.getClassMap(), method.getType(), obfMethod.getDescriptor())) continue block5;
                        return false;
                    }
                    case 1: {
                        tempClassMap.addClassMap(this.classMod.getDeobfClass(), classFile.getName());
                        tempClassMap.addMethodMap(this.classMod.getDeobfClass(), method.getName(), obfMethod.getName(), obfMethod.getDescriptor());
                        tempClassMap.addTypeDescriptorMap(method.getType(), obfMethod.getDescriptor());
                        continue block5;
                    }
                }
            }
        }
        return true;
    }

    static boolean isPotentialTypeMatch(ClassMap classMap, ArrayList<String> deobfTypes, ArrayList<String> obfTypes) {
        if (deobfTypes.size() != obfTypes.size()) {
            return false;
        }
        for (int i = 0; i < deobfTypes.size(); ++i) {
            String deobfType = deobfTypes.get(i);
            String obfType = obfTypes.get(i);
            String deobfClass = deobfType.replaceFirst("^\\[+", "");
            String obfClass = obfType.replaceFirst("^\\[+", "");
            if (deobfType.length() - deobfClass.length() != obfType.length() - obfClass.length()) {
                return false;
            }
            if (deobfClass.charAt(0) == 'L' && obfClass.charAt(0) == 'L') {
                String deobfMapping;
                boolean obfIsMC;
                deobfClass = ClassMap.descriptorToClassName(deobfClass);
                obfClass = ClassMap.descriptorToClassName(obfClass);
                boolean deobfIsMC = !deobfClass.contains(".") || deobfClass.startsWith("net.minecraft.");
                boolean bl = obfIsMC = !obfClass.matches(".*[^a-z].*") || obfClass.startsWith("net.minecraft.");
                if (deobfIsMC != obfIsMC) {
                    return false;
                }
                if (!(deobfIsMC ? classMap.hasMap(deobfClass) && !(deobfMapping = classMap.map(deobfClass).replace('/', '.')).equals(obfClass) : !deobfClass.equals(obfClass))) continue;
                return false;
            }
            if (deobfClass.equals(obfClass)) continue;
            return false;
        }
        return true;
    }

    static boolean isPotentialTypeMatch(ClassMap classMap, String deobfDesc, String obfDesc) {
        return deobfDesc == null && obfDesc == null || InterfaceSignature.isPotentialTypeMatch(classMap, ConstPoolUtils.parseDescriptor(deobfDesc), ConstPoolUtils.parseDescriptor(obfDesc));
    }
}

