/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MainForm;
import com.prupe.mcpatcher.MinecraftInstallation;
import com.prupe.mcpatcher.MinecraftVersion;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DeleteProfileDialog {
    private JLabel textLabel;
    private JCheckBox v1CheckBox;
    private JCheckBox v2CheckBox;
    private JPanel panel;
    private final MinecraftVersion version;
    private final File v1File;
    private final File v2File;

    DeleteProfileDialog(String profile) {
        this.$$$setupUI$$$();
        if (Config.isDefaultProfile(profile)) {
            this.version = MinecraftVersion.parseVersion(profile);
            this.v1File = MinecraftInstallation.v1.getPatchedInstallation(this.version);
            this.v2File = MinecraftInstallation.v2.getPatchedInstallation(this.version);
        } else {
            this.version = null;
            this.v1File = null;
            this.v2File = null;
        }
        this.textLabel.setText("Delete saved profile \"" + profile + "\"?");
        if (this.v1File == null || !this.v1File.isFile()) {
            this.v1CheckBox.setVisible(false);
        } else {
            this.v1CheckBox.setText("Also delete file " + this.v1File);
            this.v1CheckBox.setSelected(MainForm.shift);
        }
        if (this.v2File == null || !this.v2File.isDirectory()) {
            this.v2CheckBox.setVisible(false);
        } else {
            this.v2CheckBox.setText("Also delete folder " + this.v2File);
            this.v2CheckBox.setSelected(MainForm.shift);
        }
    }

    JPanel getPanel() {
        return this.panel;
    }

    void deleteInstallations() {
        if (this.v1CheckBox.isSelected() && this.v1File != null) {
            MinecraftInstallation.v1.deletePatchedInstallation(this.version);
        }
        if (this.v2CheckBox.isSelected() && this.v2File != null) {
            MinecraftInstallation.v2.deletePatchedInstallation(this.version);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.textLabel = jLabel = new JLabel();
        jLabel.setText("Delete profile?");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.v1CheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Also delete file");
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.v2CheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Also delete folder");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

