/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.PatchComponent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.MethodInfo;

public abstract class ClassPatch
implements PatchComponent {
    final ClassMod classMod;
    final Map<String, Integer> numMatches = new HashMap<String, Integer>();
    boolean optional;

    public ClassPatch(ClassMod classMod) {
        this.classMod = classMod;
    }

    public abstract String getDescription();

    abstract boolean apply(ClassFile var1) throws BadBytecode, DuplicateMemberException, IOException;

    private void addPatch(String desc) {
        int val = 0;
        if (this.numMatches.containsKey(desc)) {
            val = this.numMatches.get(desc);
        }
        this.numMatches.put(desc, val + 1);
    }

    protected void recordPatch() {
        String desc = this.getDescription();
        this.addPatch(desc);
        Logger.log(4, "%s", desc);
    }

    protected void recordPatch(String extra) {
        String desc = this.getDescription();
        this.addPatch(desc);
        Logger.log(4, "%s %s", desc, extra);
    }

    @Override
    public final ClassFile getClassFile() {
        return this.classMod.getClassFile();
    }

    @Override
    public final MethodInfo getMethodInfo() {
        return this.classMod.getMethodInfo();
    }

    @Override
    public final String buildExpression(Object ... objects) {
        return this.classMod.buildExpression(objects);
    }

    @Override
    public final byte[] buildCode(Object ... objects) {
        return this.classMod.buildCode(objects);
    }

    @Override
    public final Object push(Object value) {
        return this.classMod.push(value);
    }

    @Override
    public final byte[] reference(int opcode, JavaRef ref) {
        return this.classMod.reference(opcode, ref);
    }

    @Override
    public final Mod getMod() {
        return this.classMod.getMod();
    }

    @Override
    public final ClassMap getClassMap() {
        return this.classMod.getClassMap();
    }

    @Override
    public final JavaRef map(JavaRef ref) {
        return this.classMod.map(ref);
    }
}

