/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.ConstPoolUtils;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MemberMapper;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.PatchComponent;
import com.prupe.mcpatcher.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;

public abstract class ClassMod
implements PatchComponent {
    final Mod mod;
    final List<String> prerequisiteClasses = new ArrayList<String>();
    final List<com.prupe.mcpatcher.ClassSignature> classSignatures = new ArrayList<com.prupe.mcpatcher.ClassSignature>();
    final List<com.prupe.mcpatcher.ClassPatch> patches = new ArrayList<com.prupe.mcpatcher.ClassPatch>();
    final List<MemberMapper> memberMappers = new ArrayList<MemberMapper>();
    boolean global = false;
    String parentClass;
    String[] interfaces;
    final Collection<String> targetClasses = new HashSet<String>();
    final List<String> errors = new ArrayList<String>();
    boolean addToConstPool = false;
    ClassFile classFile;
    MethodInfo methodInfo;
    int bestMatchCount;
    String bestMatch;
    private final List<Label> labels = new ArrayList<Label>();
    private final Map<String, Integer> labelPositions = new HashMap<String, Integer>();
    boolean matchAddedFiles;

    ClassMod(Mod mod) {
        this.mod = mod;
    }

    boolean matchClassFile(String filename, ClassFile classFile) {
        this.addToConstPool = false;
        this.classFile = classFile;
        if (!this.filterFile(filename)) {
            return false;
        }
        ClassMap newMap = new ClassMap();
        String deobfName = this.getDeobfClass();
        int sigIndex = 0;
        for (com.prupe.mcpatcher.ClassSignature cs : this.classSignatures) {
            boolean found = false;
            if (cs.match(filename, classFile, newMap)) {
                found = true;
            }
            if (found == cs.negate) {
                return false;
            }
            newMap.addClassMap(deobfName, ClassMap.filenameToClassName(filename));
            if (this.bestMatch == null || sigIndex > this.bestMatchCount) {
                this.bestMatch = filename;
                this.bestMatchCount = sigIndex;
            }
            ++sigIndex;
        }
        this.targetClasses.add(classFile.getName());
        if (this.targetClasses.size() == 1 && !this.global) {
            this.mod.classMap.merge(newMap);
            if (this.parentClass != null) {
                this.mod.classMap.addClassMap(this.parentClass, classFile.getSuperclass());
                this.mod.classMap.addInheritance(this.parentClass, deobfName);
            }
            if (this.interfaces != null) {
                String[] obfInterfaces = classFile.getInterfaces();
                for (int i = 0; i < Math.min(this.interfaces.length, obfInterfaces.length); ++i) {
                    this.mod.classMap.addClassMap(this.interfaces[i], obfInterfaces[i]);
                    this.mod.classMap.addInterface(this.interfaces[i], deobfName);
                }
            }
        }
        return true;
    }

    public String getDeobfClass() {
        return this.getClass().getSimpleName().replaceFirst("^_", "").replaceFirst("Mod$", "");
    }

    boolean okToApply() {
        return this.errors.size() == 0;
    }

    void addError(String error) {
        this.errors.add(error);
    }

    List<String> getTargetClasses() {
        ArrayList<String> sortedList = new ArrayList<String>(this.targetClasses.size());
        sortedList.addAll(this.targetClasses);
        Collections.sort(sortedList);
        return sortedList;
    }

    protected boolean filterFile(String filename) {
        String className = ClassMap.filenameToClassName(filename);
        if (this.global) {
            return !className.startsWith("com.jcraft.") && !className.startsWith("paulscode.") && !className.startsWith("com.fasterxml.") && !className.startsWith("javax.");
        }
        return className.startsWith("net.minecraft.") || className.matches("^[a-z]{1,4}$");
    }

    boolean mapClassMembers(String filename, ClassFile classFile) throws Exception {
        boolean ok = true;
        for (MemberMapper mapper : this.memberMappers) {
            String mapperType = mapper.getMapperType();
            mapper.mapDescriptor(this.mod.getClassMap());
            for (Object o : mapper.getMatchingObjects(classFile)) {
                if (o instanceof MethodInfo) {
                    this.methodInfo = (MethodInfo)o;
                }
                if (mapper.match(o)) {
                    mapper.updateClassMap(this.getClassMap(), classFile, o);
                    mapper.afterMatch();
                }
                if (!(o instanceof MethodInfo)) continue;
                this.methodInfo = null;
            }
            if (mapper.allMatched()) continue;
            this.addError(String.format("no match found for %s %s", mapperType, mapper.getName()));
            Logger.log(3, "no match found for %s %s", mapperType, mapper.getName());
            ok = false;
        }
        return ok;
    }

    public void prePatch(String filename, ClassFile classFile) throws Exception {
    }

    public void postPatch(String filename, ClassFile classFile) throws Exception {
    }

    public void addPrerequisiteClass(String className) {
        this.prerequisiteClasses.add(className);
    }

    public void addClassSignature(com.prupe.mcpatcher.ClassSignature classSignature) {
        this.classSignatures.add(classSignature);
    }

    public void addPatch(com.prupe.mcpatcher.ClassPatch classPatch) {
        this.patches.add(classPatch);
    }

    public void addMemberMapper(MemberMapper memberMapper) {
        this.memberMappers.add(memberMapper);
    }

    public void setMultipleMatchesAllowed(boolean match) {
        this.global = match;
    }

    public void setMatchAddedFiles(boolean match) {
        if (match) {
            this.matchAddedFiles = true;
            this.setMultipleMatchesAllowed(true);
        } else {
            this.matchAddedFiles = false;
        }
    }

    public void setParentClass(String className) {
        this.parentClass = className;
    }

    public void setInterfaces(String ... interfaces) {
        this.interfaces = (String[])interfaces.clone();
    }

    public final Label label(String key) {
        return new Label(key, true);
    }

    public final Label branch(String key) {
        return new Label(key, false);
    }

    void resetLabels() {
        this.labels.clear();
        this.labelPositions.clear();
    }

    void resolveLabels(byte[] code, int start, int labelOffset) {
        for (Map.Entry<String, Integer> e : this.labelPositions.entrySet()) {
            Logger.log(5, "label %s -> instruction %d", e.getKey(), start + e.getValue());
        }
        for (Label label : this.labels) {
            if (!this.labelPositions.containsKey(label.name)) {
                throw new RuntimeException("no label " + label.name + " defined");
            }
            int to = this.labelPositions.get(label.name);
            int diff = to - label.from + 1;
            int codepos = label.from + labelOffset;
            Logger.log(5, "branch offset %s %s -> %+d @%d", Mnemonic.OPCODE[code[codepos - 1] & 0xFF].toUpperCase(), label.name, diff, label.from - 1 + start);
            code[codepos] = Util.b(diff, 1);
            code[codepos + 1] = Util.b(diff, 0);
        }
    }

    @Override
    public final ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public final MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    @Override
    public final String buildExpression(Object ... objects) {
        return BinaryRegex.build(objects);
    }

    @Override
    public final byte[] buildCode(Object ... objects) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.buildCode1(baos, objects);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    private void buildCode1(ByteArrayOutputStream baos, Object[] objects) throws IOException {
        for (Object o : objects) {
            if (o instanceof Byte) {
                baos.write(((Byte)o).byteValue());
                continue;
            }
            if (o instanceof byte[]) {
                baos.write((byte[])o);
                continue;
            }
            if (o instanceof Integer) {
                baos.write((Integer)o);
                continue;
            }
            if (o instanceof int[]) {
                for (int i : (int[])o) {
                    baos.write(i);
                }
                continue;
            }
            if (o instanceof Label) {
                Label label = (Label)o;
                if (label.save) {
                    int offset = baos.size();
                    if (this.labelPositions.containsKey(label.name)) {
                        throw new RuntimeException("label " + label.name + " already defined");
                    }
                    this.labelPositions.put(label.name, offset);
                    continue;
                }
                label.from = baos.size();
                this.labels.add(label);
                baos.write(0);
                baos.write(0);
                continue;
            }
            if (o instanceof Object[]) {
                this.buildCode1(baos, (Object[])o);
                continue;
            }
            throw new AssertionError((Object)("invalid type: " + o.getClass().toString()));
        }
    }

    @Override
    public final Object push(Object value) {
        return ConstPoolUtils.push(this.getMethodInfo().getConstPool(), value, this.addToConstPool);
    }

    @Override
    public final byte[] reference(int opcode, JavaRef ref) {
        return ConstPoolUtils.reference(this.getMethodInfo().getConstPool(), opcode, this.map(ref), this.addToConstPool);
    }

    @Override
    public final Mod getMod() {
        return this.mod;
    }

    @Override
    public final ClassMap getClassMap() {
        return this.mod.getClassMap();
    }

    @Override
    public final JavaRef map(JavaRef ref) {
        return this.mod.getClassMap().map(ref);
    }

    public class MakeMemberPublicPatch
    extends com.prupe.mcpatcher.MakeMemberPublicPatch {
        public MakeMemberPublicPatch(JavaRef ref) {
            super(ClassMod.this, ref);
        }
    }

    public abstract class AddMethodPatch
    extends com.prupe.mcpatcher.AddMethodPatch {
        public AddMethodPatch(MethodRef methodRef) {
            super(ClassMod.this, methodRef);
        }

        public AddMethodPatch(MethodRef methodRef, int accessFlags) {
            super(ClassMod.this, methodRef, accessFlags);
        }

        public AddMethodPatch(String name) {
            super(ClassMod.this, name);
        }

        public AddMethodPatch(String name, int accessFlags) {
            super(ClassMod.this, name, accessFlags);
        }
    }

    public class AddFieldPatch
    extends com.prupe.mcpatcher.AddFieldPatch {
        public AddFieldPatch(FieldRef fieldRef) {
            super(ClassMod.this, fieldRef);
        }

        public AddFieldPatch(FieldRef fieldRef, int accessFlags) {
            super(ClassMod.this, fieldRef, accessFlags);
        }

        public AddFieldPatch(String name) {
            super(ClassMod.this, name);
        }

        public AddFieldPatch(String name, int accessFlags) {
            super(ClassMod.this, name, accessFlags);
        }
    }

    public abstract class BytecodePatch
    extends com.prupe.mcpatcher.BytecodePatch {
        public BytecodePatch() {
            super(ClassMod.this);
        }
    }

    public abstract class ClassPatch
    extends com.prupe.mcpatcher.ClassPatch {
        public ClassPatch() {
            super(ClassMod.this);
        }
    }

    public class MethodMapper
    extends com.prupe.mcpatcher.MethodMapper {
        public MethodMapper(MethodRef ... refs) {
            super(ClassMod.this, refs);
        }
    }

    public class FieldMapper
    extends com.prupe.mcpatcher.FieldMapper {
        public FieldMapper(FieldRef ... refs) {
            super(ClassMod.this, refs);
        }
    }

    public class OrSignature
    extends com.prupe.mcpatcher.OrSignature {
        public OrSignature(com.prupe.mcpatcher.ClassSignature ... signatures) {
            super(ClassMod.this, signatures);
        }
    }

    public class InterfaceSignature
    extends com.prupe.mcpatcher.InterfaceSignature {
        public InterfaceSignature(JavaRef ... methods) {
            super(ClassMod.this, methods);
        }

        public InterfaceSignature(List<JavaRef> methods) {
            super(ClassMod.this, methods);
        }
    }

    public class FixedBytecodeSignature
    extends com.prupe.mcpatcher.FixedBytecodeSignature {
        public FixedBytecodeSignature(Object ... objects) {
            super(ClassMod.this, objects);
        }
    }

    public abstract class BytecodeSignature
    extends com.prupe.mcpatcher.BytecodeSignature {
        public BytecodeSignature() {
            super(ClassMod.this);
        }
    }

    public class FilenameSignature
    extends com.prupe.mcpatcher.FilenameSignature {
        public FilenameSignature(String filename) {
            super(ClassMod.this, filename);
        }
    }

    public class ConstSignature
    extends com.prupe.mcpatcher.ConstSignature {
        public ConstSignature(Object value) {
            super(ClassMod.this, value);
        }
    }

    public abstract class ClassSignature
    extends com.prupe.mcpatcher.ClassSignature {
        public ClassSignature() {
            super(ClassMod.this);
        }
    }

    public static final class Label {
        final String name;
        final boolean save;
        int from;

        Label(String name, boolean save) {
            this.name = name;
            this.save = save;
        }
    }
}

