/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import org.lwjgl.opengl.GL11;

public class BlendMethod {
    public static final BlendMethod ALPHA = new BlendMethod("alpha", 770, 771, true, false, true);
    public static final BlendMethod ADD = new BlendMethod("add", 770, 1, true, false, true);
    public static final BlendMethod SUBTRACT = new BlendMethod("subtract", 775, 0, true, true, false);
    public static final BlendMethod MULTIPLY = new BlendMethod("multiply", 774, 771, true, true, true);
    public static final BlendMethod DODGE = new BlendMethod("dodge", 1, 1, true, true, false);
    public static final BlendMethod BURN = new BlendMethod("burn", 0, 769, true, true, false);
    public static final BlendMethod SCREEN = new BlendMethod("screen", 1, 769, true, true, false);
    public static final BlendMethod OVERLAY = new BlendMethod("overlay", 774, 768, true, true, false);
    public static final BlendMethod REPLACE = new BlendMethod("replace", 0, 0, false, false, true);
    private final int srcBlend;
    private final int dstBlend;
    private final String name;
    private final boolean blend;
    private final boolean fadeRGB;
    private final boolean fadeAlpha;

    public static BlendMethod parse(String text) {
        if ((text = text.toLowerCase().trim()).equals("alpha")) {
            return ALPHA;
        }
        if (text.equals("add")) {
            return ADD;
        }
        if (text.equals("subtract")) {
            return SUBTRACT;
        }
        if (text.equals("multiply")) {
            return MULTIPLY;
        }
        if (text.equals("dodge")) {
            return DODGE;
        }
        if (text.equals("burn")) {
            return BURN;
        }
        if (text.equals("screen")) {
            return SCREEN;
        }
        if (text.equals("overlay") || text.equals("color")) {
            return OVERLAY;
        }
        if (text.equals("replace")) {
            return REPLACE;
        }
        String[] tokens = text.split("\\s+");
        if (tokens.length >= 2) {
            try {
                int srcBlend = Integer.parseInt(tokens[0]);
                int dstBlend = Integer.parseInt(tokens[1]);
                return new BlendMethod("custom(" + srcBlend + "," + dstBlend + ")", srcBlend, dstBlend, true, true, false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private BlendMethod(String name, int srcBlend, int dstBlend, boolean blend, boolean fadeRGB, boolean fadeAlpha) {
        this.name = name;
        this.srcBlend = srcBlend;
        this.dstBlend = dstBlend;
        this.blend = blend;
        this.fadeRGB = fadeRGB;
        this.fadeAlpha = fadeAlpha;
    }

    public String toString() {
        return this.name;
    }

    public void applyFade(float fade) {
        if (this.fadeRGB && this.fadeAlpha) {
            GL11.glColor4f((float)fade, (float)fade, (float)fade, (float)fade);
        } else if (this.fadeRGB) {
            GL11.glColor4f((float)fade, (float)fade, (float)fade, (float)1.0f);
        } else if (this.fadeAlpha) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
        }
    }

    public void applyAlphaTest() {
        if (this.blend) {
            GL11.glDisable((int)3008);
        } else {
            GL11.glEnable((int)3008);
        }
    }

    public void applyBlending() {
        if (this.blend) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)this.srcBlend, (int)this.dstBlend);
        } else {
            GL11.glDisable((int)3042);
        }
    }

    public boolean isColorBased() {
        return this.fadeRGB;
    }
}

