/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BaseTexturePackMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;

public class BaseTilesheetMod
extends Mod {
    protected BaseTilesheetMod() {
        this.name = "__TilesheetBase";
        this.author = "MCPatcher";
        this.description = "Internal mod required by the patcher.";
        this.version = "2.1";
        this.addDependency("__TexturePackBase");
        this.addClassMod(new BaseMod.IconMod(this));
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new BaseMod.TextureBaseMod(this));
        this.addClassMod(new BaseMod.TextureMod(this));
        this.addClassMod(new TessellatorMod());
        this.addClassMod(new IconRegisterMod());
        this.addClassMod(new TextureMapMod());
        this.addClassMod(new TextureManagerMod());
        this.addClassMod(new TextureStitchedMod());
        this.addClassFile("com.prupe.mcpatcher.TileLoader");
        this.addClassFile("com.prupe.mcpatcher.TileLoader$1");
        this.addClassFile("com.prupe.mcpatcher.TessellatorUtils");
        BaseTexturePackMod.earlyInitialize(1, "com.prupe.mcpatcher.TileLoader", "init");
    }

    @Override
    public String[] getLoggingCategories() {
        return new String[]{"Tilesheet"};
    }

    private class TextureStitchedMod
    extends BaseMod.TextureStitchedMod {
        TextureStitchedMod() {
            super(BaseTilesheetMod.this);
            final InterfaceMethodRef listSize = new InterfaceMethodRef("java/util/List", "size", "()I");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "check for null animation data";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), this.reference(185, listSize), 172);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.getCaptureGroup(1), 76, 43, 198, this.branch("A"), 43, this.reference(185, listSize), 172, this.label("A"), this.push(1), 172);
                }
            });
        }
    }

    private class TextureManagerMod
    extends Mod.ClassMod {
        TextureManagerMod() {
            MethodRef updateAnimations = new MethodRef(this.getDeobfClass(), "updateAnimations", "()V");
            final InterfaceMethodRef listIterator = new InterfaceMethodRef("java/util/List", "iterator", "()Ljava/util/Iterator;");
            this.addClassSignature(new ClassMod.ConstSignature("dynamic/%s_%d"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), this.reference(185, listIterator));
                }
            }.setMethod(updateAnimations).addXref(1, new FieldRef(this.getDeobfClass(), "animations", "Ljava/util/List;")));
        }
    }

    private class TextureMapMod
    extends BaseMod.TextureMapMod {
        TextureMapMod() {
            super(BaseTilesheetMod.this);
            FieldRef blocksAtlas = new FieldRef(this.getDeobfClass(), "blocksAtlas", "LResourceAddress;");
            FieldRef itemsAtlas = new FieldRef(this.getDeobfClass(), "itemssAtlas", "LResourceAddress;");
            final MethodRef registerTiles = new MethodRef(this.getDeobfClass(), "registerTiles", "()V");
            final InterfaceMethodRef mapClear = new InterfaceMethodRef("java/util/Map", "clear", "()V");
            final InterfaceMethodRef mapEntrySet = new InterfaceMethodRef("java/util/Map", "entrySet", "()Ljava/util/Set;");
            final InterfaceMethodRef setIterator = new InterfaceMethodRef("java/util/Set", "iterator", "()Ljava/util/Iterator;");
            final ClassRef sbClass = new ClassRef("java/lang/StringBuilder");
            final MethodRef strValueOf = new MethodRef("java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
            final MethodRef sbInit0 = new MethodRef("java/lang/StringBuilder", "<init>", "()V");
            final MethodRef sbInit1 = new MethodRef("java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
            final MethodRef sbAppend = new MethodRef("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            final MethodRef sbToString = new MethodRef("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            final MethodRef strEquals = new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            final MethodRef readImage = new MethodRef("javax/imageio/ImageIO", "read", "(Ljava/io/InputStream;)Ljava/awt/image/BufferedImage;");
            this.addClassSignature(new BaseMod.ResourceAddressSignature(this, blocksAtlas, "textures/atlas/blocks.png"));
            this.addClassSignature(new BaseMod.ResourceAddressSignature(this, itemsAtlas, "textures/atlas/items.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BytecodeMatcher.captureReference(184), 61, BytecodeMatcher.captureReference(187), 89, 28, 28, this.push(1), BytecodeMatcher.captureReference(183), 78);
                }
            }.setMethod(this.refreshTextures2).addXref(1, new MethodRef("Minecraft", "getMaxTextureSize", "()I")).addXref(2, new ClassRef("Stitcher")).addXref(3, new MethodRef("Stitcher", "<init>", "(IIZ)V")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), this.reference(185, mapClear));
                }
            }.setMethod(registerTiles).addXref(1, this.texturesByName));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "register additional tiles";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, TextureMapMod.this.texturesByName), this.reference(185, mapEntrySet), this.reference(185, setIterator), BytecodeMatcher.anyASTORE);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(183, registerTiles), 42, 42, this.reference(180, TextureMapMod.this.basePath), 42, this.reference(180, TextureMapMod.this.texturesByName), this.reference(184, new MethodRef("com.prupe.mcpatcher.TileLoader", "registerIcons", "(LTextureMap;Ljava/lang/String;Ljava/util/Map;)V")));
                }
            }.setInsertBefore(true).targetMethod(this.refreshTextures2));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override tile texture paths";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(187, sbClass), 89, BinaryRegex.or(BinaryRegex.build(this.reference(183, sbInit0), 42, this.reference(180, TextureMapMod.this.basePath), this.reference(182, sbAppend)), BinaryRegex.build(42, this.reference(180, TextureMapMod.this.basePath), BinaryRegex.optional(BinaryRegex.build(new Object[]{this.reference(184, strValueOf)})), this.reference(183, sbInit1))), BinaryRegex.capture(BinaryRegex.any(1, 5)), this.reference(182, sbAppend), BinaryRegex.capture(BytecodeMatcher.anyLDC), this.reference(182, sbAppend), this.reference(182, sbToString));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, TextureMapMod.this.basePath), this.getCaptureGroup(1), this.getCaptureGroup(2), this.reference(184, new MethodRef("com.prupe.mcpatcher.TileLoader", "getOverridePath", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;")));
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "check for clock/compass textures";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.or(BinaryRegex.build(this.push("clock")), BinaryRegex.build(this.push("compass")))), 43, this.reference(182, strEquals));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 43, this.getCaptureGroup(1), this.reference(184, new MethodRef("com.prupe.mcpatcher.TileLoader", "isSpecialTexture", "(LTextureMap;Ljava/lang/String;Ljava/lang/String;)Z")));
                }
            }.targetMethod(this.registerIcon));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override tile image";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, BinaryRegex.capture(BytecodeMatcher.anyALOAD), BytecodeMatcher.anyReference(185), this.reference(184, readImage));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.getCaptureGroup(1), this.reference(184, new MethodRef("com.prupe.mcpatcher.TileLoader", "getOverrideImage", "(Ljava/lang/String;)Ljava/awt/image/BufferedImage;")));
                }
            });
        }
    }

    private class IconRegisterMod
    extends Mod.ClassMod {
        IconRegisterMod() {
            InterfaceMethodRef registerIcon = new InterfaceMethodRef(this.getDeobfClass(), "registerIcon", "(Ljava/lang/String;)LIcon;");
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(registerIcon).setInterfaceOnly(true));
        }
    }

    private class TessellatorMod
    extends BaseMod.TessellatorMod {
        TessellatorMod() {
            super(BaseTilesheetMod.this);
            MethodRef constructor = new MethodRef(this.getDeobfClass(), "<init>", "(I)V");
            MethodRef reset = new MethodRef(this.getDeobfClass(), "reset", "()V");
            FieldRef isDrawing = new FieldRef(this.getDeobfClass(), "isDrawing", "Z");
            FieldRef drawMode = new FieldRef(this.getDeobfClass(), "drawMode", "I");
            final FieldRef textureMap = new FieldRef(this.getDeobfClass(), "textureMap", "LTextureMap;");
            FieldRef bufferSize = new FieldRef(this.getDeobfClass(), "bufferSize", "I");
            FieldRef addedVertices = new FieldRef(this.getDeobfClass(), "addedVertices", "I");
            FieldRef vertexCount = new FieldRef(this.getDeobfClass(), "vertexCount", "I");
            FieldRef rawBufferIndex = new FieldRef(this.getDeobfClass(), "rawBufferIndex", "I");
            final FieldRef children = new FieldRef(this.getDeobfClass(), "children", "Ljava/util/Map;");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.push(4), 112, BinaryRegex.any(0, 1000), 42, 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181), 42, 89, BytecodeMatcher.captureReference(180), this.push(8), 96, BytecodeMatcher.anyReference(181));
                }
            }.setMethod(this.addVertex).addXref(1, addedVertices).addXref(2, vertexCount).addXref(3, rawBufferIndex));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), BinaryRegex.any(0, 50), this.push("Already tesselating!"), BinaryRegex.any(0, 100), 42, BytecodeMatcher.captureReference(183), 42, 27, BytecodeMatcher.captureReference(181));
                }
            }.setMethod(this.startDrawing).addXref(1, isDrawing).addXref(2, reset).addXref(3, drawMode));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, this.push(7), BytecodeMatcher.captureReference(182), 177, BinaryRegex.end());
                }
            }.setMethod(this.startDrawingQuads).addXref(1, this.startDrawing));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, bufferSize));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.instance).accessFlag(8, true));
            for (JavaRef ref : new JavaRef[]{constructor, this.startDrawing, isDrawing, drawMode, this.draw, reset, bufferSize, addedVertices, vertexCount, rawBufferIndex}) {
                this.addPatch(new ClassMod.MakeMemberPublicPatch(ref));
            }
            this.addPatch((ClassMod)this.new ClassMod.AddFieldPatch(textureMap));
            this.addPatch((ClassMod)this.new ClassMod.AddFieldPatch(children));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "initialize new fields";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(187, new ClassRef("java/util/WeakHashMap")), 89, this.reference(183, new MethodRef("java/util/WeakHashMap", "<init>", "()V")), this.reference(181, children), this.push(this.getMethodInfo().getDescriptor().contains("()") ? 0 : 1), this.reference(179, new FieldRef("com.prupe.mcpatcher.TessellatorUtils", "haveBufferSize", "Z")));
                }
            }.setInsertBefore(true).matchConstructorOnly(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "bind texture before drawing";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(42, BytecodeMatcher.anyReference(180)), BytecodeMatcher.anyReference(178)), this.reference(182, new MethodRef("java/nio/IntBuffer", "clear", "()Ljava/nio/Buffer;")), 87);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, textureMap), 198, this.branch("A"), this.push(3553), 42, this.reference(180, textureMap), this.reference(182, new MethodRef("TextureMap", "getGlTextureId", "()I")), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glBindTexture", "(II)V")), this.label("A"));
                }
            }.setInsertBefore(true).targetMethod(this.draw));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "reset children";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.prupe.mcpatcher.TessellatorUtils", "resetChildren", "(LTessellator;)V")));
                }
            }.setInsertBefore(true).targetMethod(reset));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "draw children";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(0), 42, this.reference(184, new MethodRef("com.prupe.mcpatcher.TessellatorUtils", "drawChildren", "(ILTessellator;)I")), 60);
                }
            }.targetMethod(this.draw));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "startDrawing children";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 27, this.reference(184, new MethodRef("com.prupe.mcpatcher.TessellatorUtils", "startDrawingChildren", "(LTessellator;I)V")));
                }
            }.setInsertBefore(true).targetMethod(this.startDrawing));
        }
    }
}

