/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseTexturePackMod
extends Mod {
    private static final List<EarlyInitEntry> earlyInitMethods = new ArrayList<EarlyInitEntry>();
    protected final MethodRef earlyInitialize = new MethodRef("com.prupe.mcpatcher.TexturePackChangeHandler", "earlyInitialize", "(Ljava/lang/String;Ljava/lang/String;)V");
    protected final MethodRef checkForTexturePackChange = new MethodRef("com.prupe.mcpatcher.TexturePackChangeHandler", "checkForTexturePackChange", "()V");
    protected final MethodRef beforeChange1 = new MethodRef("com.prupe.mcpatcher.TexturePackChangeHandler", "beforeChange1", "(Z)V");
    protected final MethodRef afterChange1 = new MethodRef("com.prupe.mcpatcher.TexturePackChangeHandler", "afterChange1", "(Z)V");

    protected BaseTexturePackMod() {
        this.name = "__TexturePackBase";
        this.author = "MCPatcher";
        this.description = "Internal mod required by the patcher.";
        this.version = "4.0";
        this.addClassMod(new MinecraftMod());
        this.addClassMod(new TextureManagerMod());
        this.addClassMod(new BaseMod.TextureUtilsMod(this));
        this.addClassMod(new TextureBaseMod());
        this.addClassMod(new BaseMod.TextureNamedMod(this));
        this.addClassMod(new BaseMod.IconMod(this));
        this.addClassMod(new BaseMod.TextureMapMod(this));
        this.addClassMod(new BaseMod.TextureWithDataMod(this));
        this.addClassMod(new IResourcePackMod());
        this.addClassMod(new ResourcePackDefaultMod());
        this.addClassMod(new ResourcePackBaseMod());
        this.addClassMod(new ResourcePackZipMod());
        this.addClassMod(new ResourcePackFolderMod());
        this.addClassMod(new IResourceBundleMod());
        this.addClassMod(new ITextureResourceBundleMod());
        this.addClassMod(new TextureResourceBundleMod());
        this.addClassMod(new ResourceBundleMod());
        this.addClassMod(new BaseMod.IResourceMod(this));
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassFile("com.prupe.mcpatcher.TexturePackAPI");
        this.addClassFile("com.prupe.mcpatcher.TexturePackAPI$1");
        this.addClassFile("com.prupe.mcpatcher.TexturePackAPI$2");
        this.addClassFile("com.prupe.mcpatcher.TexturePackChangeHandler");
        this.addClassFile("com.prupe.mcpatcher.TexturePackChangeHandler$1");
        this.addClassFile("com.prupe.mcpatcher.WeightedIndex");
        this.addClassFile("com.prupe.mcpatcher.WeightedIndex$1");
        this.addClassFile("com.prupe.mcpatcher.WeightedIndex$2");
        this.addClassFile("com.prupe.mcpatcher.BlendMethod");
    }

    @Override
    public String[] getLoggingCategories() {
        return new String[]{"Texture Pack"};
    }

    static void clearEarlyInitializeMethods() {
        earlyInitMethods.clear();
    }

    public static void earlyInitialize(int order, String className, String methodName) {
        earlyInitMethods.add(new EarlyInitEntry(order, className, methodName));
    }

    private class ResourceBundleMod
    extends Mod.ClassMod {
        ResourceBundleMod() {
            this.setInterfaces("IResourceBundle");
            FieldRef resourcePacks = new FieldRef(this.getDeobfClass(), "resourcePacks", "Ljava/util/List;");
            this.addClassSignature(new ClassMod.ConstSignature(".mcmeta"));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(resourcePacks));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(resourcePacks));
        }
    }

    private class TextureResourceBundleMod
    extends Mod.ClassMod {
        TextureResourceBundleMod() {
            this.setInterfaces("ITextureResourceBundle");
            final ClassRef fnfException = new ClassRef("java/io/FileNotFoundException");
            FieldRef namespaceMap = new FieldRef(this.getDeobfClass(), "namespaceMap", "Ljava/util/Map;");
            final MethodRef fnfInit = new MethodRef("java/io/FileNotFoundException", "<init>", "(Ljava/lang/String;)V");
            MethodRef getResource = new MethodRef(this.getDeobfClass(), "getResource", "(LResourceAddress;)LIResource;");
            MethodRef loadResources = new MethodRef(this.getDeobfClass(), "loadResources", "()V");
            MethodRef addressToString = new MethodRef("ResourceAddress", "toString", "()Ljava/lang/String;");
            InterfaceMethodRef mapClear = new InterfaceMethodRef("java/util/Map", "clear", "()V");
            final InterfaceMethodRef listIterator = new InterfaceMethodRef("java/util/List", "iterator", "()Ljava/util/Iterator;");
            this.addClassSignature(new ClassMod.ConstSignature(mapClear));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(187, fnfException), 89, 43, BytecodeMatcher.captureReference(182), this.reference(183, fnfInit), 191);
                }
            }.setMethod(getResource).addXref(1, addressToString));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(185, listIterator)});
                }
            }.setMethod(loadResources));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(namespaceMap));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(namespaceMap));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "before texture pack change";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(0), this.reference(184, BaseTexturePackMod.this.beforeChange1));
                }
            }.targetMethod(loadResources));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "after texture pack change";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(0), this.reference(184, BaseTexturePackMod.this.afterChange1));
                }
            }.setInsertBefore(true).targetMethod(loadResources));
        }
    }

    private class ITextureResourceBundleMod
    extends Mod.ClassMod {
        ITextureResourceBundleMod() {
            this.setInterfaces("IResourceBundle");
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(new InterfaceMethodRef(this.getDeobfClass(), "method1", "(Ljava/util/List;)V"), new InterfaceMethodRef(this.getDeobfClass(), "method2", "(LILoadableResource;)V")).setInterfaceOnly(true));
        }
    }

    private class IResourceBundleMod
    extends Mod.ClassMod {
        IResourceBundleMod() {
            boolean newMCMeta = Mod.getMinecraftVersion().compareTo("13w26a") >= 0;
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(newMCMeta ? new InterfaceMethodRef(this.getDeobfClass(), "getNamespaces", "()Ljava/util/Set;") : null, new InterfaceMethodRef(this.getDeobfClass(), "getResource", "(LResourceAddress;)LIResource;"), newMCMeta ? new InterfaceMethodRef(this.getDeobfClass(), "getMCMeta", "(LResourceAddress;)Ljava/util/List;") : null).setInterfaceOnly(true));
        }
    }

    private class ResourcePackFolderMod
    extends Mod.ClassMod {
        ResourcePackFolderMod() {
            this.setParentClass("ResourcePackBase");
            this.addClassSignature(new ClassMod.ConstSignature("assets/"));
            this.addClassSignature(new ClassMod.ConstSignature(new ClassRef("java/io/FileInputStream")));
        }
    }

    private class ResourcePackZipMod
    extends Mod.ClassMod {
        ResourcePackZipMod() {
            this.setParentClass("ResourcePackBase");
            FieldRef zipFile = new FieldRef(this.getDeobfClass(), "zipFile", "Ljava/util/zip/ZipFile;");
            this.addClassSignature(new ClassMod.ConstSignature("assets/"));
            this.addClassSignature(new ClassMod.ConstSignature(new ClassRef("java/util/zip/ZipFile")));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(zipFile));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(zipFile));
        }
    }

    private class ResourcePackBaseMod
    extends Mod.ClassMod {
        ResourcePackBaseMod() {
            this.setInterfaces("IResourcePack");
            FieldRef file = new FieldRef(this.getDeobfClass(), "file", "Ljava/io/File;");
            this.addClassSignature(new ClassMod.ConstSignature("assets"));
            this.addClassSignature(new ClassMod.ConstSignature("pack.mcmeta"));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(file));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(file));
        }
    }

    private class ResourcePackDefaultMod
    extends Mod.ClassMod {
        ResourcePackDefaultMod() {
            this.setInterfaces("IResourcePack");
            FieldRef file = new FieldRef(this.getDeobfClass(), "file", "Ljava/io/File;");
            this.addClassSignature(new ClassMod.ConstSignature("minecraft"));
            this.addClassSignature(new ClassMod.ConstSignature("/assets/minecraft/"));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(file));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(file));
        }
    }

    private class IResourcePackMod
    extends Mod.ClassMod {
        IResourcePackMod() {
            String nsType = Mod.getMinecraftVersion().compareTo("13w25c") >= 0 ? "Set" : "List";
            boolean newMCMeta = Mod.getMinecraftVersion().compareTo("13w26a") >= 0;
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(new InterfaceMethodRef(this.getDeobfClass(), "getInputStream", "(LResourceAddress;)Ljava/io/InputStream;"), new InterfaceMethodRef(this.getDeobfClass(), "hasResource", "(LResourceAddress;)Z"), new InterfaceMethodRef(this.getDeobfClass(), "getNamespaces", "()Ljava/util/" + nsType + ";"), newMCMeta ? new InterfaceMethodRef(this.getDeobfClass(), "getMCMeta", "(LMCMetaParser;Ljava/lang/String;)LMCMeta;") : new InterfaceMethodRef(this.getDeobfClass(), "getPackInfo", "(LMCMetaParser;)LMCMetaResourcePackInfo;"), new InterfaceMethodRef(this.getDeobfClass(), "getPackIcon", "()Ljava/awt/image/BufferedImage;"), newMCMeta ? new InterfaceMethodRef(this.getDeobfClass(), "getName", "()Ljava/lang/String;") : null).setInterfaceOnly(true));
        }
    }

    private class TexturePackListMod
    extends Mod.ClassMod {
        TexturePackListMod() {
            FieldRef selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", "LITexturePack;");
            FieldRef mc = new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;");
            MethodRef getSelectedTexturePack = new MethodRef(this.getDeobfClass(), "getSelectedTexturePack", "()LITexturePack;");
            MethodRef setTexturePack = new MethodRef(this.getDeobfClass(), "setTexturePack", "(LITexturePack;)Z");
            MethodRef updateAvailableTexturePacks = new MethodRef(this.getDeobfClass(), "updateAvailableTexturePacks", "()V");
            MethodRef onDownloadFinished = new MethodRef(this.getDeobfClass(), "onDownloadFinished", "()V");
            MethodRef scheduleTexturePackRefresh = new MethodRef("Minecraft", "scheduleTexturePackRefresh", "()V");
            this.addClassSignature(new ClassMod.ConstSignature(".zip"));
            this.addClassSignature(new ClassMod.ConstSignature("texturepacks"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 43, this.reference(185, new InterfaceMethodRef("java/util/List", "removeAll", "(Ljava/util/Collection;)Z")), 87);
                }
            }.setMethod(updateAvailableTexturePacks));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(182));
                }
            }.setMethod(onDownloadFinished).addXref(1, mc).addXref(2, scheduleTexturePackRefresh));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(setTexturePack));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(selectedTexturePack).accessFlag(2, true).accessFlag(8, false).accessFlag(16, false));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(getSelectedTexturePack).accessFlag(1, true).accessFlag(8, false));
        }
    }

    private class TextureBaseMod
    extends BaseMod.TextureBaseMod {
        TextureBaseMod() {
            super(BaseTexturePackMod.this);
            final MethodRef unloadGLTexture = new MethodRef(this.getDeobfClass(), "unloadGLTexture", "()V");
            this.addPatch(new ClassMod.MakeMemberPublicPatch(this.glTextureId));
            this.addPatch(new ClassMod.AddMethodPatch(unloadGLTexture){

                @Override
                public byte[] generateMethod() {
                    return this.buildCode(42, this.reference(180, TextureBaseMod.this.glTextureId), 155, TextureBaseMod.this.branch("A"), 42, this.reference(180, TextureBaseMod.this.glTextureId), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glDeleteTextures", "(I)V")), 42, this.push(-1), this.reference(181, TextureBaseMod.this.glTextureId), TextureBaseMod.this.label("A"), 177);
                }
            });
            this.addPatch(new ClassMod.AddMethodPatch(new MethodRef(this.getDeobfClass(), "finalize", "()V")){

                @Override
                public byte[] generateMethod() {
                    return this.buildCode(42, this.reference(182, unloadGLTexture), 177);
                }
            });
        }
    }

    private class TextureManagerMod
    extends Mod.ClassMod {
        TextureManagerMod() {
            FieldRef texturesByName = new FieldRef(this.getDeobfClass(), "texturesByName", "Ljava/util/Map;");
            MethodRef bindTexture = new MethodRef(this.getDeobfClass(), "bindTexture", "(LResourceAddress;)V");
            MethodRef getTexture = new MethodRef(this.getDeobfClass(), "getTexture", "(LResourceAddress;)LITexture;");
            MethodRef refreshTextures = new MethodRef(this.getDeobfClass(), "refreshTextures", "(LIResourceBundle;)V");
            this.addClassSignature(new ClassMod.ConstSignature("dynamic/%s_%d"));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(texturesByName));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(bindTexture).accessFlag(8, false));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(getTexture).accessFlag(8, false));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(refreshTextures));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(texturesByName));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            super(BaseTexturePackMod.this);
            final ClassRef textureResourceBundleClass = new ClassRef("TextureResourceBundle");
            MethodRef getTextureManager = new MethodRef(this.getDeobfClass(), "getTextureManager", "()LTextureManager;");
            MethodRef getResourceBundle = new MethodRef(this.getDeobfClass(), "getResourceBundle", "()LIResourceBundle;");
            MethodRef startGame = new MethodRef(this.getDeobfClass(), "startGame", "()V");
            MethodRef runGameLoop = new MethodRef(this.getDeobfClass(), "runGameLoop", "()V");
            final MethodRef setTitle = new MethodRef("org/lwjgl/opengl/Display", "setTitle", "(Ljava/lang/String;)V");
            final MethodRef isCloseRequested = new MethodRef("org/lwjgl/opengl/Display", "isCloseRequested", "()Z");
            final MethodRef glViewport = new MethodRef("org.lwjgl.opengl.GL11", "glViewport", "(IIII)V");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, setTitle)});
                }
            }.setMethod(startGame));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, isCloseRequested)});
                }
            }.setMethod(runGameLoop));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(getResourceBundle));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(getTextureManager));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "init texture pack handlers on startup";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(187, textureResourceBundleClass), BinaryRegex.any(0, 500), this.reference(184, glViewport));
                }

                @Override
                public byte[] getReplacementBytes() {
                    byte[] earlyInitCode = new byte[]{};
                    Collections.sort(earlyInitMethods);
                    for (EarlyInitEntry entry : earlyInitMethods) {
                        earlyInitCode = this.buildCode(earlyInitCode, this.push(entry.className), this.push(entry.methodName), this.reference(184, BaseTexturePackMod.this.earlyInitialize));
                    }
                    return this.buildCode(earlyInitCode, this.push(1), this.reference(184, BaseTexturePackMod.this.beforeChange1), this.getMatch(), this.push(1), this.reference(184, BaseTexturePackMod.this.afterChange1));
                }
            }.targetMethod(startGame));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "check for texture pack change";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, BaseTexturePackMod.this.checkForTexturePackChange)});
                }
            }.targetMethod(runGameLoop));
        }
    }

    private static class EarlyInitEntry
    implements Comparable<EarlyInitEntry> {
        private final int order;
        private final String className;
        private final String methodName;

        EarlyInitEntry(int order, String className, String methodName) {
            this.order = order;
            this.className = className;
            this.methodName = methodName;
        }

        @Override
        public int compareTo(EarlyInitEntry o) {
            return this.order - o.order;
        }
    }
}

