/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.FieldRef;
import java.io.IOException;

class TileSizePatch
extends BytecodePatch {
    protected Object value;
    protected String field;
    protected String type;
    protected String extra = "";

    TileSizePatch(Object value, String field) {
        this.value = value;
        this.field = field;
        this.type = field.startsWith("float_") ? "F" : (field.startsWith("double_") ? "D" : (field.startsWith("long_") ? "J" : "I"));
    }

    String prefix() {
        return "";
    }

    String suffix() {
        return "";
    }

    public String getDescription() {
        return String.format("%s%s%s -> %s", this.extra, this.value.toString(), this.type.equals("I") ? "" : this.type, this.field);
    }

    public String getMatchExpression() {
        return this.buildExpression(BinaryRegex.capture(this.prefix()), this.push(this.value), BinaryRegex.capture(this.suffix()));
    }

    public byte[] getReplacementBytes() throws IOException {
        return this.buildCode(this.getCaptureGroup(1), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", this.field, this.type)), this.getCaptureGroup(2));
    }

    static class ToolPixelTopPatch
    extends BytecodePatch {
        ToolPixelTopPatch() {
        }

        public String getDescription() {
            return "tool pixel top";
        }

        public String getMatchExpression() {
            return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyFLOAD, 106)), this.push(Float.valueOf(0.0625f)), BinaryRegex.capture(BinaryRegex.build(98, BytecodeMatcher.anyFSTORE)));
        }

        public byte[] getReplacementBytes() throws IOException {
            return this.buildCode(this.getCaptureGroup(1), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "float_reciprocal", "F")), this.getCaptureGroup(2));
        }
    }

    static class ToolTexPatch
    extends BytecodePatch {
        ToolTexPatch() {
        }

        public String getDescription() {
            return "tool tex calculation";
        }

        public String getMatchExpression() {
            return this.buildExpression(this.push(16), BinaryRegex.capture(BinaryRegex.subset(new byte[]{112, 108}, true)), this.push(16), 104, 134, BinaryRegex.capture(BinaryRegex.or(BinaryRegex.build(11), BinaryRegex.build(this.push(Float.valueOf(15.99f))))), 98, this.push(Float.valueOf(256.0f)));
        }

        public byte[] getReplacementBytes() throws IOException {
            byte[] offset = this.getCaptureGroup(2);
            if (offset[0] != 11) {
                offset = this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "float_sizeMinus0_01", "F"));
            }
            return this.buildCode(this.push(16), this.getCaptureGroup(1), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), 104, 134, offset, 98, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "float_size16", "F")));
        }
    }

    static class GetRGBPatch
    extends BytecodePatch {
        GetRGBPatch() {
        }

        public String getDescription() {
            return "getRGB(...16,16,...16) -> getRGB(...int_size,int_size,...int_size)";
        }

        public String getMatchExpression() {
            return this.buildExpression(this.push(16), this.push(16), BinaryRegex.capture(this.buildExpression(42, 180, BinaryRegex.any(), BinaryRegex.any(), 3)), this.push(16));
        }

        public byte[] getReplacementBytes() throws IOException {
            byte[] getField = this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I"));
            return this.buildCode(getField, getField, this.getCaptureGroup(1), getField);
        }
    }

    static class ArraySize2DPatch
    extends TileSizePatch {
        private int dimension;

        public ArraySize2DPatch(Object value, String field, int dimension) {
            super(value, field);
            this.dimension = dimension;
            this.extra = "array size " + dimension + "x";
        }

        public String prefix() {
            return this.buildExpression(this.push(this.dimension));
        }

        public String suffix() {
            return this.buildExpression(197);
        }
    }

    static class ArraySizePatch
    extends TileSizePatch {
        public ArraySizePatch(Object value, String field) {
            super(value, field);
            this.extra = "array size ";
        }

        public String suffix() {
            return this.buildExpression(188);
        }
    }

    static class DivPatch
    extends TileSizePatch {
        public DivPatch(Object value, String field) {
            super(value, field);
            this.extra = "/ ";
        }

        public String suffix() {
            return this.buildExpression(108, 135);
        }
    }

    static class ModPatch
    extends TileSizePatch {
        public ModPatch(Object value, String field) {
            super(value, field);
            this.extra = "% ";
        }

        public String suffix() {
            return this.buildExpression(112);
        }
    }

    static class MultiplyPatch
    extends TileSizePatch {
        public MultiplyPatch(Object value, String field) {
            super(value, field);
            this.extra = "* ";
        }

        public String suffix() {
            return this.buildExpression(104);
        }
    }

    static class BitMaskPatch
    extends TileSizePatch {
        public BitMaskPatch(Object value, String field) {
            super(value, field);
            this.extra = "& ";
        }

        public String suffix() {
            return this.buildExpression(126);
        }
    }

    static class IfLessPatch
    extends TileSizePatch {
        public IfLessPatch(Object value, String field) {
            super(value, field);
            this.extra = "if i < ";
        }

        public String suffix() {
            return this.buildExpression(161);
        }
    }

    static class IfGreaterPatch
    extends TileSizePatch {
        public IfGreaterPatch(Object value, String field) {
            super(value, field);
            this.extra = "if i > ";
        }

        public String suffix() {
            return this.buildExpression(163);
        }
    }

    static class WhilePatch
    extends TileSizePatch {
        public WhilePatch(Object value, String field) {
            super(value, field);
            this.extra = "while i < ";
        }

        public String suffix() {
            return this.buildExpression(162);
        }
    }
}

