/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;

public class RandomMobs
extends Mod {
    private static final String EXTRA_INFO_CLASS = "com.pclewis.mcpatcher.mod.MobRandomizer$ExtraInfo";

    public RandomMobs(MinecraftVersion minecraftVersion) {
        this.name = "Random Mobs";
        this.author = "Balthichou";
        this.description = "Randomize mob skins if texture pack supports it. Based on Balthichou's mod.";
        this.website = "http://www.minecraftforum.net/topic/244172-";
        this.version = "1.4";
        this.addDependency("__TexturePackBase");
        this.addClassMod(new RenderLivingMod());
        this.addClassMod(new RenderEyesMod("Spider"));
        if (minecraftVersion.compareTo("Beta 1.8 Prerelease 1") >= 0) {
            this.addClassMod(new RenderEyesMod("Enderman"));
        }
        this.addClassMod(new EntityMod());
        this.addClassMod(new EntityLivingMod());
        this.addClassMod(new NBTTagCompoundMod());
        if (minecraftVersion.compareTo("Beta 1.9") >= 0) {
            this.addClassMod(new BaseMod.TessellatorMod(minecraftVersion));
            this.addClassMod(new RenderMod());
            this.addClassMod(new RenderSnowmanMod());
            this.addClassMod(new RenderMooshroomMod());
        }
        this.addClassMod(new MiscSkinMod("RenderSheep", "/mob/sheep_fur.png"));
        this.addClassMod(new MiscSkinMod("RenderWolf", "/mob/wolf_collar.png"));
        this.addClassFile("com.pclewis.mcpatcher.mod.MobRandomizer");
        this.addClassFile("com.pclewis.mcpatcher.mod.MobRandomizer$1");
        this.addClassFile(EXTRA_INFO_CLASS);
        this.addClassFile("com.pclewis.mcpatcher.mod.MobRuleList");
        this.addClassFile("com.pclewis.mcpatcher.mod.MobRuleList$MobRuleEntry");
        this.addClassFile("com.pclewis.mcpatcher.mod.MobOverlay");
    }

    private class MiscSkinMod
    extends ClassMod {
        private final String className;

        MiscSkinMod(String className, final String texture) {
            final MethodRef randomTexture = new MethodRef("com.pclewis.mcpatcher.mod.MobRandomizer", "randomTexture", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;");
            this.className = className;
            this.setMultipleMatchesAllowed(true);
            this.addClassSignature(new ConstSignature(texture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "randomize " + texture;
                }

                public String getMatchExpression() {
                    if ((this.getMethodInfo().getAccessFlags() & 8) == 0 && this.getMethodInfo().getDescriptor().startsWith("(L")) {
                        return this.buildExpression(this.push(texture));
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, this.getMatch(), this.reference(184, randomTexture));
                }
            });
        }

        public String getDeobfClass() {
            return this.className;
        }
    }

    private class RenderMooshroomMod
    extends ClassMod {
        RenderMooshroomMod() {
            this.setParentClass("RenderLiving");
            final FieldRef renderBlocks = new FieldRef(this.getDeobfClass(), "renderBlocks", "LRenderBlocks;");
            final FieldRef mushroomRed = new FieldRef("Block", "mushroomRed", "LBlockFlower;");
            MethodRef renderEquippedItems = new MethodRef(this.getDeobfClass(), "renderEquippedItems1", "(LEntityMooshroom;F)V");
            MethodRef loadTexture = new MethodRef(this.getDeobfClass(), "loadTexture", "(Ljava/lang/String;)V");
            final MethodRef glEnable = new MethodRef("org.lwjgl.opengl.GL11", "glEnable", "(I)V");
            final MethodRef glPushMatrix = new MethodRef("org.lwjgl.opengl.GL11", "glPushMatrix", "()V");
            final MethodRef renderBlockAsItem = new MethodRef("RenderBlocks", "renderBlockAsItem", "(LBlock;IF)V");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push("/terrain.png"), BytecodeMatcher.captureReference(182), this.push(2884), this.reference(184, glEnable), this.reference(184, glPushMatrix), BinaryRegex.any(0, 100), 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(178), this.push(0), this.push(Float.valueOf(1.0f)), BytecodeMatcher.captureReference(182));
                }
            }.setMethod(renderEquippedItems).addXref(1, loadTexture).addXref(2, renderBlocks).addXref(3, mushroomRed).addXref(4, renderBlockAsItem));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "set up custom mooshroom overlay";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/terrain.png"));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, this.push("/terrain.png"), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MobOverlay", "setupMooshroom", "(LEntityLiving;Ljava/lang/String;)Ljava/lang/String;")));
                }
            }.targetMethod(renderEquippedItems));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "render mooshroom overlay";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, renderBlocks), this.reference(178, mushroomRed), this.push(0), this.push(Float.valueOf(1.0f)), this.reference(182, renderBlockAsItem));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MobOverlay", "renderMooshroomOverlay", "()Z")), 154, RenderMooshroomMod.this.branch("A"), this.getMatch(), RenderMooshroomMod.this.label("A"));
                }
            }.targetMethod(renderEquippedItems));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "finish mooshroom overlay";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MobOverlay", "finishMooshroom", "()V"))});
                }
            }.targetMethod(renderEquippedItems));
        }
    }

    private class RenderSnowmanMod
    extends ClassMod {
        RenderSnowmanMod() {
            this.setParentClass("RenderLiving");
            MethodRef renderEquippedItems = new MethodRef(this.getDeobfClass(), "renderEquippedItems1", "(LEntitySnowman;F)V");
            final MethodRef loadTexture = new MethodRef(this.getDeobfClass(), "loadTexture", "(Ljava/lang/String;)V");
            final MethodRef glTranslatef = new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V");
            final FieldRef snowmanOverlayTexture = new FieldRef("com.pclewis.mcpatcher.mod.MobOverlay", "snowmanOverlayTexture", "Ljava/lang/String;");
            final MethodRef setupSnowman = new MethodRef("com.pclewis.mcpatcher.mod.MobOverlay", "setupSnowman", "(LEntityLiving;)Z");
            final MethodRef renderSnowmanOverlay = new MethodRef("com.pclewis.mcpatcher.mod.MobOverlay", "renderSnowmanOverlay", "()V");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(0.625f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(-0.34375f)), this.push(Float.valueOf(0.0f)), this.reference(184, glTranslatef));
                }
            }.setMethod(renderEquippedItems));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "render snowman overlay";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyReference(180), 43, 45, 3, BytecodeMatcher.anyReference(182));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, this.reference(184, setupSnowman), 153, RenderSnowmanMod.this.branch("A"), 42, this.reference(178, snowmanOverlayTexture), this.reference(182, loadTexture), this.reference(184, renderSnowmanOverlay), 167, RenderSnowmanMod.this.branch("B"), RenderSnowmanMod.this.label("A"), this.getMatch(), RenderSnowmanMod.this.label("B"));
                }
            }.targetMethod(renderEquippedItems));
        }
    }

    private class NBTTagCompoundMod
    extends ClassMod {
        NBTTagCompoundMod() {
            this.addClassSignature(new ConstSignature(new ClassRef("java.util.HashMap")));
            this.addClassSignature(new ConstSignature(" entries"));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "getLong", "(Ljava/lang/String;)J")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "setLong", "(Ljava/lang/String;J)V")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "getInteger", "(Ljava/lang/String;)I")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "setInteger", "(Ljava/lang/String;I)V")));
        }
    }

    private class EntityLivingMod
    extends ClassMod {
        EntityLivingMod() {
            MethodRef getEntityTexture = new MethodRef(this.getDeobfClass(), "getEntityTexture", "()Ljava/lang/String;");
            MethodRef writeToNBT = new MethodRef(this.getDeobfClass(), "writeToNBT", "(LNBTTagCompound;)V");
            MethodRef readFromNBT = new MethodRef(this.getDeobfClass(), "readFromNBT", "(LNBTTagCompound;)V");
            this.setParentClass("Entity");
            this.addClassSignature(new ConstSignature("/mob/char.png"));
            this.addClassSignature(new ConstSignature("Health"));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(getEntityTexture));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(writeToNBT, readFromNBT).accessFlag(1, true));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "write skin to nbt";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 43, this.reference(184, new MethodRef(RandomMobs.EXTRA_INFO_CLASS, "writeToNBT", "(LEntityLiving;LNBTTagCompound;)V")));
                }
            }.targetMethod(writeToNBT));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "read skin from nbt";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 43, this.reference(184, new MethodRef(RandomMobs.EXTRA_INFO_CLASS, "readFromNBT", "(LEntityLiving;LNBTTagCompound;)V")));
                }
            }.targetMethod(readFromNBT));
        }
    }

    private class EntityMod
    extends ClassMod {
        EntityMod() {
            this.addClassSignature(new ConstSignature("Pos"));
            this.addClassSignature(new ConstSignature("Motion"));
            this.addClassSignature(new ConstSignature("Rotation"));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 42, 39, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 41, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 24, 5, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "setPositionAndRotation", "(DDDFF)V")).addXref(1, new FieldRef(this.getDeobfClass(), "posX", "D")).addXref(2, new FieldRef(this.getDeobfClass(), "prevPosX", "D")).addXref(3, new FieldRef(this.getDeobfClass(), "posY", "D")).addXref(4, new FieldRef(this.getDeobfClass(), "prevPosY", "D")).addXref(5, new FieldRef(this.getDeobfClass(), "posZ", "D")).addXref(6, new FieldRef(this.getDeobfClass(), "prevPosZ", "D")));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "entityId", "I")).accessFlag(1, true).accessFlag(8, false));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "nextEntityID", "I")).accessFlag(2, true).accessFlag(8, true));
        }
    }

    private class RenderEyesMod
    extends ClassMod {
        private String mobName;
        private String eyeTexture;

        RenderEyesMod(String mob) {
            this.mobName = mob;
            this.eyeTexture = "/mob/" + this.mobName.toLowerCase() + "_eyes.png";
            this.addClassSignature(new ConstSignature(this.eyeTexture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "override " + RenderEyesMod.this.mobName.toLowerCase() + " eye texture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(RenderEyesMod.this.eyeTexture));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, this.push(RenderEyesMod.this.eyeTexture), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MobRandomizer", "randomTexture", "(LEntityLiving;Ljava/lang/String;)Ljava/lang/String;")));
                }
            });
        }

        public String getDeobfClass() {
            return "Render" + this.mobName;
        }
    }

    private class RenderLivingMod
    extends ClassMod {
        RenderLivingMod() {
            this.setParentClass("Render");
            this.addClassSignature(new ConstSignature(Float.valueOf(180.0f)));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(11, this.push(Float.valueOf(-24.0f)), BytecodeMatcher.anyFLOAD, 106, this.push(Float.valueOf(0.0078125f)), 102, 11, this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V")));
                }
            }.setMethodName("doRenderLiving"));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "replace mob textures";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyALOAD), this.reference(182, new MethodRef("EntityLiving", "getEntityTexture", "()Ljava/lang/String;")));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MobRandomizer", "randomTexture", "(LEntityLiving;)Ljava/lang/String;")));
                }
            });
        }
    }

    private class RenderMod
    extends ClassMod {
        RenderMod() {
            this.addClassSignature(new ConstSignature("/terrain.png"));
            this.addClassSignature(new ConstSignature("%clamp%/misc/shadow.png"));
            this.addClassSignature(new ConstSignature(Float.valueOf(15.99f)));
            MethodRef loadTexture = new MethodRef(this.getDeobfClass(), "loadTexture", "(Ljava/lang/String;)V");
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(loadTexture).accessFlag(4, true).accessFlag(8, false));
        }
    }
}

