/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.TextureFX;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MipmapHelper {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    private static final String MIPMAP_PROPERTIES = "/mipmap.properties";
    private static final boolean mipmapSupported;
    private static final boolean mipmapEnabled;
    private static final int maxMipmapLevel;
    private static final boolean useMipmap;
    private static final int mipmapAlignment;
    private static final boolean anisoSupported;
    private static final int anisoLevel;
    private static final int anisoMax;
    private static final boolean lodSupported;
    private static int lodBias;
    private static int bgColorFix;
    public static int currentLevel;
    private static final HashMap<String, Integer> mipmapType;
    private static final int MIPMAP_NONE = 0;
    private static final int MIPMAP_BASIC = 1;
    private static final int MIPMAP_ALPHA = 2;

    public static void setupTexture(RenderEngine renderEngine, BufferedImage image, int texture, String textureName) {
        if (texture < 0 || image == null) {
            return;
        }
        ArrayList<BufferedImage> mipmapImages = MipmapHelper.getMipmapsForTexture(image, textureName);
        MipmapHelper.setupTextureMipmaps(renderEngine, mipmapImages, texture, textureName);
    }

    private static ArrayList<BufferedImage> getMipmapsForTexture(BufferedImage image, String textureName) {
        int type = MipmapHelper.getMipmapType(textureName, image);
        ArrayList<BufferedImage> mipmapImages = new ArrayList<BufferedImage>();
        mipmapImages.add(image);
        if (type >= 1) {
            int height;
            int width = image.getWidth();
            if (MipmapHelper.getCustomMipmaps(mipmapImages, textureName, width, height = image.getHeight())) {
                logger.fine("using %d custom mipmaps for %s", mipmapImages.size() - 1, textureName);
            } else {
                int mipmaps = MipmapHelper.getMipmapLevels(textureName, image);
                if (mipmaps > 0) {
                    logger.fine("generating %d mipmaps for %s, alpha=%s", mipmaps, textureName, type >= 2);
                    BufferedImage origImage = image;
                    if (bgColorFix > 0 && type == 1) {
                        int fix;
                        for (fix = 0; fix < bgColorFix && width >> fix > 1 && height >> fix > 1; ++fix) {
                        }
                        BufferedImage scaledImage = new BufferedImage(width >> fix, height >> fix, 2);
                        Graphics2D graphics2D = scaledImage.createGraphics();
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        graphics2D.drawImage(image, 0, 0, width, height, null);
                        MipmapHelper.setBackgroundColor(image, scaledImage);
                    }
                    for (int i = 0; i < mipmaps; ++i) {
                        origImage = MipmapHelper.scaleHalf(origImage);
                        if (type >= 2) {
                            image = origImage;
                        } else {
                            image = new BufferedImage(origImage.getColorModel(), origImage.copyData(null), origImage.getColorModel().isAlphaPremultiplied(), null);
                            MipmapHelper.resetOnOffTransparency(image);
                        }
                        mipmapImages.add(image);
                    }
                } else {
                    GL11.glTexParameteri((int)3553, (int)33085, (int)mipmaps);
                    type = 0;
                    if (textureName != null) {
                        mipmapType.put(textureName, type);
                    }
                }
            }
        }
        return mipmapImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupTextureMipmaps(RenderEngine renderEngine, ArrayList<BufferedImage> mipmapImages, int texture, String textureName) {
        try {
            int mipmaps = mipmapImages.size() - 1;
            for (currentLevel = 0; currentLevel <= mipmaps; ++currentLevel) {
                if (currentLevel == 1) {
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)33085, (int)mipmaps);
                    MipmapHelper.checkGLError("set GL_TEXTURE_MAX_LEVEL = %d", mipmaps);
                    if (anisoSupported && anisoLevel > 1) {
                        GL11.glTexParameterf((int)3553, (int)34046, (float)anisoLevel);
                        MipmapHelper.checkGLError("set GL_TEXTURE_MAX_ANISOTROPY_EXT = %f", anisoLevel);
                    }
                    if (lodSupported) {
                        GL11.glTexEnvi((int)34048, (int)34049, (int)lodBias);
                        MipmapHelper.checkGLError("set GL_TEXTURE_LOD_BIAS_EXT = %d", lodBias);
                    }
                }
                BufferedImage image = mipmapImages.get(currentLevel);
                renderEngine.setupTexture(image, texture);
                MipmapHelper.checkGLError("setupTexture %s#%d", textureName, currentLevel);
                if (currentLevel <= 0) continue;
                logger.finest("%s mipmap level %d (%dx%d)", textureName, currentLevel, image.getWidth(), image.getHeight());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            currentLevel = 0;
        }
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels, TextureFX textureFX) {
        GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)pixels);
        if (textureFX.tileImage == 0) {
            ByteOrder saveOrder = pixels.order();
            pixels.order(ByteOrder.BIG_ENDIAN);
            MipmapHelper.update("/terrain.png", xoffset, yoffset, width, height, pixels);
            pixels.order(saveOrder);
        }
    }

    private static void update(String texture, int x, int y, int w, int h, ByteBuffer imageData) {
        int mipmaps = MipmapHelper.getMipmapLevels();
        for (int i = 1; i <= mipmaps && ((x | y | w | h) & mipmapAlignment) == 0; ++i) {
            ByteBuffer newImage = ByteBuffer.allocateDirect(w * h);
            MipmapHelper.scaleHalf(imageData.asIntBuffer(), w, h, newImage.asIntBuffer());
            x >>= 1;
            y >>= 1;
            w >>= 1;
            h >>= 1;
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)i, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)i, (int)4097);
            if (width < 0 || height < 0) break;
            GL11.glTexSubImage2D((int)3553, (int)i, (int)x, (int)y, (int)w, (int)h, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)newImage.position(0)));
            MipmapHelper.checkGLError("glTexSubImage2D(%d, %d, %d, %d, %d, %d), width %d, height %d, mipmaps %d", i, x, y, w, h, newImage.limit(), width, height, mipmaps);
            imageData = newImage;
        }
    }

    static void reset() {
        bgColorFix = 4;
        mipmapType.clear();
        MipmapHelper.forceMipmapType("/terrain.png", 1);
        Properties properties = TexturePackAPI.getProperties(MIPMAP_PROPERTIES);
        if (properties != null) {
            try {
                bgColorFix = Integer.parseInt(properties.getProperty("bgColorFix", "4"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                String key = ((String)entry.getKey()).trim();
                String value = ((String)entry.getValue()).trim().toLowerCase();
                if (!key.startsWith("/")) continue;
                if (value.equals("none")) {
                    mipmapType.put(key, 0);
                    continue;
                }
                if (value.equals("basic") || value.equals("opaque")) {
                    mipmapType.put(key, 1);
                    continue;
                }
                if (value.equals("alpha")) {
                    mipmapType.put(key, 2);
                    continue;
                }
                logger.warning("%s: unknown value '%s' for %s", MIPMAP_PROPERTIES, value, key);
            }
        }
    }

    private static boolean getCustomMipmaps(ArrayList<BufferedImage> mipmaps, String texture, int baseWidth, int baseHeight) {
        boolean added = false;
        if (useMipmap && texture != null) {
            for (int i = 1; baseWidth > 0 && baseHeight > 0 && i <= maxMipmapLevel; baseWidth >>>= 1, baseHeight >>>= 1, ++i) {
                String name = texture.replace(".png", "-mipmap" + i + ".png");
                BufferedImage image = TexturePackAPI.getImage(name);
                if (image == null) break;
                int width = image.getWidth();
                int height = image.getHeight();
                if (width != baseWidth || height != baseHeight) {
                    logger.warning("%s has wrong size %dx%d (expecting %dx%d)", name, width, height, baseWidth, baseHeight);
                    break;
                }
                mipmaps.add(image);
                added = true;
            }
        }
        return added;
    }

    private static int getMipmapType(String texture, BufferedImage image) {
        if (!useMipmap || texture == null) {
            return 0;
        }
        if (mipmapType.containsKey(texture)) {
            return mipmapType.get(texture);
        }
        if (texture.startsWith("%") || texture.startsWith("##") || texture.startsWith("/achievement/") || texture.startsWith("/environment/") || texture.startsWith("/font/") || texture.startsWith("/gui/") || texture.startsWith("/misc/") || texture.startsWith("/terrain/") || texture.startsWith("/title/")) {
            return 0;
        }
        if (image == null) {
            return 1;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int pixel = image.getRGB(i, j);
                int alpha = pixel >>> 24;
                if (alpha <= 26 || alpha >= 229) continue;
                logger.finer("%s alpha transparency? yes, by pixel search", texture);
                mipmapType.put(texture, 2);
                return 2;
            }
        }
        logger.finer("%s alpha transparency? no, by pixel search", texture);
        mipmapType.put(texture, 1);
        return 1;
    }

    static void forceMipmapType(String texture, int type) {
        if (!useMipmap) {
            return;
        }
        boolean reload = false;
        if (mipmapType.containsKey(texture)) {
            boolean bl = reload = mipmapType.get(texture) != type;
            if (!reload) {
                return;
            }
        }
        mipmapType.put(texture, type);
        if (reload) {
            logger.finer("force %s -> %d (reloading)", texture, type);
            int id = TexturePackAPI.getTextureIfLoaded(texture);
            if (id >= 0) {
                MipmapHelper.setupTexture(MCPatcherUtils.getMinecraft().renderEngine, TexturePackAPI.getImage(texture), id, texture);
            }
        } else {
            logger.finer("force %s -> %d", texture, type);
        }
    }

    static int getMipmapLevels() {
        int filter = GL11.glGetTexParameteri((int)3553, (int)10241);
        if (filter != 9986 && filter != 9984) {
            return 0;
        }
        return GL11.glGetTexParameteri((int)3553, (int)33085);
    }

    private static int getMipmapLevels(String texture, BufferedImage image) {
        return MipmapHelper.getMipmapLevels(texture, image.getWidth(), image.getHeight());
    }

    private static int getMipmapLevels(String texture, int width, int height) {
        int mipmap;
        int size = BigInteger.valueOf(width).gcd(BigInteger.valueOf(height)).intValue();
        int minSize = MipmapHelper.getMinSize(texture);
        for (mipmap = 0; size >= minSize && (size & 1) == 0 && mipmap < maxMipmapLevel; size >>= 1, ++mipmap) {
        }
        return mipmap;
    }

    private static int getMinSize(String texture) {
        return texture.equals("/terrain.png") || texture.startsWith("/ctm/") ? 32 : 2;
    }

    private static void setBackgroundColor(BufferedImage image, BufferedImage scaledImage) {
        int width = image.getWidth();
        int height = image.getHeight();
        int scale = width / scaledImage.getWidth();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int pixel = image.getRGB(i, j);
                if ((pixel & 0xFF000000) != 0) continue;
                pixel = scaledImage.getRGB(i / scale, j / scale);
                image.setRGB(i, j, pixel & 0xFFFFFF);
            }
        }
    }

    private static void resetOnOffTransparency(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int pixel = image.getRGB(i, j);
                int alpha = pixel >>> 24;
                pixel = alpha < 127 ? (pixel &= 0xFFFFFF) : (pixel |= 0xFF000000);
                image.setRGB(i, j, pixel);
            }
        }
    }

    static void scaleHalf(IntBuffer in, int w, int h, IntBuffer out) {
        for (int i = 0; i < w / 2; ++i) {
            for (int j = 0; j < h / 2; ++j) {
                int k = w * 2 * j + 2 * i;
                int pixel00 = in.get(k);
                int pixel01 = in.get(k + 1);
                int pixel10 = in.get(k + w);
                int pixel11 = in.get(k + w + 1);
                out.put(w / 2 * j + i, MipmapHelper.average4RGBA(pixel00, pixel01, pixel10, pixel11));
            }
        }
    }

    private static BufferedImage scaleHalf(BufferedImage in) {
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage out = new BufferedImage(w / 2, h / 2, 2);
        for (int i = 0; i < w / 2; ++i) {
            for (int j = 0; j < h / 2; ++j) {
                int pixel00 = Integer.rotateLeft(in.getRGB(2 * i, 2 * j), 8);
                int pixel01 = Integer.rotateLeft(in.getRGB(2 * i + 1, 2 * j), 8);
                int pixel10 = Integer.rotateLeft(in.getRGB(2 * i, 2 * j + 1), 8);
                int pixel11 = Integer.rotateLeft(in.getRGB(2 * i + 1, 2 * j + 1), 8);
                out.setRGB(i, j, Integer.rotateRight(MipmapHelper.average4RGBA(pixel00, pixel01, pixel10, pixel11), 8));
            }
        }
        return out;
    }

    private static int average4RGBA(int pixel00, int pixel01, int pixel10, int pixel11) {
        int a00 = pixel00 & 0xFF;
        int a01 = pixel01 & 0xFF;
        int a10 = pixel10 & 0xFF;
        int a11 = pixel11 & 0xFF;
        switch (a00 << 24 | a01 << 16 | a10 << 8 | a11) {
            case -16777216: {
                return pixel00;
            }
            case 0xFF0000: {
                return pixel01;
            }
            case 65280: {
                return pixel10;
            }
            case 255: {
                return pixel11;
            }
            case -65536: {
                return MipmapHelper.average2RGBA(pixel00, pixel01);
            }
            case -16711936: {
                return MipmapHelper.average2RGBA(pixel00, pixel10);
            }
            case -16776961: {
                return MipmapHelper.average2RGBA(pixel00, pixel11);
            }
            case 0xFFFF00: {
                return MipmapHelper.average2RGBA(pixel01, pixel10);
            }
            case 0xFF00FF: {
                return MipmapHelper.average2RGBA(pixel01, pixel11);
            }
            case 65535: {
                return MipmapHelper.average2RGBA(pixel10, pixel11);
            }
            case -1: 
            case 0: {
                return MipmapHelper.average2RGBA(MipmapHelper.average2RGBA(pixel00, pixel11), MipmapHelper.average2RGBA(pixel01, pixel10));
            }
        }
        int a = a00 + a01 + a10 + a11;
        int pixel = a >> 2;
        for (int i = 8; i < 32; i += 8) {
            int average = (a00 * (pixel00 >> i & 0xFF) + a01 * (pixel01 >> i & 0xFF) + a10 * (pixel10 >> i & 0xFF) + a11 * (pixel11 >> i & 0xFF)) / a;
            pixel |= average << i;
        }
        return pixel;
    }

    private static int average2RGBA(int a, int b) {
        return ((a & 0xFEFEFEFE) >>> 1) + ((b & 0xFEFEFEFE) >>> 1) | a & b & 0x1010101;
    }

    private static void checkGLError(String format, Object ... params) {
        int error = GL11.glGetError();
        if (error != 0) {
            String message = GLU.gluErrorString((int)error) + ": " + String.format(format, params);
            new RuntimeException(message).printStackTrace();
        }
    }

    static {
        mipmapEnabled = MCPatcherUtils.getBoolean("HD Textures", "mipmap", true);
        maxMipmapLevel = MCPatcherUtils.getInt("HD Textures", "maxMipmapLevel", 3);
        mipmapAlignment = (1 << MCPatcherUtils.getInt("HD Textures", "mipmapAlignment", 3)) - 1;
        mipmapType = new HashMap();
        mipmapSupported = GLContext.getCapabilities().OpenGL12;
        useMipmap = mipmapSupported && mipmapEnabled && maxMipmapLevel > 0;
        anisoSupported = GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic;
        if (anisoSupported) {
            anisoMax = (int)GL11.glGetFloat((int)34047);
            MipmapHelper.checkGLError("glGetFloat(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT)", new Object[0]);
            anisoLevel = Math.max(Math.min(MCPatcherUtils.getInt("HD Textures", "anisotropicFiltering", 1), anisoMax), 1);
        } else {
            anisoLevel = 1;
            anisoMax = 1;
        }
        lodSupported = GLContext.getCapabilities().GL_EXT_texture_lod_bias;
        if (lodSupported) {
            lodBias = MCPatcherUtils.getInt("HD Textures", "lodBias", 0);
        }
        logger.config("mipmap: supported=%s, enabled=%s, level=%d", mipmapSupported, mipmapEnabled, maxMipmapLevel);
        logger.config("anisotropic: supported=%s, level=%d, max=%d", anisoSupported, anisoLevel, anisoMax);
        logger.config("lod bias: supported=%s, bias=%d", lodSupported, lodBias);
    }
}

