/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HDTextureConfig
extends ModConfigPanel {
    private JPanel panel;
    private JComboBox waterCombo;
    private JComboBox lavaCombo;
    private JComboBox fireCombo;
    private JComboBox portalCombo;
    private JComboBox otherCombo;
    private JCheckBox zombieHackCheckBox;
    private JCheckBox fancyCompassCheckBox;
    private JCheckBox mipmapCheckBox;
    private JSpinner mipmapLevelSpinner;
    private JSpinner lodBiasSpinner;
    private JSpinner anisoSpinner;
    private JSpinner aaSpinner;
    private AnimationComboListener[] comboListeners = new AnimationComboListener[4];

    HDTextureConfig() {
        this.$$$setupUI$$$();
        this.comboListeners[0] = new AnimationComboListener(this.waterCombo, "Water");
        this.comboListeners[1] = new AnimationComboListener(this.lavaCombo, "Lava");
        this.comboListeners[2] = new AnimationComboListener(this.fireCombo, "Fire");
        this.comboListeners[3] = new AnimationComboListener(this.portalCombo, "Portal");
        this.waterCombo.addItemListener(this.comboListeners[0]);
        this.lavaCombo.addItemListener(this.comboListeners[1]);
        this.fireCombo.addItemListener(this.comboListeners[2]);
        this.portalCombo.addItemListener(this.comboListeners[3]);
        this.otherCombo.addItem("Not Animated");
        this.otherCombo.addItem("Custom Animated");
        this.otherCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    switch (HDTextureConfig.this.otherCombo.getSelectedIndex()) {
                        case 0: {
                            MCPatcherUtils.set("HD Textures", "customOther", false);
                            break;
                        }
                        case 1: {
                            MCPatcherUtils.set("HD Textures", "customOther", true);
                            break;
                        }
                    }
                }
            }
        });
        this.zombieHackCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MCPatcherUtils.set("HD Textures", "zombieHack", HDTextureConfig.this.zombieHackCheckBox.isSelected());
            }
        });
        this.fancyCompassCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MCPatcherUtils.set("HD Textures", "fancyCompass", HDTextureConfig.this.fancyCompassCheckBox.isSelected());
            }
        });
        this.mipmapCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MCPatcherUtils.set("HD Textures", "mipmap", HDTextureConfig.this.mipmapCheckBox.isSelected());
            }
        });
        this.mipmapLevelSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = 4;
                try {
                    value = Integer.parseInt(HDTextureConfig.this.mipmapLevelSpinner.getValue().toString());
                    value = Math.min(Math.max(0, value), 9);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MCPatcherUtils.set("HD Textures", "maxMipmapLevel", value);
                HDTextureConfig.this.mipmapLevelSpinner.setValue(value);
            }
        });
        this.lodBiasSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = 0;
                try {
                    value = Integer.parseInt(HDTextureConfig.this.lodBiasSpinner.getValue().toString());
                    value = Math.min(Math.max(-9, value), 9);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MCPatcherUtils.set("HD Textures", "lodBias", value);
                HDTextureConfig.this.lodBiasSpinner.setValue(value);
            }
        });
        this.anisoSpinner.addChangeListener(new ChangeListener(){
            private int lastValue = MCPatcherUtils.getInt("HD Textures", "anisotropicFiltering", 1);

            public void stateChanged(ChangeEvent e) {
                int value = 1;
                try {
                    value = Integer.parseInt(HDTextureConfig.this.anisoSpinner.getValue().toString());
                    if (value > this.lastValue) {
                        value = this.lastValue * 2;
                    } else if (value < this.lastValue) {
                        value = this.lastValue / 2;
                    }
                    value = value <= 1 ? 1 : (value <= 2 ? 2 : (value <= 4 ? 4 : (value <= 8 ? 8 : 16)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MCPatcherUtils.set("HD Textures", "anisotropicFiltering", value);
                HDTextureConfig.this.anisoSpinner.setValue(value);
                this.lastValue = value;
            }
        });
        this.aaSpinner.addChangeListener(new ChangeListener(){
            private int lastValue = MCPatcherUtils.getInt("HD Textures", "antiAliasing", 0);

            public void stateChanged(ChangeEvent e) {
                int value = 0;
                try {
                    value = Integer.parseInt(HDTextureConfig.this.aaSpinner.getValue().toString());
                    if (value > this.lastValue) {
                        value = this.lastValue + 2 & 0xFFFFFFFE;
                    } else if (value < this.lastValue) {
                        value = Math.max(this.lastValue - 2, 0) & 0xFFFFFFFE;
                    }
                    value = Math.min(Math.max(0, value), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MCPatcherUtils.set("HD Textures", "antiAliasing", value);
                HDTextureConfig.this.aaSpinner.setValue(value);
                this.lastValue = value;
            }
        });
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void load() {
        for (AnimationComboListener listener : this.comboListeners) {
            listener.load();
        }
        this.otherCombo.setSelectedIndex(MCPatcherUtils.getBoolean("HD Textures", "customOther", true) ? 1 : 0);
        this.zombieHackCheckBox.setSelected(MCPatcherUtils.getBoolean("HD Textures", "zombieHack", true));
        this.fancyCompassCheckBox.setSelected(MCPatcherUtils.getBoolean("HD Textures", "fancyCompass", true));
        this.mipmapCheckBox.setSelected(MCPatcherUtils.getBoolean("HD Textures", "mipmap", true));
        this.mipmapLevelSpinner.setValue(MCPatcherUtils.getInt("HD Textures", "maxMipmapLevel", 3));
        this.lodBiasSpinner.setValue(MCPatcherUtils.getInt("HD Textures", "lodBias", 0));
        this.anisoSpinner.setValue(MCPatcherUtils.getInt("HD Textures", "anisotropicFiltering", 1));
        this.aaSpinner.setValue(MCPatcherUtils.getInt("HD Textures", "antiAliasing", 0));
    }

    public void save() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JSpinner jSpinner3;
        JSpinner jSpinner4;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Water");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Lava");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Fire");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Portal");
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.lavaCombo = jComboBox5 = new JComboBox();
        jPanel2.add(jComboBox5, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.waterCombo = jComboBox4 = new JComboBox();
        jPanel2.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.fireCombo = jComboBox3 = new JComboBox();
        jPanel2.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.portalCombo = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Other");
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.otherCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.zombieHackCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setToolTipText("Automatically resizes /mob/zombie.png from 64x32 to 64x64 as needed.");
        jCheckBox3.setText("Enable zombie texture compatibility fix");
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        this.mipmapCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable mipmaps");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mipmapLevelSpinner = jSpinner4 = new JSpinner();
        jPanel3.add((Component)jSpinner4, new GridConstraints(0, 3, 1, 1, 8, 1, 1, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Max level:");
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Level-of-detail bias");
        jPanel3.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.lodBiasSpinner = jSpinner3 = new JSpinner();
        jPanel3.add((Component)jSpinner3, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        ((Component)jLabel8).setVisible(false);
        jLabel8.setText("Anisotropic filtering");
        jPanel3.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.anisoSpinner = jSpinner2 = new JSpinner();
        ((Component)jSpinner2).setVisible(false);
        jPanel3.add((Component)jSpinner2, new GridConstraints(2, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        ((Component)jLabel9).setVisible(false);
        jLabel9.setText("Anti-aliasing");
        jPanel3.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.aaSpinner = jSpinner = new JSpinner();
        ((Component)jSpinner).setVisible(false);
        jPanel3.add((Component)jSpinner, new GridConstraints(3, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        this.fancyCompassCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable custom compass texture");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class AnimationComboListener
    implements ItemListener {
        private static final int OPT_DEFAULT = 0;
        private static final int OPT_NOT_ANIMATED = 1;
        private static final int OPT_CUSTOM_ANIMATED = 2;
        private final JComboBox comboBox;
        private final String animatedTag;
        private final String customTag;

        public AnimationComboListener(JComboBox comboBox, String tag) {
            this.comboBox = comboBox;
            this.customTag = "custom" + tag;
            this.animatedTag = "animated" + tag;
            comboBox.addItem("Default");
            comboBox.addItem("Not Animated");
            comboBox.addItem("Custom Animated");
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                boolean anim;
                boolean custom;
                switch (this.comboBox.getSelectedIndex()) {
                    case 0: {
                        custom = false;
                        anim = true;
                        break;
                    }
                    case 1: {
                        custom = false;
                        anim = false;
                        break;
                    }
                    case 2: {
                        custom = true;
                        anim = true;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                MCPatcherUtils.set("HD Textures", this.customTag, custom);
                MCPatcherUtils.set("HD Textures", this.animatedTag, anim);
            }
        }

        public void load() {
            if (MCPatcherUtils.getBoolean("HD Textures", this.customTag, true)) {
                this.comboBox.setSelectedIndex(2);
            } else if (MCPatcherUtils.getBoolean("HD Textures", this.animatedTag, true)) {
                this.comboBox.setSelectedIndex(0);
            } else {
                this.comboBox.setSelectedIndex(1);
            }
        }
    }
}

