/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Compass;
import net.minecraft.src.RenderEngine;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

class FancyCompass {
    private static final MCLogger logger = MCLogger.getLogger("HD Textures");
    private static final String ITEMS_PNG = "/gui/items.png";
    private static final String COMPASS_BASE_PNG = "/misc/compass_base.png";
    private static final String COMPASS_DIAL_PNG = "/misc/compass_dial.png";
    private static final String COMPASS_OVERLAY_PNG = "/misc/compass_overlay.png";
    private static final String COMPASS_PROPERTIES = "/misc/compass.properties";
    private static final int COMPASS_TILE_NUM = 54;
    private static final float RELATIVE_X = 0.375f;
    private static final float RELATIVE_Y = 0.1875f;
    private static final boolean fboSupported = GLContext.getCapabilities().GL_EXT_framebuffer_object;
    private static FancyCompass instance;
    private final Compass compass;
    private final float scaleX;
    private final float scaleY;
    private final float offsetX;
    private final float offsetY;
    private final boolean debug;
    private final int baseTexture;
    private final int dialTexture;
    private final int overlayTexture;
    private final int tileSize;
    private final int compassX;
    private final int compassY;
    private final int frameBuffer;
    private static final HashSet<Integer> keysDown;
    private static final float STEP = 0.01f;
    private float plusX;
    private float plusY;
    private float plusOX;
    private float plusOY;

    private FancyCompass() {
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        RenderEngine renderEngine = minecraft.renderEngine;
        this.compass = new Compass(minecraft);
        int targetTexture = renderEngine.getTexture(ITEMS_PNG);
        GL11.glBindTexture((int)3553, (int)targetTexture);
        this.tileSize = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / 16;
        this.compassX = (int)(0.375f * (float)this.tileSize * 16.0f);
        this.compassY = (int)(0.1875f * (float)this.tileSize * 16.0f);
        Properties properties = TexturePackAPI.getProperties(COMPASS_PROPERTIES);
        this.scaleX = FancyCompass.getFloatProperty(properties, "scaleX", 1.0f);
        this.scaleY = FancyCompass.getFloatProperty(properties, "scaleY", 0.5f);
        this.offsetX = FancyCompass.getFloatProperty(properties, "offsetX", 1.0f / (float)(2 * this.tileSize));
        this.offsetY = FancyCompass.getFloatProperty(properties, "offsetY", -1.0f / (float)(2 * this.tileSize));
        renderEngine.blurTexture = FancyCompass.getBooleanProperty(properties, "filter", false);
        this.debug = FancyCompass.getBooleanProperty(properties, "debug", false);
        BufferedImage image = TexturePackAPI.getImage(COMPASS_BASE_PNG);
        if (image == null) {
            image = new BufferedImage(this.tileSize, this.tileSize, 2);
            BufferedImage items = TexturePackAPI.getImage(ITEMS_PNG);
            Graphics2D graphics2D = image.createGraphics();
            int sx = (int)((float)items.getWidth() * 0.375f);
            int sy = (int)((float)items.getHeight() * 0.1875f);
            graphics2D.drawImage(items, 0, 0, image.getWidth(), image.getHeight(), sx, sy, sx + items.getWidth() / 16, sy + items.getHeight() / 16, null);
        }
        this.baseTexture = renderEngine.allocateAndSetupTexture(image);
        image = TexturePackAPI.getImage(COMPASS_DIAL_PNG);
        this.dialTexture = renderEngine.allocateAndSetupTexture(image);
        image = TexturePackAPI.getImage(COMPASS_OVERLAY_PNG);
        this.overlayTexture = image == null ? -1 : renderEngine.allocateAndSetupTexture(image);
        this.frameBuffer = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)targetTexture, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }

    private void onTick() {
        this.compass.onTick();
        boolean f = false;
        if (!this.debug) {
            f = true;
        } else if (FancyCompass.tap(80)) {
            this.plusY -= 0.01f;
        } else if (FancyCompass.tap(72)) {
            this.plusY += 0.01f;
        } else if (FancyCompass.tap(75)) {
            this.plusX -= 0.01f;
        } else if (FancyCompass.tap(77)) {
            this.plusX += 0.01f;
        } else if (FancyCompass.tap(208)) {
            this.plusOY += 0.01f;
        } else if (FancyCompass.tap(200)) {
            this.plusOY -= 0.01f;
        } else if (FancyCompass.tap(203)) {
            this.plusOX -= 0.01f;
        } else if (FancyCompass.tap(205)) {
            this.plusOX += 0.01f;
        } else if (FancyCompass.tap(55)) {
            this.plusOY = 0.0f;
            this.plusOX = 0.0f;
            this.plusY = 0.0f;
            this.plusX = 0.0f;
        } else {
            f = true;
        }
        if (!f) {
            logger.info("", new Object[0]);
            logger.info("scaleX = %f", Float.valueOf(this.scaleX + this.plusX));
            logger.info("scaleY = %f", Float.valueOf(this.scaleY + this.plusY));
            logger.info("offsetX = %f", Float.valueOf(this.offsetX + this.plusOX));
            logger.info("offsetY = %f", Float.valueOf(this.offsetY + this.plusOY));
        }
        GL11.glPushAttrib((int)527702);
        GL11.glViewport((int)this.compassX, (int)this.compassY, (int)this.tileSize, (int)this.tileSize);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)this.compassX, (int)this.compassY, (int)this.tileSize, (int)this.tileSize);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glBindTexture((int)3553, (int)this.baseTexture);
        this.drawBox();
        GL11.glPushMatrix();
        GL11.glBindTexture((int)3553, (int)this.dialTexture);
        float angle = (float)(180.0 - this.compass.currentAngle * 180.0 / Math.PI);
        GL11.glTranslatef((float)(this.offsetX + this.plusOX), (float)(this.offsetY + this.plusOY), (float)0.0f);
        GL11.glScalef((float)(this.scaleX + this.plusX), (float)(this.scaleY + this.plusY), (float)1.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawBox();
        GL11.glPopMatrix();
        if (this.overlayTexture >= 0) {
            GL11.glBindTexture((int)3553, (int)this.overlayTexture);
            this.drawBox();
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        GL11.glPopAttrib();
    }

    private void drawBox() {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    private void finish() {
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.frameBuffer);
    }

    private static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        if (properties != null) {
            defaultValue = Boolean.parseBoolean(properties.getProperty(key, "" + defaultValue));
        }
        return defaultValue;
    }

    private static float getFloatProperty(Properties properties, String key, float defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).equals("")) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                logger.severe("%s: invalid value %s for %s", COMPASS_PROPERTIES, value, key);
            }
        }
        return defaultValue;
    }

    private static boolean tap(int key) {
        if (Keyboard.isKeyDown((int)key)) {
            if (!keysDown.contains(key)) {
                keysDown.add(key);
                return true;
            }
        } else {
            keysDown.remove(key);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean refresh() {
        if (instance != null) {
            instance.finish();
            instance = null;
        }
        if (fboSupported && TexturePackAPI.hasResource(COMPASS_DIAL_PNG)) {
            try {
                instance = new FancyCompass();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.getMinecraft().renderEngine.blurTexture = false;
            }
        }
        return instance != null;
    }

    static void update() {
        if (instance != null) {
            instance.onTick();
        }
    }

    static {
        keysDown = new HashSet();
    }
}

