/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.WorldChunkManager;

abstract class BiomeHelper {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    static BiomeHelper instance;
    IBlockAccess blockAccess;

    static String getBiomeNameAt(int i, int j, int k) {
        if (instance == null) {
            return null;
        }
        BiomeGenBase biome = instance.getBiomeGenAt(i, j, k);
        return biome == null ? null : biome.biomeName;
    }

    BiomeHelper(IBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
    }

    boolean useBlockBlending() {
        return false;
    }

    abstract BiomeGenBase getBiomeGenAt(int var1, int var2, int var3);

    abstract float getTemperature(int var1, int var2, int var3);

    abstract float getRainfall(int var1, int var2, int var3);

    abstract int getWaterColorMultiplier(int var1, int var2, int var3);

    static class New
    extends BiomeHelper {
        private static boolean logged;
        private BiomeGenBase lastBiome;
        private int lastI;
        private int lastK;

        New(IBlockAccess blockAccess) {
            super(blockAccess);
            if (!logged) {
                logged = true;
                logger.config("biomes v1.2 detected", new Object[0]);
            }
        }

        boolean useBlockBlending() {
            return true;
        }

        BiomeGenBase getBiomeGenAt(int i, int j, int k) {
            if (this.lastBiome == null || i != this.lastI || k != this.lastK) {
                this.lastI = i;
                this.lastK = k;
                this.lastBiome = this.blockAccess.getBiomeGenAt(i, k);
            }
            return this.lastBiome;
        }

        float getTemperature(int i, int j, int k) {
            return this.getBiomeGenAt(i, j, k).getTemperaturef();
        }

        float getRainfall(int i, int j, int k) {
            return this.getBiomeGenAt(i, j, k).getRainfallf();
        }

        int getWaterColorMultiplier(int i, int j, int k) {
            return this.getBiomeGenAt((int)i, (int)j, (int)k).waterColorMultiplier;
        }
    }

    static class Old
    extends BiomeHelper {
        WorldChunkManager chunkManager;

        Old(IBlockAccess blockAccess) {
            super(blockAccess);
            this.chunkManager = blockAccess.getWorldChunkManager();
        }

        BiomeGenBase getBiomeGenAt(int i, int j, int k) {
            return this.chunkManager.getBiomeGenAt(i, k);
        }

        float getTemperature(int i, int j, int k) {
            return this.chunkManager.getTemperature(i, j, k);
        }

        float getRainfall(int i, int j, int k) {
            return this.chunkManager.getRainfall(i, k);
        }

        int getWaterColorMultiplier(int i, int j, int k) {
            return this.getBiomeGenAt((int)i, (int)j, (int)k).waterColorMultiplier;
        }
    }

    static class Stub
    extends BiomeHelper {
        Stub() {
            super(null);
        }

        BiomeGenBase getBiomeGenAt(int i, int j, int k) {
            return null;
        }

        float getTemperature(int i, int j, int k) {
            return 0.5f;
        }

        float getRainfall(int i, int j, int k) {
            return 1.0f;
        }

        int getWaterColorMultiplier(int i, int j, int k) {
            return 0xFFFFFF;
        }
    }
}

