/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pclewis.mcpatcher.MainForm;
import com.pclewis.mcpatcher.MinecraftJar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ZipTreeDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTree tree;
    private String prefix = "";

    public ZipTreeDialog(ZipFile zipFile) {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        MainForm.setIconImage(this);
        this.setTitle("Select folder to add to minecraft.jar");
        this.setMinimumSize(new Dimension(384, 384));
        this.setResizable(true);
        this.setModal(true);
        this.pack();
        this.getRootPane().setDefaultButton(this.buttonOK);
        final ArrayList<String> dirs = new ArrayList<String>();
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String name = zipEntry.getName();
            if (MinecraftJar.isGarbageFile(name)) continue;
            if (!zipEntry.isDirectory()) {
                name = name.replaceFirst("/?[^/]+$", "/");
            }
            if (dirs.contains(name)) continue;
            dirs.add(name);
        }
        Collections.sort(dirs);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZipTreeDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZipTreeDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ZipTreeDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZipTreeDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.tree.setModel(new TreeModel(){

            @Override
            public Object getRoot() {
                return new ZipTreeNode("/", "");
            }

            @Override
            public Object getChild(Object parent, int index) {
                return this.getChildren(parent).get(index);
            }

            @Override
            public int getChildCount(Object parent) {
                return this.getChildren(parent).size();
            }

            @Override
            public boolean isLeaf(Object node) {
                return false;
            }

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
            }

            @Override
            public int getIndexOfChild(Object parent, Object child) {
                return this.getChildren(parent).indexOf((ZipTreeNode)child);
            }

            @Override
            public void addTreeModelListener(TreeModelListener l) {
            }

            @Override
            public void removeTreeModelListener(TreeModelListener l) {
            }

            private ArrayList<ZipTreeNode> getChildren(Object object) {
                String parent = ((ZipTreeNode)object).path;
                ArrayList<ZipTreeNode> list = new ArrayList<ZipTreeNode>();
                for (String name : dirs) {
                    String suffix;
                    if (!name.startsWith(parent) || (suffix = name.substring(parent.length()).replaceFirst("/$", "")).equals("") || suffix.contains("/")) continue;
                    list.add(new ZipTreeNode(suffix, name));
                }
                return list;
            }
        });
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setSelectionRow(0);
    }

    private void onOK() {
        TreePath path = this.tree.getSelectionPath();
        this.prefix = ((ZipTreeNode)path.getLastPathComponent()).path;
        this.dispose();
    }

    private void onCancel() {
        this.prefix = null;
        this.dispose();
    }

    boolean hasSubfolders() {
        if (this.tree.getModel().getChildCount(this.tree.getModel().getRoot()) > 0) {
            return true;
        }
        this.prefix = "";
        return false;
    }

    String getPrefix() {
        return this.prefix;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTree jTree;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("OK");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.tree = jTree = new JTree();
        jScrollPane.setViewportView(jTree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static class ZipTreeNode {
        String label;
        String path;

        ZipTreeNode(String label, String path) {
            this.label = label;
            this.path = path;
        }

        public String toString() {
            return this.label;
        }

        public int compareTo(ZipTreeNode node) {
            return this.path.compareTo(node.path);
        }

        public boolean equals(ZipTreeNode node) {
            return this.compareTo(node) == 0;
        }
    }
}

