/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

public abstract class WeightedIndex {
    final int size;

    public static WeightedIndex create(int size) {
        if (size <= 0) {
            return null;
        }
        return new WeightedIndex(size){

            public int choose(long key) {
                return this.mod(key, this.size);
            }

            public String toString() {
                return "unweighted";
            }
        };
    }

    public static WeightedIndex create(int size, String weightList) {
        if (size <= 0 || weightList == null) {
            return WeightedIndex.create(size);
        }
        final int[] weights = new int[size];
        int sum1 = 0;
        boolean useWeight = false;
        String[] list = weightList.trim().split("\\s+");
        for (int i = 0; i < size; ++i) {
            weights[i] = i < list.length && list[i].matches("^\\d+$") ? Math.max(Integer.parseInt(list[i]), 0) : 1;
            if (i > 0 && weights[i] != weights[0]) {
                useWeight = true;
            }
            sum1 += weights[i];
        }
        if (!useWeight || sum1 <= 0) {
            return WeightedIndex.create(size);
        }
        final int sum = sum1;
        return new WeightedIndex(size){

            public int choose(long key) {
                int index;
                int m = this.mod(key, sum);
                for (index = 0; index < this.size - 1 && m >= weights[index]; m -= weights[index], ++index) {
                }
                return index;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("%(");
                for (int i = 0; i < weights.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.format("%.1f", 100.0 * (double)weights[i] / (double)sum));
                }
                sb.append(")");
                return sb.toString();
            }
        };
    }

    protected WeightedIndex(int size) {
        this.size = size;
    }

    protected final int mod(long n, int modulus) {
        return (int)((n >> 32 ^ n) & Integer.MAX_VALUE) % modulus;
    }

    public abstract int choose(long var1);
}

