/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MainForm;
import com.pclewis.mcpatcher.ModList;
import java.io.File;
import java.util.ArrayList;

abstract class UserInterface {
    UserInterface() {
    }

    abstract boolean shouldExit();

    void show() {
    }

    File chooseMinecraftDir(File enteredMCDir) {
        return null;
    }

    boolean locateMinecraftDir(String enteredMCDir) {
        ArrayList<File> mcDirs = new ArrayList<File>();
        if (enteredMCDir == null) {
            mcDirs.add(MCPatcherUtils.getDefaultGameDir());
            mcDirs.add(new File("."));
            mcDirs.add(new File(".."));
        } else {
            mcDirs.add(new File(enteredMCDir).getAbsoluteFile());
        }
        for (File dir : mcDirs) {
            if (!MCPatcherUtils.setGameDir(dir)) continue;
            return true;
        }
        File minecraftDir = (File)mcDirs.get(0);
        do {
            if ((minecraftDir = this.chooseMinecraftDir(minecraftDir)) != null) continue;
            return false;
        } while (!MCPatcherUtils.setGameDir(minecraftDir) && !MCPatcherUtils.setGameDir(minecraftDir.getParentFile()));
        return true;
    }

    boolean go() {
        File defaultMinecraft = MCPatcherUtils.getMinecraftPath("bin", "minecraft.jar");
        if (!defaultMinecraft.exists()) {
            this.showCorruptJarError(defaultMinecraft);
            this.setBusy(false);
            return false;
        }
        if (MCPatcher.setMinecraft(defaultMinecraft, true)) {
            this.updateModList();
            return true;
        }
        this.showCorruptJarError(defaultMinecraft);
        this.setBusy(false);
        return false;
    }

    void updateProgress(int value, int max) {
    }

    void setModList(ModList modList) {
    }

    void updateModList() {
    }

    void setStatusText(String format, Object ... params) {
    }

    void setBusy(boolean busy) {
    }

    void showBetaWarning() {
    }

    void showCorruptJarError(File defaultMinecraft) {
        Logger.log(0, "ERROR: %s missing or corrupt", defaultMinecraft.getPath());
    }

    static class CLI
    extends UserInterface {
        CLI() {
        }

        boolean shouldExit() {
            return true;
        }

        boolean go() {
            if (!super.go()) {
                return false;
            }
            boolean ok = false;
            try {
                MCPatcher.getApplicableMods();
                System.out.println();
                System.out.println("#### Class map:");
                MCPatcher.showClassMaps(System.out);
                if (MCPatcher.patch()) {
                    ok = true;
                }
                System.out.println();
                System.out.println("#### Patch summary:");
                MCPatcher.showPatchResults(System.out);
            }
            catch (Throwable e) {
                Logger.log(e);
            }
            return ok;
        }
    }

    static class GUI
    extends UserInterface {
        private MainForm mainForm = new MainForm();

        GUI() {
        }

        boolean shouldExit() {
            return false;
        }

        void show() {
            this.mainForm.show();
        }

        File chooseMinecraftDir(File enteredMCDir) {
            return this.mainForm.chooseMinecraftDir(enteredMCDir);
        }

        void updateProgress(int value, int max) {
            this.mainForm.updateProgress(value, max);
        }

        void setModList(ModList modList) {
            this.mainForm.setModList(modList);
        }

        void updateModList() {
            this.mainForm.updateModList();
        }

        void setStatusText(String format, Object ... params) {
            this.mainForm.setStatusText(format, params);
        }

        void setBusy(boolean busy) {
            this.mainForm.setBusy(busy);
        }

        void showBetaWarning() {
            this.mainForm.showBetaWarning();
        }

        void showCorruptJarError(File defaultMinecraft) {
            super.showCorruptJarError(defaultMinecraft);
            this.mainForm.showCorruptJarError(defaultMinecraft);
        }
    }
}

