/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackCustom;
import net.minecraft.src.TexturePackDefault;
import net.minecraft.src.TexturePackFolder;
import net.minecraft.src.TexturePackList;

public class TexturePackAPI {
    private static final MCLogger logger = MCLogger.getLogger("Texture Pack");
    public static TexturePackAPI instance = new TexturePackAPI();
    public static boolean loadFontFromTexturePack;
    private static final ArrayList<Field> textureMapFields;
    private static TexturePackBase texturePack;

    public static TexturePackBase getTexturePack() {
        return texturePack;
    }

    static TexturePackBase getCurrentTexturePack() {
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        if (minecraft == null) {
            return null;
        }
        TexturePackList texturePackList = minecraft.texturePackList;
        if (texturePackList == null) {
            return null;
        }
        return texturePackList.getSelectedTexturePack();
    }

    public static boolean isDefaultTexturePack() {
        return TexturePackAPI.getTexturePack() instanceof TexturePackDefault;
    }

    public static String[] parseTextureName(String s) {
        int index;
        String[] result = new String[]{null, s};
        if (s.startsWith("##")) {
            result[0] = "##";
            result[1] = s.substring(2);
        } else if (s.startsWith("%") && (index = s.indexOf(37, 1)) > 0) {
            result[0] = s.substring(0, index + 1);
            result[1] = s.substring(index + 1);
        }
        return result;
    }

    public static InputStream getInputStream(String s) {
        return instance.getInputStreamImpl(s);
    }

    public static boolean hasResource(String s) {
        if (s.endsWith(".png")) {
            return TexturePackAPI.getImage(s) != null;
        }
        if (s.endsWith(".properties")) {
            return TexturePackAPI.getProperties(s) != null;
        }
        InputStream is = TexturePackAPI.getInputStream(s);
        MCPatcherUtils.close(is);
        return is != null;
    }

    public static BufferedImage getImage(String s) {
        return instance.getImageImpl(s);
    }

    public static BufferedImage getImage(Object o, String s) {
        return TexturePackAPI.getImage(s);
    }

    public static Properties getProperties(String s) {
        Properties properties = new Properties();
        if (TexturePackAPI.getProperties(s, properties)) {
            return properties;
        }
        return null;
    }

    public static boolean getProperties(String s, Properties properties) {
        return instance.getPropertiesImpl(s, properties);
    }

    public static String[] listResources(String directory, String suffix) {
        if (directory == null) {
            directory = "";
        }
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        if (suffix == null) {
            suffix = "";
        }
        ArrayList<String> resources = new ArrayList<String>();
        if (!(texturePack instanceof TexturePackDefault)) {
            String[] list;
            File folder;
            if (texturePack instanceof TexturePackCustom) {
                ZipFile zipFile = ((TexturePackCustom)TexturePackAPI.texturePack).zipFile;
                if (zipFile != null) {
                    for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                        String name = zipEntry.getName();
                        if (!name.startsWith(directory) || !name.endsWith(suffix)) continue;
                        resources.add("/" + name);
                    }
                }
            } else if (texturePack instanceof TexturePackFolder && (folder = ((TexturePackFolder)texturePack).getFolder()) != null && folder.isDirectory() && (list = new File(folder, directory).list()) != null) {
                for (String s : list) {
                    if (!s.endsWith(suffix)) continue;
                    resources.add("/" + new File(new File(directory), s).getPath().replace('\\', '/'));
                }
            }
        }
        Collections.sort(resources);
        return resources.toArray(new String[resources.size()]);
    }

    public static int getTextureIfLoaded(String s) {
        RenderEngine renderEngine = MCPatcherUtils.getMinecraft().renderEngine;
        for (Field field : textureMapFields) {
            try {
                Object value;
                HashMap map = (HashMap)field.get(renderEngine);
                if (map == null || !((value = map.get(s)) instanceof Integer)) continue;
                return (Integer)value;
            }
            catch (IllegalAccessException e) {
            }
        }
        return -1;
    }

    public static boolean isTextureLoaded(String s) {
        return TexturePackAPI.getTextureIfLoaded(s) >= 0;
    }

    public static int unloadTexture(String s) {
        int texture = TexturePackAPI.getTextureIfLoaded(s);
        if (texture >= 0) {
            logger.finest("unloading texture %s", s);
            RenderEngine renderEngine = MCPatcherUtils.getMinecraft().renderEngine;
            renderEngine.deleteTexture(texture);
            for (Field field : textureMapFields) {
                try {
                    HashMap map = (HashMap)field.get(renderEngine);
                    if (map == null) continue;
                    map.remove(s);
                }
                catch (IllegalAccessException e) {}
            }
        }
        return texture;
    }

    public static String getTextureName(int texture) {
        if (texture >= 0) {
            RenderEngine renderEngine = MCPatcherUtils.getMinecraft().renderEngine;
            for (Field field : textureMapFields) {
                try {
                    HashMap map = (HashMap)field.get(renderEngine);
                    Iterator i$ = map.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = i$.next();
                        Object value = entry.getValue();
                        Object key = entry.getKey();
                        if (!(value instanceof Integer) || !(key instanceof String) || (Integer)value != texture) continue;
                        return (String)key;
                    }
                }
                catch (IllegalAccessException e) {
                }
            }
        }
        return null;
    }

    protected InputStream getInputStreamImpl(String s) {
        s = TexturePackAPI.parseTextureName(s)[1];
        if (!loadFontFromTexturePack && s.startsWith("/font/")) {
            return TexturePackAPI.class.getResourceAsStream(s);
        }
        if (texturePack == null) {
            TexturePackBase currentTexturePack = TexturePackAPI.getCurrentTexturePack();
            if (currentTexturePack == null) {
                return TexturePackAPI.class.getResourceAsStream(s);
            }
            return currentTexturePack.getInputStream(s);
        }
        return texturePack.getInputStream(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getImageImpl(String s) {
        InputStream input = TexturePackAPI.getInputStream(s);
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e) {
                logger.severe("could not read %s", s);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPropertiesImpl(String s, Properties properties) {
        if (properties != null) {
            InputStream input = TexturePackAPI.getInputStream(s);
            try {
                if (input != null) {
                    properties.load(input);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                logger.severe("could not read %s", new Object[0]);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }

    static {
        textureMapFields = new ArrayList();
        try {
            for (Field field : RenderEngine.class.getDeclaredFields()) {
                if (!HashMap.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                textureMapFields.add(field);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static abstract class ChangeHandler {
        private static final ArrayList<ChangeHandler> handlers = new ArrayList();
        private static boolean changing;
        private static final boolean autoRefreshTextures;
        private static long lastCheckTime;
        protected final String name;
        protected final int order;

        protected ChangeHandler(String name, int order) {
            this.name = name;
            this.order = order;
        }

        protected abstract void onChange();

        public static void register(ChangeHandler handler) {
            if (handler != null) {
                if (texturePack != null) {
                    try {
                        logger.info("initializing %s...", handler.name);
                        handler.onChange();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        logger.severe("%s initialization failed", handler.name);
                    }
                }
                handlers.add(handler);
                logger.fine("registered texture pack handler %s, priority %d", handler.name, handler.order);
                Collections.sort(handlers, new Comparator<ChangeHandler>(){

                    @Override
                    public int compare(ChangeHandler o1, ChangeHandler o2) {
                        return o1.order - o2.order;
                    }
                });
            }
        }

        public static void checkForTexturePackChange() {
            Minecraft minecraft = MCPatcherUtils.getMinecraft();
            if (minecraft == null) {
                return;
            }
            TexturePackList texturePackList = minecraft.texturePackList;
            if (texturePackList == null) {
                return;
            }
            TexturePackBase currentTexturePack = texturePackList.getSelectedTexturePack();
            if (currentTexturePack != texturePack) {
                ChangeHandler.changeTexturePack(currentTexturePack);
            } else if (currentTexturePack instanceof TexturePackCustom) {
                ChangeHandler.checkFileChange(texturePackList, (TexturePackCustom)currentTexturePack);
            }
        }

        private static void changeTexturePack(TexturePackBase newPack) {
            if (newPack != null && !changing) {
                changing = true;
                long timeDiff = -System.currentTimeMillis();
                Runtime runtime = Runtime.getRuntime();
                long memDiff = -(runtime.totalMemory() - runtime.freeMemory());
                if (texturePack == null) {
                    logger.info("\nsetting texture pack to %s", newPack.texturePackFileName);
                } else if (texturePack == newPack) {
                    logger.info("\nreloading texture pack %s", newPack.texturePackFileName);
                } else {
                    logger.info("\nchanging texture pack from %s to %s", texturePack.texturePackFileName, newPack.texturePackFileName);
                }
                texturePack = newPack;
                for (ChangeHandler handler : handlers) {
                    try {
                        logger.info("refreshing %s...", handler.name);
                        handler.onChange();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        logger.severe("%s refresh failed", handler.name);
                    }
                }
                System.gc();
                logger.info("done (%.3fs elapsed, mem usage %+.1fMB)\n", (double)(timeDiff += System.currentTimeMillis()) / 1000.0, (double)(memDiff += runtime.totalMemory() - runtime.freeMemory()) / 1048576.0);
                changing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean openTexturePackFile(TexturePackCustom pack) {
            if (pack.zipFile == null) {
                return false;
            }
            if (pack.origZip != null) {
                return true;
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            ZipFile newZipFile = null;
            try {
                int nread;
                pack.lastModified = pack.file.lastModified();
                pack.tmpFile = File.createTempFile("tmpmc", ".zip");
                pack.tmpFile.deleteOnExit();
                MCPatcherUtils.close(pack.zipFile);
                input = new FileInputStream(pack.file);
                output = new FileOutputStream(pack.tmpFile);
                byte[] buffer = new byte[65536];
                while ((nread = ((InputStream)input).read(buffer)) > 0) {
                    ((OutputStream)output).write(buffer, 0, nread);
                }
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                newZipFile = new ZipFile(pack.tmpFile);
                pack.origZip = pack.zipFile;
                pack.zipFile = newZipFile;
                newZipFile = null;
                logger.fine("copied %s to %s, lastModified = %d", pack.file.getPath(), pack.tmpFile.getPath(), pack.lastModified);
                MCPatcherUtils.close(input);
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                MCPatcherUtils.close(newZipFile);
            }
            MCPatcherUtils.close(output);
            MCPatcherUtils.close(newZipFile);
            return true;
        }

        private static void closeTexturePackFile(TexturePackCustom pack) {
            if (pack.origZip != null) {
                MCPatcherUtils.close(pack.zipFile);
                pack.zipFile = pack.origZip;
                pack.origZip = null;
                pack.tmpFile.delete();
                logger.fine("deleted %s", pack.tmpFile.getPath());
                pack.tmpFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean checkFileChange(TexturePackList list, TexturePackCustom pack) {
            if (!autoRefreshTextures || !ChangeHandler.openTexturePackFile(pack)) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (now - lastCheckTime < 1000L) {
                return false;
            }
            lastCheckTime = now;
            long lastModified = pack.file.lastModified();
            if (lastModified == pack.lastModified || lastModified == 0L || pack.lastModified == 0L) {
                return false;
            }
            logger.finer("%s lastModified changed from %d to %d", pack.file.getName(), pack.lastModified, lastModified);
            ZipFile tmpZip = null;
            try {
                tmpZip = new ZipFile(pack.file);
            }
            catch (IOException e) {
                boolean bl;
                try {
                    bl = false;
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(tmpZip);
                    throw throwable;
                }
                MCPatcherUtils.close(tmpZip);
                return bl;
            }
            MCPatcherUtils.close(tmpZip);
            ChangeHandler.closeTexturePackFile(pack);
            list.updateAvailableTexturePacks();
            return true;
        }

        static {
            autoRefreshTextures = MCPatcherUtils.getBoolean("autoRefreshTextures", false);
        }
    }
}

