/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FilenameSignature;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModConfigPanel;
import com.pclewis.mcpatcher.OrSignature;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class BaseMod
extends Mod {
    public static final String NAME = "__Base";

    BaseMod(MinecraftVersion minecraftVersion) {
        this.name = NAME;
        this.author = "MCPatcher";
        this.description = "Internal mod required by the patcher.";
        this.version = "1.0";
        this.configPanel = new ConfigPanel();
        this.dependencies.clear();
        this.addClassMod(new XMinecraftMod());
        this.addClassFile("com.pclewis.mcpatcher.MCPatcherUtils");
        this.addClassFile("com.pclewis.mcpatcher.MCLogger");
        this.addClassFile("com.pclewis.mcpatcher.MCLogger$1");
        this.addClassFile("com.pclewis.mcpatcher.MCLogger$1$1");
        this.addClassFile("com.pclewis.mcpatcher.Config");
    }

    public String[] getLoggingCategories() {
        return null;
    }

    public static class ProfilerMod
    extends ClassMod {
        public ProfilerMod() {
            this.addClassSignature(new ConstSignature("[UNKNOWN]"));
            this.addClassSignature(new ConstSignature(100.0));
            MethodRef startSection = new MethodRef(this.getDeobfClass(), "startSection", "(Ljava/lang/String;)V");
            MethodRef endSection = new MethodRef(this.getDeobfClass(), "endSection", "()V");
            MethodRef endStartSection = new MethodRef(this.getDeobfClass(), "endStartSection", "(Ljava/lang/String;)V");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(182), 42, 43, BytecodeMatcher.captureReference(182));
                }
            }.setMethod(endStartSection).addXref(1, endSection).addXref(2, startSection));
        }
    }

    public static class GameSettingsMod
    extends ClassMod {
        public GameSettingsMod() {
            this.addClassSignature(new ConstSignature("options.txt"));
            this.addClassSignature(new OrSignature(new ConstSignature("key.forward"), new ConstSignature("Forward")));
        }

        protected void mapOption(final String option, String field, String descriptor) {
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(45, 3, 50, this.push(option), this.reference(182, new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z")), 153, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 20)), BytecodeMatcher.captureReference(181));
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), field, descriptor)));
        }
    }

    public static class RenderEngineMod
    extends ClassMod {
        protected final MethodRef glTexSubImage2D = new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V");

        public RenderEngineMod() {
            this.addClassSignature(new ConstSignature("%clamp%"));
            this.addClassSignature(new ConstSignature("%blur%"));
            this.addClassSignature(new ConstSignature(this.glTexSubImage2D));
        }
    }

    public static class RenderBlocksMod
    extends ClassMod {
        public RenderBlocksMod() {
            this.addClassSignature(new ConstSignature(0.1875));
            this.addClassSignature(new ConstSignature(0.01));
        }
    }

    public static class FontRendererMod
    extends ClassMod {
        public FontRendererMod() {
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.anyReference(183), 42, this.push(256), 188, 10, BytecodeMatcher.captureReference(181), 42, 3, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, new FieldRef(this.getDeobfClass(), "charWidth", "[I")).addXref(2, new FieldRef(this.getDeobfClass(), "fontTextureName", "I")));
            this.addClassSignature(new OrSignature(new ConstSignature("0123456789abcdef"), new ConstSignature("0123456789abcdefk"), new ConstSignature("/font/glyph_sizes.bin")));
        }
    }

    public static class WorldServerMPMod
    extends ClassMod {
        public WorldServerMPMod(MinecraftVersion minecraftVersion) {
            this.parentClass = "World";
            this.addClassSignature(new ConstSignature("MpServer"));
        }
    }

    public static class WorldServerMod
    extends ClassMod {
        public WorldServerMod(MinecraftVersion minecraftVersion) {
            FieldRef world = new FieldRef(this.getDeobfClass(), "world", "LWorld;");
            this.addClassSignature(new ConstSignature("/particles.png"));
            this.addClassSignature(new ConstSignature("/terrain.png"));
            this.addClassSignature(new ConstSignature("/gui/items.png"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, world));
            this.addPatch(new MakeMemberPublicPatch(world));
        }
    }

    public static class WorldMod
    extends ClassMod {
        public WorldMod() {
            this.interfaces = new String[]{"IBlockAccess"};
            this.addClassSignature(new ConstSignature("ambient.cave.cave"));
            this.addClassSignature(new ConstSignature(1013904223));
        }
    }

    public static class ItemMod
    extends ClassMod {
        public ItemMod() {
            this.addClassSignature(new ConstSignature("CONFLICT @ "));
            this.addClassSignature(new ConstSignature("coal"));
        }
    }

    public static class BlockMod
    extends ClassMod {
        private static final ArrayList<BlockSubclassEntry> subclasses = new ArrayList<BlockSubclassEntry>(){
            {
                this.add(new BlockSubclassEntry(1, "Block", "stone", "BlockStone", "stone"));
                this.add(new BlockSubclassEntry(2, "BlockGrass", "grass", "BlockGrass", "grass"));
                this.add(new BlockSubclassEntry(3, "Block", "dirt", "BlockDirt", "dirt"));
                this.add(new BlockSubclassEntry(4, "Block", "cobblestone", "Block", "stonebrick"));
                this.add(new BlockSubclassEntry(5, "Block", "planks", "BlockWood", "wood"));
                this.add(new BlockSubclassEntry(6, "Block", "sapling", "BlockSapling", "sapling"));
                this.add(new BlockSubclassEntry(7, "Block", "bedrock", "Block", "bedrock"));
                this.add(new BlockSubclassEntry(8, "Block", "waterMoving", "BlockFlowing", "water"));
                this.add(new BlockSubclassEntry(9, "Block", "waterStill", "BlockStationary", "water"));
                this.add(new BlockSubclassEntry(10, "Block", "lavaMoving", "BlockFlowing", "lava"));
                this.add(new BlockSubclassEntry(11, "Block", "lavaStill", "BlockStationary", "lava"));
                this.add(new BlockSubclassEntry(12, "Block", "sand", "BlockSand", "sand"));
                this.add(new BlockSubclassEntry(13, "Block", "gravel", "BlockGravel", "gravel"));
                this.add(new BlockSubclassEntry(14, "Block", "oreGold", "BlockOre", "oreGold"));
                this.add(new BlockSubclassEntry(15, "Block", "oreIron", "BlockOre", "oreIron"));
                this.add(new BlockSubclassEntry(16, "Block", "oreCoal", "BlockOre", "oreCoal"));
                this.add(new BlockSubclassEntry(17, "Block", "wood", "BlockLog", "log"));
                this.add(new BlockSubclassEntry(18, "BlockLeaves", "leaves", "BlockLeaves", "leaves"));
                this.add(new BlockSubclassEntry(19, "Block", "sponge", "BlockSponge", "sponge"));
                this.add(new BlockSubclassEntry(20, "Block", "glass", "BlockGlass", "glass"));
                this.add(new BlockSubclassEntry(21, "Block", "oreLapis", "BlockOre", "oreLapis"));
                this.add(new BlockSubclassEntry(22, "Block", "blockLapis", "Block", "blockLapis"));
                this.add(new BlockSubclassEntry(23, "Block", "dispenser", "BlockDispenser", "dispenser"));
                this.add(new BlockSubclassEntry(24, "Block", "sandStone", "BlockSandStone", "sandStone"));
                this.add(new BlockSubclassEntry(25, "Block", "music", "BlockNote", "musicBlock"));
                this.add(new BlockSubclassEntry(26, "Block", "bed", "BlockBed", "bed"));
                this.add(new BlockSubclassEntry(27, "Block", "railPowered", "BlockRail", "goldenRail"));
                this.add(new BlockSubclassEntry(28, "Block", "railDetector", "BlockDetectorRail", "detectorRail"));
                this.add(new BlockSubclassEntry(29, "Block", "pistonStickyBase", "BlockPistonBase", "pistonStickyBase"));
                this.add(new BlockSubclassEntry(30, "Block", "web", "BlockWeb", "web"));
                this.add(new BlockSubclassEntry(31, "BlockTallGrass", "tallGrass", "BlockTallGrass", "tallgrass"));
                this.add(new BlockSubclassEntry(32, "BlockDeadBush", "deadBush", "BlockDeadBush", "deadbush"));
                this.add(new BlockSubclassEntry(33, "Block", "pistonBase", "BlockPistonBase", "pistonBase"));
                this.add(new BlockSubclassEntry(34, "BlockPistonExtension", "pistonExtension", "BlockPistonExtension", "unnamedBlock34"));
                this.add(new BlockSubclassEntry(35, "Block", "cloth", "BlockCloth", "cloth"));
                this.add(new BlockSubclassEntry(36, "BlockPistonMoving", "pistonMoving", "BlockPistonMoving", "unnamedBlock36"));
                this.add(new BlockSubclassEntry(37, "BlockFlower", "plantYellow", "BlockFlower", "flower"));
                this.add(new BlockSubclassEntry(38, "BlockFlower", "plantRed", "BlockFlower", "rose"));
                this.add(new BlockSubclassEntry(39, "BlockFlower", "mushroomBrown", "BlockMushroom", "mushroom"));
                this.add(new BlockSubclassEntry(40, "BlockFlower", "mushroomRed", "BlockMushroom", "mushroom"));
                this.add(new BlockSubclassEntry(41, "Block", "blockGold", "BlockOreStorage", "blockGold"));
                this.add(new BlockSubclassEntry(42, "Block", "blockSteel", "BlockOreStorage", "blockIron"));
                this.add(new BlockSubclassEntry(43, "BlockHalfSlab", "stoneDoubleSlab", "BlockStep", "stoneSlab"));
                this.add(new BlockSubclassEntry(44, "BlockHalfSlab", "stoneSingleSlab", "BlockStep", "stoneSlab"));
                this.add(new BlockSubclassEntry(45, "Block", "brick", "Block", "brick"));
                this.add(new BlockSubclassEntry(46, "Block", "tnt", "BlockTNT", "tnt"));
                this.add(new BlockSubclassEntry(47, "Block", "bookShelf", "BlockBookshelf", "bookshelf"));
                this.add(new BlockSubclassEntry(48, "Block", "cobblestoneMossy", "Block", "stoneMoss"));
                this.add(new BlockSubclassEntry(49, "Block", "obsidian", "BlockObsidian", "obsidian"));
                this.add(new BlockSubclassEntry(50, "Block", "torchWood", "BlockTorch", "torch"));
                this.add(new BlockSubclassEntry(51, "BlockFire", "fire", "BlockFire", "fire"));
                this.add(new BlockSubclassEntry(52, "Block", "mobSpawner", "BlockMobSpawner", "mobSpawner"));
                this.add(new BlockSubclassEntry(53, "Block", "stairCompactPlanks", "BlockStairs", "stairsWood"));
                this.add(new BlockSubclassEntry(54, "Block", "chest", "BlockChest", "chest"));
                this.add(new BlockSubclassEntry(55, "Block", "redstoneWire", "BlockRedstoneWire", "redstoneDust"));
                this.add(new BlockSubclassEntry(56, "Block", "oreDiamond", "BlockOre", "oreDiamond"));
                this.add(new BlockSubclassEntry(57, "Block", "blockDiamond", "BlockOreStorage", "blockDiamond"));
                this.add(new BlockSubclassEntry(58, "Block", "workbench", "BlockWorkbench", "workbench"));
                this.add(new BlockSubclassEntry(59, "Block", "crops", "BlockCrops", "crops"));
                this.add(new BlockSubclassEntry(60, "Block", "tilledField", "BlockFarmland", "farmland"));
                this.add(new BlockSubclassEntry(61, "Block", "stoneOvenIdle", "BlockFurnace", "furnace"));
                this.add(new BlockSubclassEntry(62, "Block", "stoneOvenActive", "BlockFurnace", "furnace"));
                this.add(new BlockSubclassEntry(63, "Block", "signPost", "BlockSign", "sign"));
                this.add(new BlockSubclassEntry(64, "Block", "doorWood", "BlockDoor", "doorWood"));
                this.add(new BlockSubclassEntry(65, "Block", "ladder", "BlockLadder", "ladder"));
                this.add(new BlockSubclassEntry(66, "Block", "rail", "BlockRail", "rail"));
                this.add(new BlockSubclassEntry(67, "Block", "stairCompactCobblestone", "BlockStairs", "stairsStone"));
                this.add(new BlockSubclassEntry(68, "Block", "signWall", "BlockSign", "sign"));
                this.add(new BlockSubclassEntry(69, "Block", "lever", "BlockLever", "lever"));
                this.add(new BlockSubclassEntry(70, "Block", "pressurePlateStone", "BlockPressurePlate", "pressurePlate"));
                this.add(new BlockSubclassEntry(71, "Block", "doorSteel", "BlockDoor", "doorIron"));
                this.add(new BlockSubclassEntry(72, "Block", "pressurePlatePlanks", "BlockPressurePlate", "pressurePlate"));
                this.add(new BlockSubclassEntry(73, "Block", "oreRedstone", "BlockRedstoneOre", "oreRedstone"));
                this.add(new BlockSubclassEntry(74, "Block", "oreRedstoneGlowing", "BlockRedstoneOre", "oreRedstone"));
                this.add(new BlockSubclassEntry(75, "Block", "torchRedstoneIdle", "BlockRedstoneTorch", "notGate"));
                this.add(new BlockSubclassEntry(76, "Block", "torchRedstoneActive", "BlockRedstoneTorch", "notGate"));
                this.add(new BlockSubclassEntry(77, "Block", "stoneButton", "BlockButton", "button"));
                this.add(new BlockSubclassEntry(78, "Block", "snow", "BlockSnow", "snow"));
                this.add(new BlockSubclassEntry(79, "Block", "ice", "BlockIce", "ice"));
                this.add(new BlockSubclassEntry(80, "Block", "blockSnow", "BlockSnowBlock", "snow"));
                this.add(new BlockSubclassEntry(81, "Block", "cactus", "BlockCactus", "cactus"));
                this.add(new BlockSubclassEntry(82, "Block", "blockClay", "BlockClay", "clay"));
                this.add(new BlockSubclassEntry(83, "Block", "reed", "BlockReed", "reeds"));
                this.add(new BlockSubclassEntry(84, "Block", "jukebox", "BlockJukeBox", "jukebox"));
                this.add(new BlockSubclassEntry(85, "Block", "fence", "BlockFence", "fence"));
                this.add(new BlockSubclassEntry(86, "Block", "pumpkin", "BlockPumpkin", "pumpkin"));
                this.add(new BlockSubclassEntry(87, "Block", "netherrack", "BlockNetherrack", "hellrock"));
                this.add(new BlockSubclassEntry(88, "Block", "slowSand", "BlockSoulSand", "hellsand"));
                this.add(new BlockSubclassEntry(89, "Block", "glowStone", "BlockGlowStone", "lightgem"));
                this.add(new BlockSubclassEntry(90, "BlockPortal", "portal", "BlockPortal", "portal"));
                this.add(new BlockSubclassEntry(91, "Block", "pumpkinLantern", "BlockPumpkin", "litpumpkin"));
                this.add(new BlockSubclassEntry(92, "Block", "cake", "BlockCake", "cake"));
                this.add(new BlockSubclassEntry(93, "Block", "redstoneRepeaterIdle", "BlockRedstoneRepeater", "diode"));
                this.add(new BlockSubclassEntry(94, "Block", "redstoneRepeaterActive", "BlockRedstoneRepeater", "diode"));
                this.add(new BlockSubclassEntry(95, "Block", "lockedChest", "BlockLockedChest", "lockedchest"));
                this.add(new BlockSubclassEntry(96, "Block", "trapdoor", "BlockTrapDoor", "trapdoor"));
                this.add(new BlockSubclassEntry(97, "Block", "silverfish", "BlockSilverfish", "monsterStoneEgg"));
                this.add(new BlockSubclassEntry(98, "Block", "stoneBrick", "BlockStoneBrick", "stonebricksmooth"));
                this.add(new BlockSubclassEntry(99, "Block", "mushroomCapBrown", "BlockMushroomCap", "mushroom"));
                this.add(new BlockSubclassEntry(100, "Block", "mushroomCapRed", "BlockMushroomCap", "mushroom"));
                this.add(new BlockSubclassEntry(101, "Block", "fenceIron", "BlockPane", "fenceIron"));
                this.add(new BlockSubclassEntry(102, "Block", "thinGlass", "BlockPane", "thinGlass"));
                this.add(new BlockSubclassEntry(103, "Block", "melon", "BlockMelon", "melon"));
                this.add(new BlockSubclassEntry(104, "Block", "pumpkinStem", "BlockStem", "pumpkinStem"));
                this.add(new BlockSubclassEntry(105, "Block", "melonStem", "BlockStem", "pumpkinStem"));
                this.add(new BlockSubclassEntry(106, "Block", "vine", "BlockVine", "vine"));
                this.add(new BlockSubclassEntry(107, "Block", "fenceGate", "BlockFenceGate", "fenceGate"));
                this.add(new BlockSubclassEntry(108, "Block", "stairsBrick", "BlockStairs", "stairsBrick"));
                this.add(new BlockSubclassEntry(109, "Block", "stairsStoneBrickSmooth", "BlockStairs", "stairsStoneBrickSmooth"));
                this.add(new BlockSubclassEntry(110, "BlockMycelium", "mycelium", "BlockMycelium", "mycel"));
                this.add(new BlockSubclassEntry(111, "Block", "waterlily", "BlockLilyPad", "waterlily"));
                this.add(new BlockSubclassEntry(112, "Block", "netherBrick", "Block", "netherBrick"));
                this.add(new BlockSubclassEntry(113, "Block", "netherFence", "BlockFence", "netherFence"));
                this.add(new BlockSubclassEntry(114, "Block", "stairsNetherBrick", "BlockStairs", "stairsNetherBrick"));
                this.add(new BlockSubclassEntry(115, "Block", "netherStalk", "BlockNetherStalk", "netherStalk"));
                this.add(new BlockSubclassEntry(116, "Block", "enchantmentTable", "BlockEnchantmentTable", "enchantmentTable"));
                this.add(new BlockSubclassEntry(117, "Block", "brewingStand", "BlockBrewingStand", "brewingStand"));
                this.add(new BlockSubclassEntry(118, "Block", "cauldron", "BlockCauldron", "cauldron"));
                this.add(new BlockSubclassEntry(119, "Block", "endPortal", "BlockEndPortal", "unnamedBlock119"));
                this.add(new BlockSubclassEntry(120, "Block", "endPortalFrame", "BlockEndPortalFrame", "endPortalFrame"));
                this.add(new BlockSubclassEntry(121, "Block", "whiteStone", "Block", "whiteStone"));
                this.add(new BlockSubclassEntry(122, "Block", "dragonEgg", "BlockDragonEgg", "dragonEgg"));
                this.add(new BlockSubclassEntry(123, "Block", "redstoneLampIdle", "BlockRedstoneLight", "redstoneLight"));
                this.add(new BlockSubclassEntry(124, "Block", "redstoneLampActive", "BlockRedstoneLight", "redstoneLight"));
                this.add(new BlockSubclassEntry(125, "BlockHalfSlab", "woodDoubleSlab", "BlockWoodSlab", "woodSlab"));
                this.add(new BlockSubclassEntry(126, "BlockHalfSlab", "woodSingleSlab", "BlockWoodSlab", "woodSlab"));
                this.add(new BlockSubclassEntry(127, "Block", "cocoaPlant", "BlockCocoa", "cocoa"));
                this.add(new BlockSubclassEntry(128, "Block", "stairsSandStone", "BlockStairs", "stairsSandStone"));
                this.add(new BlockSubclassEntry(129, "Block", "oreEmerald", "BlockOre", "oreEmerald"));
                this.add(new BlockSubclassEntry(130, "Block", "enderChest", "BlockEnderChest", "enderChest"));
                this.add(new BlockSubclassEntry(131, "BlockTripWireSource", "tripWireSource", "BlockTripWireSource", "tripWireSource"));
                this.add(new BlockSubclassEntry(132, "Block", "tripWire", "BlockTripWire", "tripWire"));
                this.add(new BlockSubclassEntry(133, "Block", "blockEmerald", "BlockOreStorage", "blockEmerald"));
                this.add(new BlockSubclassEntry(134, "Block", "stairsWoodSpruce", "BlockStairs", "stairsWoodSpruce"));
                this.add(new BlockSubclassEntry(135, "Block", "stairsWoodBirch", "BlockStairs", "stairsWoodBirch"));
                this.add(new BlockSubclassEntry(136, "Block", "stairsWoodJungle", "BlockStairs", "stairsWoodJungle"));
                this.add(new BlockSubclassEntry(137, "Block", "commandBlock", "BlockCommandBlock", "commandBlock"));
                this.add(new BlockSubclassEntry(138, "Block", "beacon", "BlockBeacon", "beacon"));
                this.add(new BlockSubclassEntry(139, "Block", "cobblestoneWall", "BlockWall", "cobbleWall"));
                this.add(new BlockSubclassEntry(140, "Block", "flowerPot", "BlockFlowerPot", "flowerPot"));
                this.add(new BlockSubclassEntry(141, "Block", "carrot", "BlockCarrot", "carrots"));
                this.add(new BlockSubclassEntry(142, "Block", "potato", "BlockPotato", "potatoes"));
                this.add(new BlockSubclassEntry(143, "Block", "woodenButton", "BlockButton", "button"));
                this.add(new BlockSubclassEntry(144, "Block", "skull", "BlockSkull", "skull"));
                this.add(new BlockSubclassEntry(145, "Block", "anvil", "BlockAnvil", "anvil"));
            }
        };

        public BlockMod() {
            this.addClassSignature(new ConstSignature(" is already occupied by "));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "blockID", "I")).accessFlag(1, true).accessFlag(8, false).accessFlag(16, true));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "blocksList", "[LBlock;")).accessFlag(1, true).accessFlag(8, true).accessFlag(16, true));
        }

        protected void addBlockSignatures() {
            for (BlockSubclassEntry entry : subclasses) {
                this.addBlockSignature(entry.blockID, entry.fieldClass, entry.fieldName, entry.className, entry.blockName);
            }
        }

        protected void addBlockSignature(String name) {
            for (BlockSubclassEntry entry : subclasses) {
                if (!entry.className.equals(name) && !entry.blockName.equals(name) && !entry.fieldName.equals(name)) continue;
                this.addBlockSignature(entry.blockID, entry.fieldClass, entry.fieldName, entry.className, entry.blockName);
                return;
            }
            throw new RuntimeException("unknown Block subclass: " + name);
        }

        protected void addBlockSignature(int blockID) {
            for (BlockSubclassEntry entry : subclasses) {
                if (entry.blockID != blockID) continue;
                this.addBlockSignature(entry.blockID, entry.fieldClass, entry.fieldName, entry.className, entry.blockName);
                return;
            }
            throw new RuntimeException("unknown Block subclass: block ID" + blockID);
        }

        protected void addBlockSignature(final int blockID, String fieldClass, String fieldName, String className, final String blockName) {
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.captureReference(187), 89, blockID == 35 ? "" : this.push(blockID), BinaryRegex.nonGreedy(BinaryRegex.any(0, 60)), blockName.startsWith("unnamedBlock") ? "" : BinaryRegex.build(this.push(blockName), BytecodeMatcher.anyReference(182)), BinaryRegex.nonGreedy(BinaryRegex.any(0, 20)), BytecodeMatcher.captureReference(179));
                }
            }.matchStaticInitializerOnly(true).addXref(1, new ClassRef(className)).addXref(2, new FieldRef(this.getDeobfClass(), fieldName, "L" + fieldClass + ";")));
        }

        private static class BlockSubclassEntry {
            final int blockID;
            final String fieldClass;
            final String fieldName;
            final String className;
            final String blockName;

            BlockSubclassEntry(int blockID, String fieldClass, String fieldName, String className, String blockName) {
                this.blockID = blockID;
                this.fieldClass = fieldClass;
                this.fieldName = fieldName;
                this.className = className;
                this.blockName = blockName;
            }
        }
    }

    public static class IBlockAccessMod
    extends ClassMod {
        public IBlockAccessMod() {
            this.addClassSignature(new ClassSignature(){

                public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
                    return classFile.isAbstract();
                }
            });
            this.addClassSignature(new ClassSignature(){

                public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
                    List list = this.getClassFile().getMethods();
                    return list.size() >= 1 && ((MethodInfo)list.get(0)).getDescriptor().equals("(III)I");
                }
            });
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBlockId", "(III)I"), new MethodRef(this.getDeobfClass(), "getBlockMetadata", "(III)I")));
        }

        public IBlockAccessMod mapMaterial() {
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBlockMaterial", "(III)LMaterial;")));
            return this;
        }
    }

    public static class TessellatorMod
    extends ClassMod {
        protected final MethodRef draw = new MethodRef(this.getDeobfClass(), "draw", "()I");
        protected final MethodRef startDrawingQuads = new MethodRef(this.getDeobfClass(), "startDrawingQuads", "()V");
        protected final MethodRef startDrawing = new MethodRef(this.getDeobfClass(), "startDrawing", "(I)V");
        protected final MethodRef addVertexWithUV = new MethodRef(this.getDeobfClass(), "addVertexWithUV", "(DDDDD)V");
        protected final MethodRef addVertex = new MethodRef(this.getDeobfClass(), "addVertex", "(DDD)V");
        protected final MethodRef setTextureUV = new MethodRef(this.getDeobfClass(), "setTextureUV", "(DD)V");
        protected final FieldRef instance = new FieldRef(this.getDeobfClass(), "instance", "LTessellator;");

        public TessellatorMod(MinecraftVersion minecraftVersion) {
            MethodRef draw1;
            if (minecraftVersion.compareTo("Beta 1.9 Prerelease 4") >= 0) {
                draw1 = this.draw;
            } else {
                draw1 = new MethodRef(this.getDeobfClass(), "draw1", "()V");
                this.addPatch(new AddMethodPatch(this.draw){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(182, draw1), this.push(0), 172);
                    }
                });
            }
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("Not tesselating!"));
                }
            }.setMethod(draw1));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(7), BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(this.startDrawingQuads).addXref(1, this.startDrawing));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, 24, 7, 24, 9, BytecodeMatcher.captureReference(182), 42, 39, 41, 24, 5, BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(this.addVertexWithUV).addXref(1, this.setTextureUV).addXref(2, this.addVertex));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.instance).accessFlag(8, true));
        }
    }

    public static class GLAllocationMod
    extends ClassMod {
        public GLAllocationMod() {
            this.addClassSignature(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glDeleteLists", "(II)V")));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().equals("(I)Ljava/nio/ByteBuffer;")) {
                        return this.buildExpression(new Object[]{this.reference(184, new MethodRef("java.nio.ByteBuffer", "allocateDirect", "(I)Ljava/nio/ByteBuffer;"))});
                    }
                    return null;
                }
            }.setMethodName("createDirectByteBuffer"));
        }
    }

    public static class TexturePackDefaultMod
    extends ClassMod {
        public TexturePackDefaultMod() {
            this.parentClass = "TexturePackBase";
            this.addClassSignature(new ConstSignature("The default look of Minecraft"));
        }
    }

    public static class TexturePackBaseMod
    extends ClassMod {
        protected final boolean useITexturePack;

        public TexturePackBaseMod(MinecraftVersion minecraftVersion) {
            final MethodRef getResourceAsStream = new MethodRef("java.lang.Class", "getResourceAsStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            this.addClassSignature(new ConstSignature(getResourceAsStream));
            if (minecraftVersion.compareTo("12w15a") >= 0) {
                this.useITexturePack = true;
                this.addClassSignature(new ConstSignature("/pack.txt"));
                this.interfaces = new String[]{"ITexturePack"};
            } else {
                this.useITexturePack = false;
                this.addClassSignature(new ConstSignature("pack.txt").negate(true));
            }
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, this.reference(182, getResourceAsStream), 176);
                }
            }.setMethodName("getInputStream"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "texturePackFileName", "Ljava/lang/String;")));
            this.addPatch(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "texturePackFileName", "Ljava/lang/String;")));
        }
    }

    public static class TexturePackListMod
    extends ClassMod {
        protected final boolean useITexturePack;
        protected final String texturePackType;
        protected final FieldRef selectedTexturePack;
        protected final FieldRef defaultTexturePack;
        protected final MethodRef getDefaultTexturePack = new MethodRef(this.getDeobfClass(), "getDefaultTexturePack", "()LTexturePackBase;");
        protected final MethodRef getSelectedTexturePack = new MethodRef(this.getDeobfClass(), "getSelectedTexturePack", "()LTexturePackBase;");

        public TexturePackListMod(MinecraftVersion minecraftVersion) {
            this.addClassSignature(new ConstSignature(".zip"));
            this.addClassSignature(new ConstSignature("texturepacks"));
            if (minecraftVersion.compareTo("12w15a") >= 0) {
                this.useITexturePack = true;
                this.texturePackType = "LITexturePack;";
                this.selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", this.texturePackType);
                this.defaultTexturePack = new FieldRef(this.getDeobfClass(), "defaultTexturePack", this.texturePackType);
                this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.selectedTexturePack).accessFlag(2, true).accessFlag(8, false).accessFlag(16, false));
                this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.defaultTexturePack).accessFlag(2, true).accessFlag(8, true).accessFlag(16, true));
                this.addPatch(new AddMethodPatch(this.getDefaultTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(this.reference(178, TexturePackListMod.this.defaultTexturePack), this.reference(192, new ClassRef("TexturePackBase")), 176);
                    }
                });
                this.addPatch(new AddMethodPatch(this.getSelectedTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, TexturePackListMod.this.selectedTexturePack), this.reference(192, new ClassRef("TexturePackBase")), 176);
                    }
                });
            } else {
                this.useITexturePack = false;
                this.texturePackType = "LTexturePackBase;";
                this.selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", this.texturePackType);
                this.defaultTexturePack = new FieldRef(this.getDeobfClass(), "defaultTexturePack", this.texturePackType);
                this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.selectedTexturePack).accessFlag(1, true));
                this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.defaultTexturePack).accessFlag(2, true));
                this.addPatch(new AddMethodPatch(this.getDefaultTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, TexturePackListMod.this.defaultTexturePack), 176);
                    }
                });
                this.addPatch(new AddMethodPatch(this.getSelectedTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, TexturePackListMod.this.selectedTexturePack), 176);
                    }
                });
            }
        }
    }

    public static class MinecraftMod
    extends ClassMod {
        public MinecraftMod() {
            this.addClassSignature(new FilenameSignature("net/minecraft/client/Minecraft.class"));
        }

        public MinecraftMod mapTexturePackList() {
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "texturePackList", "LTexturePackList;")));
            return this;
        }

        public MinecraftMod addWorldGetter(MinecraftVersion minecraftVersion) {
            MethodRef getWorld = new MethodRef(this.getDeobfClass(), "getWorld", "()LWorld;");
            if (minecraftVersion.compareTo("12w18a") >= 0) {
                final FieldRef worldServer = new FieldRef(this.getDeobfClass(), "worldServer", "LWorldServer;");
                final FieldRef world = new FieldRef("WorldServer", "world", "LWorld;");
                this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, worldServer));
                this.addPatch(new AddMethodPatch(getWorld){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, worldServer), this.reference(180, world), 176);
                    }
                });
            } else {
                final FieldRef theWorld = new FieldRef(this.getDeobfClass(), "theWorld", "LWorld;");
                this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, theWorld));
                this.addPatch(new AddMethodPatch(getWorld){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, theWorld), 176);
                    }
                });
            }
            return this;
        }
    }

    private class XMinecraftMod
    extends MinecraftMod {
        XMinecraftMod() {
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "MCPatcherUtils.setMinecraft(this)";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().getName().equals("<init>")) {
                        return this.buildExpression(BinaryRegex.begin(), 42, this.reference(183, new MethodRef("java.lang.Object", "<init>", "()V")));
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.pclewis.mcpatcher.MCPatcherUtils", "setMinecraft", "(LMinecraft;)V")), this.push(MCPatcher.minecraft.getVersion().getVersionString()), this.push(MCPatcher.VERSION_STRING), this.reference(184, new MethodRef("com.pclewis.mcpatcher.MCPatcherUtils", "setVersions", "(Ljava/lang/String;Ljava/lang/String;)V")));
                }
            });
        }

        public String getDeobfClass() {
            return "Minecraft";
        }
    }

    class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JTextField heapSizeText;
        private JCheckBox autoRefreshTexturesCheckBox;
        private JTable logTable;

        ConfigPanel() {
            this.$$$setupUI$$$();
            this.autoRefreshTexturesCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("autoRefreshTextures", ConfigPanel.this.autoRefreshTexturesCheckBox.isSelected());
                }
            });
            this.logTable.setModel(new TableModel(){

                private Vector<String> getCategories() {
                    Vector<String> allCategories = new Vector<String>();
                    for (Mod mod : MCPatcher.modList.getAll()) {
                        String[] categories = mod.getLoggingCategories();
                        if (categories == null) continue;
                        for (String category : categories) {
                            if (category == null) continue;
                            allCategories.add(category);
                        }
                    }
                    return allCategories;
                }

                private String getCategory(int rowIndex) {
                    Vector<String> categories = this.getCategories();
                    return rowIndex >= 0 && rowIndex < categories.size() ? categories.elementAt(rowIndex) : null;
                }

                @Override
                public int getRowCount() {
                    return this.getCategories().size();
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public String getColumnName(int columnIndex) {
                    return null;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return columnIndex == 1;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    String category = this.getCategory(rowIndex);
                    if (category == null) {
                        return null;
                    }
                    return columnIndex == 0 ? category : MCPatcherUtils.getLogLevel(category);
                }

                @Override
                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                    String category = this.getCategory(rowIndex);
                    if (columnIndex != 1 || category == null) {
                        return;
                    }
                    try {
                        MCPatcherUtils.setLogLevel(category, Level.parse(aValue.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }

                @Override
                public void addTableModelListener(TableModelListener l) {
                }

                @Override
                public void removeTableModelListener(TableModelListener l) {
                }
            });
            JComboBox<Level> combo = new JComboBox<Level>();
            combo.addItem(Level.OFF);
            combo.addItem(Level.SEVERE);
            combo.addItem(Level.WARNING);
            combo.addItem(Level.INFO);
            combo.addItem(Level.CONFIG);
            combo.addItem(Level.FINE);
            combo.addItem(Level.FINER);
            combo.addItem(Level.FINEST);
            combo.addItem(Level.ALL);
            this.logTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(combo));
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public String getPanelName() {
            return "General options";
        }

        public void load() {
            this.heapSizeText.setText("" + MCPatcherUtils.getInt("javaHeapSize", 1024));
            this.autoRefreshTexturesCheckBox.setSelected(MCPatcherUtils.getBoolean("autoRefreshTextures", false));
        }

        public void save() {
            try {
                MCPatcherUtils.set("javaHeapSize", Integer.parseInt(this.heapSizeText.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTable jTable;
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Java heap size (MB)");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.heapSizeText = jTextField = new JTextField();
            jTextField.setColumns(5);
            jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.autoRefreshTexturesCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText("Automatically reload textures when .zip file changes (may affect performance).");
            jCheckBox.setText("Detect texture pack changes");
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.logTable = jTable = new JTable();
            jPanel.add((Component)jTable, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Game debug logging:");
            jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

