/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.vec.ITransformation;
import codechicken.core.vec.Matrix4;
import codechicken.core.vec.Quat;
import codechicken.core.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class Rotation
implements ITransformation {
    public static Rotation[] sideRotations = new Rotation[]{new Rotation(0.0, 1.0, 0.0, 0.0), new Rotation(Math.PI, 1.0, 0.0, 0.0), new Rotation(1.5707963267948966, 1.0, 0.0, 0.0), new Rotation(-1.5707963267948966, 1.0, 0.0, 0.0), new Rotation(-1.5707963267948966, 0.0, 0.0, 1.0), new Rotation(1.5707963267948966, 0.0, 0.0, 1.0)};
    public static Rotation[] sideRotationsR = new Rotation[6];
    public static Quat[] sideQuats = new Quat[6];
    public static Quat[] sideQuatsR = new Quat[6];
    public static Vector3[] axes = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    public double angle;
    public Vector3 axis;
    public Vector3 point;
    private Vector3 negate;
    private Quat quat;

    static {
        int i = 0;
        while (i < 6) {
            Rotation r = sideRotations[i];
            Rotation.sideRotationsR[i] = new Rotation(-r.angle, r.axis);
            Rotation.sideQuats[i] = r.toQuat();
            Rotation.sideQuatsR[i] = sideRotationsR[i].toQuat();
            ++i;
        }
    }

    public Rotation(double angle, Vector3 axis, Vector3 point) {
        this.angle = angle;
        this.axis = axis;
        this.point = point;
    }

    public Rotation(double angle, Vector3 axis) {
        this(angle, axis, null);
    }

    public Rotation(double angle, double x, double y2, double z2) {
        this(angle, new Vector3(x, y2, z2));
    }

    @Override
    public void transform(Vector3 vec) {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(this.axis, this.angle);
        }
        if (this.point == null) {
            vec.rotate(this.quat);
        } else {
            vec.subtract(this.point).rotate(this.quat).add(this.point);
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        if (this.point == null) {
            mat.rotate(this.angle, this.axis);
        } else {
            if (this.negate == null) {
                this.negate = this.point.copy().negate();
            }
            mat.translate(this.point);
            mat.rotate(this.angle, this.axis);
            mat.translate(this.negate);
        }
    }

    public Quat toQuat() {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(this.axis, this.angle);
        }
        return this.quat;
    }

    @SideOnly(value=Side.CLIENT)
    public void glRotate() {
        if (this.point == null) {
            GL11.glRotatef((float)((float)this.angle * 57.2958f), (float)((float)this.axis.x), (float)((float)this.axis.y), (float)((float)this.axis.z));
        } else {
            GL11.glTranslated((double)this.point.x, (double)this.point.y, (double)this.point.z);
            GL11.glRotatef((float)((float)this.angle * 57.2958f), (float)((float)this.axis.x), (float)((float)this.axis.y), (float)((float)this.axis.z));
            GL11.glTranslated((double)(-this.point.x), (double)(-this.point.y), (double)(-this.point.z));
        }
    }
}

