/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.vec.Vector3;

public class Cuboid6 {
    public Vector3 min;
    public Vector3 max;

    public Cuboid6(Vector3 min, Vector3 max) {
        this.min = min;
        this.max = max;
    }

    public Cuboid6(aqx aabb) {
        this.min = new Vector3(aabb.a, aabb.b, aabb.c);
        this.max = new Vector3(aabb.d, aabb.e, aabb.f);
    }

    public Cuboid6(Cuboid6 cuboid) {
        this.min = cuboid.min.copy();
        this.max = cuboid.max.copy();
    }

    public Cuboid6(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min = new Vector3(minx, miny, minz);
        this.max = new Vector3(maxx, maxy, maxz);
    }

    public aqx toAABB() {
        return aqx.a((double)this.min.x, (double)this.min.y, (double)this.min.z, (double)this.max.x, (double)this.max.y, (double)this.max.z);
    }

    public Cuboid6 copy() {
        return new Cuboid6(this);
    }

    public Cuboid6 add(Vector3 vec) {
        this.min.add(vec);
        this.max.add(vec);
        return this;
    }

    public void setBlockBounds(apa block) {
        block.a((float)this.min.x, (float)this.min.y, (float)this.min.z, (float)this.max.x, (float)this.max.y, (float)this.max.z);
    }

    public boolean intersects(Cuboid6 b) {
        return this.max.x - 1.0E-5 > b.min.x && b.max.x - 1.0E-5 > this.min.x && this.max.y - 1.0E-5 > b.min.y && b.max.y - 1.0E-5 > this.min.y && this.max.z - 1.0E-5 > b.min.z && b.max.z - 1.0E-5 > this.min.z;
    }

    public Cuboid6 offset(Cuboid6 o) {
        this.min.add(o.min);
        this.max.add(o.max);
        return this;
    }

    public Vector3 center() {
        return this.min.copy().add(this.max).multiply(0.5);
    }

    public static boolean intersects(Cuboid6 a, Cuboid6 b) {
        return a != null && b != null && a.intersects(b);
    }
}

