/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.PlaceholderTexture;
import codechicken.core.render.TextureSpecial;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;

public class TextureUtils {
    private static HashMap textureDimensions;
    private static ArrayList iconRegistrars;

    static {
        bgy.a.q.put(TextureUtils.class, new RegisterTextureCallback());
        textureDimensions = new HashMap();
        iconRegistrars = new ArrayList();
    }

    public static void addIconRegistrar(IIconRegister registrar) {
        iconRegistrars.add(registrar);
    }

    public static bio createTextureObject(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        return new bio(textureFile, 2, img.getWidth(), img.getHeight(), 10496, 6408, 9728, 9728, img);
    }

    public static InputStream getTextureResource(String textureFile) throws IOException {
        return TextureUtils.engine().g.e().a(textureFile);
    }

    public static BufferedImage loadBufferedImage(String textureFile) {
        try {
            InputStream in = TextureUtils.getTextureResource(textureFile);
            if (in != null) {
                BufferedImage img = TextureUtils.loadBufferedImage(in);
                if (img != null) {
                    textureDimensions.put(textureFile, new Dimension(img.getWidth(), img.getHeight()));
                }
                return img;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
        }
        textureDimensions.put(textureFile, new Dimension(0, 0));
        return null;
    }

    public static Dimension getTextureDimension(String textureFile) {
        Dimension dim = (Dimension)textureDimensions.get(textureFile);
        if (dim == null) {
            TextureUtils.loadBufferedImage(textureFile);
            dim = (Dimension)textureDimensions.get(textureFile);
        }
        return dim;
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static bge engine() {
        return Minecraft.x().p;
    }

    public static bio createTextureObject(String name, int w, int h) {
        return new bio(name, 2, w, h, 10496, 6408, 9728, 9728, null);
    }

    public static void copySubImg(bio fromTex, int fromX, int fromY, int width, int height, bio toTex, int toX, int toY) {
        int fromWidth = fromTex.d();
        ByteBuffer from = fromTex.h();
        bio tmp = TextureUtils.createTextureObject("tmp", width, height);
        ByteBuffer to = tmp.h();
        from.position(0);
        to.position(0);
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                int fp = ((y2 + fromY) * fromWidth + x + fromX) * 4;
                int tp2 = (y2 * width + x) * 4;
                to.put(tp2, from.get(fp));
                to.put(tp2 + 1, from.get(fp + 1));
                to.put(tp2 + 2, from.get(fp + 2));
                to.put(tp2 + 3, from.get(fp + 3));
                ++x;
            }
            ++y2;
        }
        toTex.a(toX, toY, tmp, false);
    }

    public static void write(byte[] data, int width, int height, bio toTex, int toX, int toY) {
        bio tmp = TextureUtils.createTextureObject("tmp", width, height);
        ByteBuffer to = tmp.h();
        to.position(0);
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                int p = (y2 * width + x) * 4;
                to.put(p, data[p]);
                to.put(p + 1, data[p + 1]);
                to.put(p + 2, data[p + 2]);
                to.put(p + 3, data[p + 3]);
                ++x;
            }
            ++y2;
        }
        toTex.a(toX, toY, tmp, false);
    }

    public static boolean refreshTexture(bir map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (bil)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static void bindItemTexture(wm stack) {
        TextureUtils.engine().b(stack.d() == 0 ? "/terrain.png" : "/gui/items.png");
    }

    public static void bindTexture(String string) {
        TextureUtils.engine().b(string);
    }

    public static lx getIconFromTexture(String name, ly iconRegister, boolean animated) {
        bir textureMap = (bir)iconRegister;
        TextureSpecial icon = new TextureSpecial(name).setTextureFile(name).useVanillaAnimation(animated);
        textureMap.setTextureEntry(name, (bil)icon);
        return icon;
    }

    public static lx getIconFromTexture(String name, ly iconRegister) {
        return TextureUtils.getIconFromTexture(name, iconRegister, true);
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glBindTexture((int)target, (int)texture);
        TextureUtils.engine().a();
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static interface IIconRegister {
        public void registerIcons(ly var1);
    }

    private static class RegisterTextureCallback
    extends bgz {
        private RegisterTextureCallback() {
        }

        public void a(mp entity, double d0, double d1, double d2, float f, float f1) {
        }

        public void a(ly par1IconRegister) {
            for (IIconRegister r : iconRegistrars) {
                r.registerIcons(par1IconRegister);
            }
        }
    }
}

