/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.SpriteSheetManager;
import codechicken.core.render.TextureFX;
import codechicken.core.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

@SideOnly(value=Side.CLIENT)
public class TextureSpecial
extends bil
implements TextureUtils.IIconRegister {
    private int spriteIndex;
    private SpriteSheetManager.SpriteSheet spriteSheet;
    private TextureFX textureFX;
    private int blankSize = -1;
    private String textureFile;
    private boolean vanillaAnimate;
    private boolean selfRegister;

    protected TextureSpecial(String par1) {
        super(par1);
    }

    public TextureSpecial baseFromSheet(SpriteSheetManager.SpriteSheet spriteSheet, int spriteIndex) {
        this.spriteSheet = spriteSheet;
        this.spriteIndex = spriteIndex;
        return this;
    }

    public TextureSpecial addTextureFX(TextureFX fx) {
        this.textureFX = fx;
        return this;
    }

    public void a(bio par1Texture, List par2List, int originX, int originY, int width, int height, boolean par7) {
        super.a(par1Texture, par2List, originX, originY, width, height, par7);
        if (this.textureFX != null) {
            this.textureFX.onTextureDimensionsUpdate(width, height);
        } else if (this.textureFile != null && this.vanillaAnimate && this.b.size() > 0) {
            try {
                InputStream in = TextureUtils.getTextureResource(this.textureFile.replace(".png", ".txt"));
                this.a(new BufferedReader(new InputStreamReader(in)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void l() {
        super.l();
        if (this.textureFX != null) {
            this.textureFX.update();
            if (this.textureFX.changed()) {
                TextureUtils.write(this.textureFX.imageData, this.textureFX.tileSizeBase, this.textureFX.tileSizeBase, this.a, this.d, this.e);
            }
        }
    }

    public boolean loadTexture(biq manager, bjt texturepack, String name, String fileName, BufferedImage image, ArrayList textures) {
        if (this.spriteSheet != null) {
            textures.add(this.spriteSheet.createSprite(this.spriteIndex));
        } else if (this.blankSize > 0) {
            textures.add(TextureUtils.createTextureObject(name, this.blankSize, this.blankSize));
        } else if (this.textureFile != null) {
            bio tex = TextureUtils.createTextureObject(this.textureFile);
            int width = tex.d();
            int height = tex.e();
            if (this.vanillaAnimate && height > width) {
                int frames = height / width;
                int frame = 0;
                while (frame < frames) {
                    bio frameTex = TextureUtils.createTextureObject(name, width, width);
                    TextureUtils.copySubImg(tex, 0, width * frame, width, width, frameTex, 0, 0);
                    textures.add(frameTex);
                    ++frame;
                }
            } else {
                textures.add(tex);
            }
        }
        if (this.textureFX != null) {
            if (textures.isEmpty()) {
                throw new RuntimeException("TextureFX with no base sprite: " + name);
            }
            bio base = (bio)textures.get(0);
            textures.add(TextureUtils.createTextureObject(String.valueOf(name) + "$2", base.d(), base.e()));
        }
        if (!textures.isEmpty()) {
            return true;
        }
        return super.loadTexture(manager, texturepack, name, fileName, image, textures);
    }

    public TextureSpecial blank(int size) {
        this.blankSize = size;
        this.selfRegister();
        return this;
    }

    public TextureSpecial setTextureFile(String fileName) {
        this.textureFile = fileName;
        return this;
    }

    public void selfRegister() {
        this.selfRegister = true;
        TextureUtils.addIconRegistrar(this);
    }

    @Override
    public void registerIcons(ly register) {
        if (this.selfRegister) {
            ((bir)register).setTextureEntry(this.i(), (bil)this);
        }
    }

    public TextureSpecial useVanillaAnimation(boolean b) {
        this.vanillaAnimate = b;
        return this;
    }
}

