/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.CCModel;
import codechicken.core.render.CCRenderState;
import codechicken.core.render.IUVTransformation;
import codechicken.core.render.TextureUtils;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Translation;
import codechicken.core.vec.Vector3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static bhi uniformRenderItem = new bhi(){

        public boolean shouldBob() {
            return false;
        }
    };
    static rh entityItem;

    static {
        int i = 0;
        while (i < vectors.length) {
            RenderUtils.vectors[i] = new Vector3();
            ++i;
        }
        uniformRenderItem.a(bgy.a);
        entityItem = new rh(null);
        RenderUtils.entityItem.c = 0.0f;
    }

    public static void addVecWithUV(Vector3 vec, double u, double v2) {
        bgd.a.a(vec.x, vec.y, vec.z, u, v2);
    }

    public static lx bindLiquidTexture(int liquidID, int liquidMeta) {
        if (liquidID < apa.r.length && apa.r[liquidID] != null) {
            apa liquidBlock = apa.r[liquidID];
            return liquidBlock.a(0, liquidMeta);
        }
        wk liquidItem = wk.f[liquidID];
        if (liquidItem == null) {
            return null;
        }
        return liquidItem.a_(liquidMeta);
    }

    public static void renderLiquidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, lx icon, double res) {
        double u1 = icon.e();
        double du = icon.f() - icon.e();
        double v2 = icon.h();
        double dv = icon.h() - icon.g();
        Vector3 wide = vectors[0].set(point4).subtract(point1);
        Vector3 high = vectors[1].set(point1).subtract(point2);
        bgd t = bgd.a;
        double wlen = wide.mag();
        double hlen = high.mag();
        double x = 0.0;
        while (x < wlen) {
            double rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            double y2 = 0.0;
            while (y2 < hlen) {
                double ry = hlen - y2;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y2 / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y2 + ry) / hlen);
                t.a(point2.x + dx1.x + dy2.x, point2.y + dx1.y + dy2.y, point2.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                t.a(point2.x + dx1.x + dy1.x, point2.y + dx1.y + dy1.y, point2.z + dx1.z + dy1.z, u1, v2);
                t.a(point2.x + dx2.x + dy1.x, point2.y + dx2.y + dy1.y, point2.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                t.a(point2.x + dx2.x + dy2.x, point2.y + dx2.y + dy2.y, point2.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
                y2 += ry;
            }
            x += rx;
        }
    }

    public static void translateToWorldCoords(mp entity, float frame) {
        double interpPosX = entity.U + (entity.u - entity.U) * (double)frame;
        double interpPosY = entity.V + (entity.v - entity.V) * (double)frame;
        double interpPosZ = entity.W + (entity.w - entity.W) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawOutlinedBoundingBox(aqx par1AxisAlignedBB) {
        bgd var2 = bgd.a;
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a();
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a();
        var2.b(1);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a();
    }

    public static void renderLiquidCuboid(Cuboid6 bound, lx tex, double res) {
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y2, int z2, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y2 - 0.009, (double)y2 + 1.009, (double)z2 - 0.009, (double)z2 + 1.009};
        bgd tessellator = bgd.a;
        switch (side) {
            case 0: {
                tessellator.a(points[0], points[2], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx2, ty1);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty2);
                tessellator.a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.a(points[0], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.a(points[1], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty1);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.a(points[0], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[5], tx1, ty1);
                tessellator.a(points[1], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderLiquid(LiquidStack liquid) {
        return liquid.amount > 0 && liquid.asItemStack().b() != null;
    }

    public static void renderLiquidCuboid(LiquidStack liquid, Cuboid6 bound, double res) {
        if (!RenderUtils.shouldRenderLiquid(liquid)) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.setColourOpaque(liquid.asItemStack().b().a(liquid.asItemStack(), 0));
        TextureUtils.bindItemTexture(liquid.asItemStack());
        lx tex = RenderUtils.bindLiquidTexture(liquid.itemID, liquid.itemMeta);
        CCRenderState.startDrawing(7);
        RenderUtils.renderLiquidCuboid(bound, tex, res);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static void renderItemUniform(wm item) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((wm)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (is3D || item.b() instanceof xn && bgf.a((int)apa.r[item.c].d())) {
            int renderType = apa.r[item.c].d();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        bkn.a((int)bkn.b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.a(item);
        uniformRenderItem.a(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, 0.0f);
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    public static void renderBlock(Cuboid6 bounds, BlockCoord pos, IUVTransformation u) {
        CCRenderState.reset();
        CCModel.quadModel(24).generateBlock(0, bounds).render(new Translation(new Vector3(pos.x, pos.y, pos.z)), u);
    }
}

