/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.CCModel;
import codechicken.core.render.Vertex5;
import codechicken.core.vec.Rotation;
import codechicken.core.vec.Vector3;
import net.minecraft.client.Minecraft;

public class CCRBModel
extends CCModel {
    public LC[] lightCoefficents;
    private LightMatrix lightMatrix;

    protected CCRBModel(CCModel m) {
        super(m.vertexMode);
        this.verts = new Vertex5[m.verts.length];
        CCRBModel.copy(m, 0, this, 0, m.verts.length);
        if (this.normals == null) {
            this.computeNormals();
        }
        if (this.colours == null) {
            this.setColour(-1);
        }
        this.computeLighting();
    }

    private void computeLighting() {
        this.lightCoefficents = new LC[this.verts.length];
        int k = 0;
        while (k < this.verts.length) {
            this.lightCoefficents[k] = LC.compute(this.verts[k].vec, this.normals[k]);
            ++k;
        }
    }

    public CCRBModel setLightMatrix(LightMatrix m) {
        this.lightMatrix = m;
        return this;
    }

    @Override
    public void applyColour(bgd tess, int i) {
        if (this.lightMatrix == null) {
            super.applyColour(tess, i);
        } else {
            this.lightMatrix.setColour(tess, this.lightCoefficents[i], this.colours[i]);
        }
    }

    @Override
    public void applyVertexModifiers(bgd tess, int i) {
        if (this.lightMatrix != null) {
            this.lightMatrix.setBrightness(tess, this.lightCoefficents[i]);
        }
    }

    public static class LC {
        public int side;
        public float fa;
        public float fb;
        public float fc;
        public float fd;

        public LC(int s, float e, float f, float g, float h) {
            this.side = s;
            this.fa = e;
            this.fb = f;
            this.fc = g;
            this.fd = h;
        }

        public static LC compute(Vector3 vec, Vector3 normal) {
            int side = CCRBModel.findSide(normal);
            if (side < 0) {
                throw new IllegalArgumentException("Non axial vertex normal " + normal);
            }
            return LC.compute(vec, side);
        }

        public static LC compute(Vector3 vec, int side) {
            boolean offset = false;
            switch (side) {
                case 0: {
                    offset = vec.y <= 0.0;
                    break;
                }
                case 1: {
                    offset = vec.y >= 1.0;
                    break;
                }
                case 2: {
                    offset = vec.z <= 0.0;
                    break;
                }
                case 3: {
                    offset = vec.z >= 1.0;
                    break;
                }
                case 4: {
                    offset = vec.x <= 0.0;
                    break;
                }
                case 5: {
                    boolean bl = offset = vec.x >= 1.0;
                }
            }
            if (!offset) {
                side += 6;
            }
            Vector3 v1 = Rotation.axes[((side & 0xE) + 3) % 6];
            Vector3 v2 = Rotation.axes[((side & 0xE) + 5) % 6];
            float d1 = (float)vec.scalarProject(v1);
            float d2 = 1.0f - d1;
            float d3 = (float)vec.scalarProject(v2);
            float d4 = 1.0f - d3;
            return new LC(side, d2 * d4, d2 * d3, d1 * d4, d1 * d3);
        }
    }

    public static class LightMatrix {
        public int computed = 0;
        public float[][] ao = new float[12][4];
        public int[][] brightness = new int[12][4];
        private float[] aSamples = new float[27];
        private int[] bSamples = new int[27];
        public static final int[][] ssamplem;
        public static final int[][] qsamplem;
        public static final float[] sideao;

        static {
            int[][] nArrayArray = new int[12][];
            int[] nArray = new int[9];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 8;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{18, 19, 20, 21, 22, 23, 24, 25, 26};
            int[] nArray2 = new int[9];
            nArray2[1] = 9;
            nArray2[2] = 18;
            nArray2[3] = 1;
            nArray2[4] = 10;
            nArray2[5] = 19;
            nArray2[6] = 2;
            nArray2[7] = 11;
            nArray2[8] = 20;
            nArrayArray[2] = nArray2;
            nArrayArray[3] = new int[]{6, 15, 24, 7, 16, 25, 8, 17, 26};
            int[] nArray3 = new int[9];
            nArray3[1] = 3;
            nArray3[2] = 6;
            nArray3[3] = 9;
            nArray3[4] = 12;
            nArray3[5] = 15;
            nArray3[6] = 18;
            nArray3[7] = 21;
            nArray3[8] = 24;
            nArrayArray[4] = nArray3;
            nArrayArray[5] = new int[]{2, 5, 8, 11, 14, 17, 20, 23, 26};
            nArrayArray[6] = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
            nArrayArray[7] = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
            nArrayArray[8] = new int[]{3, 12, 21, 4, 13, 22, 5, 14, 23};
            nArrayArray[9] = new int[]{3, 12, 21, 4, 13, 22, 5, 14, 23};
            nArrayArray[10] = new int[]{1, 4, 7, 10, 13, 16, 19, 22, 25};
            nArrayArray[11] = new int[]{1, 4, 7, 10, 13, 16, 19, 22, 25};
            ssamplem = nArrayArray;
            int[][] nArrayArray2 = new int[4][];
            int[] nArray4 = new int[4];
            nArray4[1] = 1;
            nArray4[2] = 3;
            nArray4[3] = 4;
            nArrayArray2[0] = nArray4;
            nArrayArray2[1] = new int[]{5, 1, 2, 4};
            nArrayArray2[2] = new int[]{6, 7, 3, 4};
            nArrayArray2[3] = new int[]{5, 7, 8, 4};
            qsamplem = nArrayArray2;
            sideao = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
        }

        public void computeAt(aak a, int x, int y2, int z2) {
            this.computed = 0;
            this.sample(0, this.aSamples, this.bSamples, a, x - 1, y2 - 1, z2 - 1);
            this.sample(1, this.aSamples, this.bSamples, a, x, y2 - 1, z2 - 1);
            this.sample(2, this.aSamples, this.bSamples, a, x + 1, y2 - 1, z2 - 1);
            this.sample(3, this.aSamples, this.bSamples, a, x - 1, y2 - 1, z2);
            this.sample(4, this.aSamples, this.bSamples, a, x, y2 - 1, z2);
            this.sample(5, this.aSamples, this.bSamples, a, x + 1, y2 - 1, z2);
            this.sample(6, this.aSamples, this.bSamples, a, x - 1, y2 - 1, z2 + 1);
            this.sample(7, this.aSamples, this.bSamples, a, x, y2 - 1, z2 + 1);
            this.sample(8, this.aSamples, this.bSamples, a, x + 1, y2 - 1, z2 + 1);
            this.sample(9, this.aSamples, this.bSamples, a, x - 1, y2, z2 - 1);
            this.sample(10, this.aSamples, this.bSamples, a, x, y2, z2 - 1);
            this.sample(11, this.aSamples, this.bSamples, a, x + 1, y2, z2 - 1);
            this.sample(12, this.aSamples, this.bSamples, a, x - 1, y2, z2);
            this.sample(13, this.aSamples, this.bSamples, a, x, y2, z2);
            this.sample(14, this.aSamples, this.bSamples, a, x + 1, y2, z2);
            this.sample(15, this.aSamples, this.bSamples, a, x - 1, y2, z2 + 1);
            this.sample(16, this.aSamples, this.bSamples, a, x, y2, z2 + 1);
            this.sample(17, this.aSamples, this.bSamples, a, x + 1, y2, z2 + 1);
            this.sample(18, this.aSamples, this.bSamples, a, x - 1, y2 + 1, z2 - 1);
            this.sample(19, this.aSamples, this.bSamples, a, x, y2 + 1, z2 - 1);
            this.sample(20, this.aSamples, this.bSamples, a, x + 1, y2 + 1, z2 - 1);
            this.sample(21, this.aSamples, this.bSamples, a, x - 1, y2 + 1, z2);
            this.sample(22, this.aSamples, this.bSamples, a, x, y2 + 1, z2);
            this.sample(23, this.aSamples, this.bSamples, a, x + 1, y2 + 1, z2);
            this.sample(24, this.aSamples, this.bSamples, a, x - 1, y2 + 1, z2 + 1);
            this.sample(25, this.aSamples, this.bSamples, a, x, y2 + 1, z2 + 1);
            this.sample(26, this.aSamples, this.bSamples, a, x + 1, y2 + 1, z2 + 1);
        }

        public int[] brightness(int side) {
            this.sideSample(side);
            return this.brightness[side];
        }

        public float[] ao(int side) {
            this.sideSample(side);
            return this.ao[side];
        }

        public void sideSample(int side) {
            if ((this.computed & 1 << side) == 0) {
                int[] ssample = ssamplem[side];
                int q = 0;
                while (q < 4) {
                    int[] qsample = qsamplem[q];
                    if (Minecraft.u()) {
                        this.interp(side, q, ssample[qsample[0]], ssample[qsample[1]], ssample[qsample[2]], ssample[qsample[3]]);
                    } else {
                        this.interp(side, q, ssample[4], ssample[4], ssample[4], ssample[4]);
                    }
                    ++q;
                }
                this.computed |= 1 << side;
            }
        }

        private void sample(int i, float[] aSamples, int[] bSamples, aak a, int x, int y2, int z2) {
            int bid = a.a(x, y2, z2);
            apa b = apa.r[bid];
            if (b == null) {
                bSamples[i] = a.h(x, y2, z2, 0);
                aSamples[i] = 1.0f;
            } else {
                bSamples[i] = a.h(x, y2, z2, b.getLightValue(a, x, y2, z2));
                aSamples[i] = b.i(a, x, y2, z2);
            }
        }

        private void interp(int s, int q, int a, int b, int c, int d) {
            this.ao[s][q] = LightMatrix.interpAO(this.aSamples[a], this.aSamples[b], this.aSamples[c], this.aSamples[d]) * sideao[s];
            this.brightness[s][q] = LightMatrix.interpBrightness(this.bSamples[a], this.bSamples[b], this.bSamples[c], this.bSamples[d]);
        }

        public static float interpAO(float a, float b, float c, float d) {
            return (a + b + c + d) / 4.0f;
        }

        public static int interpBrightness(int a, int b, int c, int d) {
            if (a == 0) {
                a = d;
            }
            if (b == 0) {
                b = d;
            }
            if (c == 0) {
                c = d;
            }
            return a + b + c + d >> 2 & 0xFF00FF;
        }

        public void setColour(bgd tess, LC lc, int c) {
            float[] a = this.ao(lc.side);
            float f = a[0] * lc.fa + a[1] * lc.fb + a[2] * lc.fc + a[3] * lc.fd;
            tess.a((int)((float)(c >>> 24) * f), (int)((float)(c >> 16 & 0xFF) * f), (int)((float)(c >> 8 & 0xFF) * f), c & 0xFF);
        }

        public void setBrightness(bgd tess, LC lc) {
            int[] b = this.brightness(lc.side);
            tess.c((int)((float)b[0] * lc.fa + (float)b[1] * lc.fb + (float)b[2] * lc.fc + (float)b[3] * lc.fd) & 0xFF00FF);
        }
    }
}

