/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.gui;

import codechicken.core.alg.MathHelper;
import codechicken.core.gui.GuiWidget;
import codechicken.core.gui.IGuiActionListener;

public abstract class GuiScrollSlot
extends GuiWidget {
    protected awg scrollupbutton;
    protected awg scrolldownbutton;
    protected String actionCommand;
    protected IGuiActionListener parentscreen;
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    protected int lastslotclicked = -1;
    protected int lastbuttonclicked = -1;
    protected long lastslotclicktime;
    public boolean focused;
    protected int contentx;
    protected int contenty;
    protected int contentheight;
    protected boolean smoothScroll = true;

    public GuiScrollSlot(int x, int y2, int width, int height) {
        super(x, y2, width, height);
        this.setContentSize(x + 3, y2 + 2, height - 2);
    }

    public void setSmoothScroll(boolean b) {
        this.smoothScroll = b;
    }

    @Override
    public void setSize(int x, int y2, int width, int height) {
        int cx = this.contentx - this.x;
        int cy = this.contenty - this.y;
        int ch2 = height - this.contentheight;
        super.setSize(x, y2, width, height);
        this.setContentSize(x + cx, y2 + cy, height - ch2);
    }

    public void setContentSize(int x, int y2, int h) {
        this.contentx = x;
        this.contenty = y2;
        this.contentheight = h;
    }

    public void registerButtons(awg up, awg down, String selectionCommand) {
        this.scrollupbutton = up;
        this.scrolldownbutton = down;
        this.actionCommand = selectionCommand;
    }

    public abstract int getSlotHeight();

    protected abstract int getNumSlots();

    public abstract void selectNext();

    public abstract void selectPrev();

    protected abstract void slotClicked(int var1, int var2, int var3, int var4, boolean var5);

    protected abstract boolean isSlotSelected(int var1);

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, boolean var6);

    protected void unfocus() {
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
        if (!this.focused) {
            this.unfocus();
        }
    }

    public void scrollUp() {
        this.percentscrolled = (float)((double)this.percentscrolled - 0.05);
        this.calculatePercentScrolled();
    }

    public void scrollDown() {
        this.percentscrolled = (float)((double)this.percentscrolled + 0.05);
        this.calculatePercentScrolled();
    }

    public int totalContentHeight() {
        return this.getNumSlots() * this.getSlotHeight();
    }

    public int getSlotY(int slot) {
        int scrolledPixels = (int)((double)((float)(this.totalContentHeight() - this.contentheight) * this.percentscrolled) + 0.5);
        if (!this.smoothScroll) {
            scrolledPixels = (int)((double)scrolledPixels / (double)this.getSlotHeight() + 0.5) * this.getSlotHeight();
        }
        return this.contenty - scrolledPixels + slot * this.getSlotHeight();
    }

    public int getClickedSlot(int mousey) {
        if (mousey < this.contenty || mousey >= this.contenty + this.contentheight) {
            return -1;
        }
        int slot = 0;
        while (slot < this.getNumSlots()) {
            int sloty = this.getSlotY(slot);
            if (mousey >= sloty && mousey < sloty + this.getSlotHeight()) {
                return slot;
            }
            ++slot;
        }
        return -1;
    }

    public int getScrollBarWidth() {
        return 5;
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.contentheight / (float)this.totalContentHeight() * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        this.percentscrolled = (float)MathHelper.clip(this.percentscrolled, 0.0, 1.0);
    }

    public void showSlot(int slot) {
        int sloty = this.getSlotY(slot);
        if (sloty + this.getSlotHeight() > this.contenty + this.contentheight) {
            int diff = sloty - (this.contenty + this.contentheight - this.getSlotHeight());
            this.percentscrolled = (float)((double)this.percentscrolled + (double)diff / (double)(this.totalContentHeight() - this.contentheight));
            this.calculatePercentScrolled();
        } else if (sloty < this.contenty) {
            int diff = this.contenty - sloty;
            this.percentscrolled = (float)((double)this.percentscrolled - (double)diff / (double)(this.totalContentHeight() - this.contentheight));
            this.calculatePercentScrolled();
        }
    }

    public void processMouse(int mousex, int mousey) {
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public void actionPerformed(awg guibutton) {
        if (!guibutton.g) {
            return;
        }
        if (this.scrollupbutton != null && guibutton.f == this.scrollupbutton.f) {
            this.scrollUp();
        } else if (this.scrolldownbutton != null && guibutton.f == this.scrolldownbutton.f) {
            this.scrollDown();
        }
    }

    @Override
    public void mouseClicked(int mousex, int mousey, int button) {
        boolean needsfocus;
        boolean bl = needsfocus = mousex >= this.x && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height;
        if (needsfocus != this.focused) {
            this.setFocused(needsfocus);
        }
        int barempty = this.height - this.getScrollBarHeight();
        int sbarx = this.x + this.width - this.getScrollBarWidth();
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        if (button == 0 && this.getScrollBarHeight() < this.height && mousex >= sbarx && mousex <= this.x + this.width && mousey >= this.y && mousey <= this.y + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.y - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
        } else if (mousex >= this.contentx && mousex < sbarx && mousey >= this.contenty && mousey <= this.contenty + this.contentheight) {
            int slot = this.getClickedSlot(mousey);
            this.slotClicked(slot, button, mousex - this.contentx, mousey - this.getSlotY(slot), slot == this.lastslotclicked && button == this.lastbuttonclicked && System.currentTimeMillis() - this.lastslotclicktime < 500L);
            this.lastslotclicked = slot;
            this.lastbuttonclicked = button;
            this.lastslotclicktime = System.currentTimeMillis();
        }
    }

    @Override
    public void mouseMovedOrUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
    }

    @Override
    public void keyTyped(char c, int keycode) {
        if (!this.focused) {
            return;
        }
        if (keycode == 200) {
            this.selectPrev();
        }
        if (keycode == 208) {
            this.selectNext();
        }
        if (keycode == 28 && this.actionCommand != null) {
            this.parentscreen.actionPerformed(this.actionCommand, new Object[0]);
        }
    }

    public void drawSlotBox() {
        GuiScrollSlot.a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
    }

    public void drawBackground() {
    }

    public void drawOverlay() {
        GuiScrollSlot.a((int)this.x, (int)(this.y - 1), (int)(this.x + this.width), (int)this.y, (int)-6250336);
        GuiScrollSlot.a((int)this.x, (int)(this.y + this.height), (int)(this.x + this.width), (int)(this.y + this.height + 1), (int)-6250336);
        GuiScrollSlot.a((int)(this.x - 1), (int)(this.y - 1), (int)this.x, (int)(this.y + this.height + 1), (int)-6250336);
        GuiScrollSlot.a((int)(this.x + this.width), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-6250336);
    }

    public void drawScrollBar() {
        int sbarw = this.getScrollBarWidth();
        int sbarh = this.getScrollBarHeight() - 1;
        int sbarx = this.x + this.width - sbarw;
        int sbary = this.y + (int)((double)((float)(this.height - sbarh) * this.percentscrolled) + 0.4999);
        GuiScrollSlot.a((int)sbarx, (int)sbary, (int)(sbarx + sbarw), (int)(sbary + sbarh), (int)-7631989);
        GuiScrollSlot.a((int)sbarx, (int)sbary, (int)(sbarx + sbarw - 1), (int)(sbary + sbarh - 1), (int)-986896);
        GuiScrollSlot.a((int)(sbarx + 1), (int)(sbary + 1), (int)(sbarx + sbarw), (int)(sbary + sbarh), (int)-11184811);
        GuiScrollSlot.a((int)(sbarx + 1), (int)(sbary + 1), (int)(sbarx + sbarw - 1), (int)(sbary + sbarh - 1), (int)-3750202);
        if (this.drawLineGuide()) {
            GuiScrollSlot.a((int)(sbarx - 1), (int)this.y, (int)sbarx, (int)(this.y + this.height), (int)-8355712);
        }
    }

    public boolean drawLineGuide() {
        return true;
    }

    public void drawSlots(int mousex, int mousey) {
        int slot = 0;
        while (slot < this.getNumSlots()) {
            int sloty = this.getSlotY(slot);
            if (sloty > this.contenty - this.getSlotHeight() && sloty < this.contenty + this.contentheight) {
                this.drawSlot(slot, this.contentx, sloty, mousex - this.contentx, mousey - sloty, this.isSlotSelected(slot));
            }
            ++slot;
        }
    }

    @Override
    public void mouseDragged(int x, int y2, int button, long time) {
        this.processMouse(x, y2);
    }

    @Override
    public void draw(int mousex, int mousey, float partialframe) {
        this.drawBackground();
        this.drawSlotBox();
        this.drawSlots(mousex, mousey);
        this.drawScrollBar();
        this.drawOverlay();
    }
}

