/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.colour;

import codechicken.core.alg.MathHelper;
import codechicken.core.colour.ColourRGBA;
import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class CustomGradient {
    public int[] gradient;

    public CustomGradient(String textureFile) {
        try {
            BufferedImage img = ImageIO.read(Minecraft.x().D.e().a(textureFile));
            int[] data = new int[img.getWidth()];
            img.getRGB(0, 0, img.getWidth(), 1, data, 0, img.getWidth());
            this.gradient = new int[img.getWidth()];
            int i = 0;
            while (i < data.length) {
                this.gradient[i] = data[i] << 8 | data[i] >> 24 & 0xFF;
                ++i;
            }
        }
        catch (IOException var5) {
            FMLCommonHandler.instance().raiseException((Throwable)var5, "Error while reading gradient: " + textureFile, true);
        }
    }

    public ColourRGBA getColour(double position) {
        return new ColourRGBA(this.getColourI(position));
    }

    public int getColourI(double position) {
        int off = (int)MathHelper.clip((double)this.gradient.length * position, 0.0, this.gradient.length - 1);
        return this.gradient[off];
    }
}

