/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCorePlugin;
import codechicken.core.asm.InterfaceDependancies;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.Iterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class InterfaceDependancyTransformer
implements IClassTransformer {
    public byte[] transform(String name, String tname, byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        boolean hasDependancyInterfaces = false;
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode ann : classNode.visibleAnnotations) {
                if (!ann.desc.equals(Type.getDescriptor(InterfaceDependancies.class))) continue;
                hasDependancyInterfaces = true;
                break;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        hasDependancyInterfaces = false;
        Iterator iterator = classNode.interfaces.iterator();
        while (iterator.hasNext()) {
            try {
                String s = (String)iterator.next();
                s = FMLDeobfuscatingRemapper.INSTANCE.map(s);
                CodeChickenCorePlugin.cl.findClass(s.replace('/', '.'));
            }
            catch (ClassNotFoundException cnfe) {
                iterator.remove();
                hasDependancyInterfaces = true;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(0);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

