/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.alg.MathHelper;
import codechicken.core.render.RenderUtils;
import codechicken.nei.ClientHandler;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class WorldOverlayRenderer {
    @ForgeSubscribe
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        GL11.glPushMatrix();
        ng entity = event.context.q.h;
        RenderUtils.translateToWorldCoords((mp)entity, (float)event.partialTicks);
        this.renderChunkBounds((mp)entity);
        this.renderMobSpawnOverlay((mp)entity);
        GL11.glPopMatrix();
    }

    private void renderMobSpawnOverlay(mp entity) {
        if (ClientHandler.instance().mobSpawnOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        aab world = entity.q;
        int x1 = (int)entity.u;
        int z1 = (int)entity.w;
        int y1 = (int)MathHelper.clip((double)entity.v, (double)16.0, (double)(world.Q() - 16));
        aqx aabb = aqx.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        int x = x1 - 16;
        while (x <= x1 + 16) {
            int z = z1 - 16;
            while (z <= z1 + 16) {
                abw chunk = world.d(x, z);
                int y = y1 - 16;
                while (y < y1 + 16) {
                    if (aan.a((nn)nn.a, (aab)entity.q, (int)x, (int)y, (int)z) && chunk.a(aam.b, x & 0xF, y, z & 0xF) < 8) {
                        aabb.a = (double)x + 0.2;
                        aabb.d = (double)x + 0.8;
                        aabb.b = (double)y + 0.01;
                        aabb.e = (double)y + 1.8;
                        aabb.c = (double)z + 0.2;
                        aabb.f = (double)z + 0.8;
                        if (world.b(aabb) && world.a(aabb).isEmpty() && !world.d(aabb)) {
                            GL11.glVertex3d((double)x, (double)((double)y + 0.001), (double)z);
                            GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.001), (double)(z + 1));
                            GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.001), (double)z);
                            GL11.glVertex3d((double)x, (double)((double)y + 0.001), (double)(z + 1));
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void renderChunkBounds(mp entity) {
        if (ClientHandler.instance().chunkOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        int cx = -4;
        while (cx <= 4) {
            int cz = -4;
            while (cz <= 4) {
                double x1 = entity.aj + cx << 4;
                double z1 = entity.al + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.v - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.q.Q()) {
                    y2 = entity.q.Q();
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)dist);
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (ClientHandler.instance().chunkOverlay == 2 && cx == 0 && cz == 0) {
                    dy = 32.0;
                    y1 = Math.floor(entity.v - dy / 2.0);
                    y2 = y1 + dy;
                    if (y1 < 0.0) {
                        y1 = 0.0;
                        y2 = dy;
                    }
                    if (y1 > (double)entity.q.Q()) {
                        y2 = entity.q.Q();
                        y1 = y2 - dy;
                    }
                    GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)0.4);
                    double y = (int)y1;
                    while (y <= y2) {
                        GL11.glVertex3d((double)x2, (double)y, (double)z1);
                        GL11.glVertex3d((double)x2, (double)y, (double)z2);
                        GL11.glVertex3d((double)x1, (double)y, (double)z1);
                        GL11.glVertex3d((double)x1, (double)y, (double)z2);
                        GL11.glVertex3d((double)x1, (double)y, (double)z2);
                        GL11.glVertex3d((double)x2, (double)y, (double)z2);
                        GL11.glVertex3d((double)x1, (double)y, (double)z1);
                        GL11.glVertex3d((double)x2, (double)y, (double)z1);
                        y += 1.0;
                    }
                    double h = 1.0;
                    while (h <= 15.0) {
                        GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z1);
                        GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z1);
                        GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z2);
                        GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z2);
                        GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h));
                        GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h));
                        GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h));
                        GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h));
                        h += 1.0;
                    }
                }
                ++cz;
            }
            ++cx;
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

