/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.ItemKey;
import codechicken.core.inventory.SlotDummy;
import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.BlockCoord;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.ContainerPotionCreator;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.InterActionMap;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class NEISPH
implements PacketCustom.ICustomPacketHandler.IServerPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, jh nethandler, jc sender) {
        if (!NEIServerConfig.authenticatePacket(sender, packet)) {
            return;
        }
        switch (packet.getType()) {
            case 1: {
                this.handleGiveItem(sender, packet);
                break;
            }
            case 4: {
                NEIServerUtils.deleteAllItems(sender);
                break;
            }
            case 5: {
                this.setInventorySlot(sender, packet);
                break;
            }
            case 6: {
                NEIServerUtils.toggleMagnetMode(sender);
                break;
            }
            case 7: {
                NEIServerUtils.setHourForward(sender.q, packet.readUnsignedByte(), true);
                break;
            }
            case 8: {
                NEIServerUtils.healPlayer((sq)sender);
                break;
            }
            case 9: {
                NEIServerUtils.toggleRaining(sender.q, true);
                break;
            }
            case 10: {
                this.sendPermissableActionsTo(sender);
                this.sendBannedBlocksTo(sender);
                this.sendDisabledPropertiesTo(sender, sender.ar);
                NEISPH.sendMagnetModeTo(sender, NEIServerUtils.isMagnetMode(sender));
                NEISPH.sendCreativeModeTo(sender, NEIServerUtils.getCreativeMode(sender));
                break;
            }
            case 11: {
                sender.a(sender.bM, sender.bM.a());
                break;
            }
            case 12: {
                this.handlePropertyChange(sender, packet);
                break;
            }
            case 13: {
                NEIServerUtils.toggleCreativeMode(sender);
                break;
            }
            case 14: {
                NEIServerUtils.cycleCreativeInv(sender, packet.readInt());
                break;
            }
            case 15: {
                this.handleMobSpawnerID(sender.q, packet.readCoord(), packet.readString());
                break;
            }
            case 20: {
                this.handleContainerPacket(sender, packet);
                break;
            }
            case 21: {
                this.openEnchantmentGui(sender);
                break;
            }
            case 22: {
                this.modifyEnchantment(sender, packet.readUnsignedByte(), packet.readUnsignedByte(), packet.readBoolean());
                break;
            }
            case 23: {
                this.processCreativeInv(sender, packet.readBoolean());
                break;
            }
            case 24: {
                this.openPotionGui(sender, packet);
                break;
            }
            case 25: {
                this.handleDummySlotSet(sender, packet);
            }
        }
    }

    private void handleDummySlotSet(jc sender, PacketCustom packet) {
        short slotNumber = packet.readShort();
        wm stack = packet.readItemStack(true);
        ul slot = sender.bM.a((int)slotNumber);
        if (slot instanceof SlotDummy) {
            slot.c(stack);
        }
    }

    private void handleContainerPacket(jc sender, PacketCustom packet) {
        if (sender.bM instanceof ContainerExtended) {
            ((ContainerExtended)sender.bM).handleInputPacket(packet);
        }
    }

    private void handleMobSpawnerID(aab world, BlockCoord coord, String mobtype) {
        aqp tile = world.r(coord.x, coord.y, coord.z);
        if (tile instanceof aqj) {
            ((aqj)tile).a().a(mobtype);
            tile.k_();
            world.j(coord.x, coord.y, coord.z);
        }
    }

    private void handlePropertyChange(jc sender, PacketCustom packet) {
        int id = packet.readUnsignedByte();
        if (NEIServerConfig.canPlayerUseFeature(sender.bS, (String)AllowedPropertyMap.idToFeatureClassMap.get(id))) {
            this.handlePropertyChange(sender.ar, id, packet.readBoolean());
        }
    }

    private void processCreativeInv(jc sender, boolean open) {
        if (open) {
            ServerUtils.openSMPContainer((jc)sender, (tj)new ContainerCreativeInv((sq)sender, new ExtendedCreativeInv(NEIServerConfig.forPlayer(sender.bS), Side.SERVER)), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(jc player, int windowId) {
                    PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 23);
                    packet.writeBoolean(true);
                    packet.writeByte(windowId);
                    packet.sendToPlayer((sq)player);
                }
            });
        } else {
            sender.j();
            PacketCustom packet = new PacketCustom((Object)channel, 23);
            packet.writeBoolean(false);
            packet.sendToPlayer((sq)sender);
        }
    }

    private void handlePropertyChange(int dim, int propID, boolean disable) {
        NEIServerConfig.setPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(propID), disable);
        this.sendDisabledPropertiesTo(null, dim);
    }

    private void sendDisabledPropertiesTo(jc player, int dim) {
        ArrayList<Integer> disabledProperties = new ArrayList<Integer>();
        for (Map.Entry prop : AllowedPropertyMap.nameToIDMap.entrySet()) {
            if (!NEIServerConfig.isPropertyDisabled(dim, (String)prop.getKey())) continue;
            disabledProperties.add((Integer)prop.getValue());
        }
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeByte(disabledProperties.size());
        Iterator iterator = disabledProperties.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            packet.writeByte(i);
        }
        if (player != null) {
            packet.sendToPlayer((sq)player);
        } else {
            for (sq sendplayer : ServerUtils.getPlayersInDimension((int)dim)) {
                packet.sendToPlayer(sendplayer);
            }
        }
    }

    private void handleGiveItem(jc player, PacketCustom packet) {
        boolean infinite = packet.readBoolean();
        boolean doSpawn = packet.readBoolean();
        int num = packet.readUnsignedByte();
        LinkedList<String> name = new LinkedList<String>();
        int i = 0;
        while (i < num) {
            name.add(packet.readString());
            ++i;
        }
        wm item = packet.readItemStack();
        if (item == null) {
            ServerUtils.sendChatTo((jc)player, (String)"\u00a7fNo such item.");
            return;
        }
        item.a = packet.readInt();
        NEIServerUtils.givePlayerItem(player, item, infinite, name, doSpawn);
    }

    private void setInventorySlot(jc player, PacketCustom packet) {
        boolean container = packet.readBoolean();
        short slot = packet.readShort();
        wm item = packet.readItemStack();
        if (!NEIServerConfig.canPlayerUseFeature(player.bS, item == null ? "delete" : "item")) {
            return;
        }
        NEIServerUtils.setSlotContents((sq)player, slot, item, container);
    }

    private void modifyEnchantment(jc player, int e, int lvl, boolean add) {
        ContainerEnchantmentModifier containerem = (ContainerEnchantmentModifier)player.bM;
        if (add) {
            containerem.addEnchantment(e, lvl);
        } else {
            containerem.removeEnchantment(e);
        }
    }

    private void openEnchantmentGui(jc player) {
        ServerUtils.openSMPContainer((jc)player, (tj)new ContainerEnchantmentModifier(player.bK, player.q, 0, 0, 0), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jc player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 21);
                packet.writeByte(windowId);
                packet.sendToPlayer((sq)player);
            }
        });
    }

    private void openPotionGui(jc player, PacketCustom packet) {
        lz b = new lz("potionStore", true, 9);
        int i = 0;
        while (i < b.j_()) {
            b.a(i, packet.readItemStack());
            ++i;
        }
        ServerUtils.openSMPContainer((jc)player, (tj)new ContainerPotionCreator(player.bK, (lt)b), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jc player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 24);
                packet.writeByte(windowId);
                packet.sendToPlayer((sq)player);
            }
        });
    }

    public static void sendMagnetModeTo(jc player, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        packet.writeBoolean(enable);
        packet.sendToPlayer((sq)player);
    }

    public static void sendCreativeModeTo(jc player, int mode) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(mode);
        packet.sendToPlayer((sq)player);
    }

    private void sendPermissableActionsTo(jc player) {
        LinkedList<Integer> actions = new LinkedList<Integer>();
        InterActionMap[] interActionMapArray = InterActionMap.values();
        int n = interActionMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            InterActionMap action = interActionMapArray[n2];
            if (NEIServerConfig.canPlayerUseFeature(player.bS, action.getName())) {
                actions.add(action.ordinal());
            }
            ++n2;
        }
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.writeByte(actions.size());
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            packet.writeByte(i);
        }
        packet.sendToPlayer((sq)player);
    }

    private void sendBannedBlocksTo(jc player) {
        ArrayList<ItemKey> bannedblocks = new ArrayList<ItemKey>();
        for (Map.Entry entry : NEIServerConfig.bannedblocks.entrySet()) {
            if (NEIServerConfig.isPlayerInList(player.bS, (HashSet)entry.getValue(), true)) continue;
            bannedblocks.add((ItemKey)entry.getKey());
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        packet.writeInt(bannedblocks.size());
        for (ItemKey hash : bannedblocks) {
            packet.writeShort(hash.item.c);
            packet.writeShort(hash.item.k());
        }
        packet.sendToPlayer((sq)player);
    }

    public static void sendHasServerSideTo(jc player) {
        System.out.println("Sending serverside check to: " + player.bS);
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeByte(5);
        packet.writeString(CommonUtils.getWorldName((aab)player.q));
        packet.sendToPlayer((sq)player);
    }

    public static void sendAddMagneticItemTo(jc player, rh item) {
        PacketCustom packet = new PacketCustom((Object)channel, 13);
        packet.writeInt(item.k);
        packet.sendToPlayer((sq)player);
    }
}

