/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ItemVisibilityHash {
    private static boolean[] statesSaved = new boolean[7];
    public TreeMap hiddenitems;

    public ItemVisibilityHash() {
        try {
            this.loadFromCompound(this.getCurrentSaveCompound());
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    public bs getCurrentSaveCompound() {
        bs hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (cf)hashSave);
        bs currentSave = hashSave.l("current");
        hashSave.a("current", currentSave);
        return currentSave;
    }

    public void hideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add(-1);
    }

    public void hideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add(damage);
    }

    public void hideItem(int item, bs stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        if (!info.compounds.contains(stackTagCompound)) {
            info.compounds.add(stackTagCompound);
        }
    }

    public void hideItem(ItemKey item) {
        if (item.item.p()) {
            this.hideItem(item.item.c, item.item.q());
        } else {
            this.hideItem(item.item.c, item.item.k());
        }
    }

    public void unhideItem(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        this.hiddenitems.remove(item);
    }

    public void unhideItem(int item, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        if (damage == -1) {
            this.hiddenitems.remove(item);
            return;
        }
        info.damages.remove(damage);
    }

    public void unhideItem(int item, bs stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        info.compounds.remove(stackTagCompound);
    }

    public void unhideItem(ItemKey item) {
        if (item.item.p()) {
            this.unhideItem(item.item.c, item.item.q());
        } else {
            this.unhideItem(item.item.c, item.item.k());
        }
    }

    public boolean isItemHidden(int itemID, int damage) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.damages.contains(damage) || info.damages.contains(-1);
    }

    public boolean isItemHidden(int item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item);
        if (info == null) {
            return false;
        }
        return info.damages.contains((short)-1);
    }

    public boolean isItemHidden(int itemID, bs stackTagCompound) {
        IDInfo info = (IDInfo)this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.compounds.contains(stackTagCompound);
    }

    public boolean isItemHidden(ItemKey item) {
        IDInfo info = (IDInfo)this.hiddenitems.get(item.item.c);
        if (info == null) {
            return false;
        }
        if (info.damages.contains(item.item.k()) || info.damages.contains(-1)) {
            return true;
        }
        if (item.item.p()) {
            return info.compounds.contains(item.item.q());
        }
        return false;
    }

    private void loadFromCompound(bs readTag) {
        this.hiddenitems = new TreeMap();
        for (Object obj : readTag.c()) {
            int i;
            IDInfo info;
            int itemID;
            if (obj instanceof ca) {
                ca compoundlist = (ca)obj;
                itemID = Integer.parseInt(compoundlist.e().substring(1));
                info = (IDInfo)this.hiddenitems.get(itemID);
                if (info == null) {
                    info = new IDInfo();
                    this.hiddenitems.put(itemID, info);
                }
                i = 0;
                while (i < compoundlist.c()) {
                    info.compounds.add((bs)compoundlist.b(i));
                    ++i;
                }
                continue;
            }
            if (!(obj instanceof bq)) continue;
            bq damagearray = (bq)obj;
            itemID = Integer.parseInt(damagearray.e().substring(1));
            info = (IDInfo)this.hiddenitems.get(itemID);
            if (info == null) {
                info = new IDInfo();
                this.hiddenitems.put(itemID, info);
            }
            i = 0;
            while (i < damagearray.a.length / 2) {
                info.damages.add((damagearray.a[i * 2] << 8) + damagearray.a[i * 2 + 1]);
                ++i;
            }
        }
    }

    public void save() {
        try {
            bs hashSave = NEIClientConfig.saveCompound.l("vis");
            NEIClientConfig.saveCompound.a("vis", (cf)hashSave);
            hashSave.a("current", this.constructSaveCompound());
            NEIClientConfig.saveConfig();
        }
        catch (Exception e) {
            NEIClientUtils.reportException(e);
        }
    }

    private bs constructSaveCompound() {
        bs savecompound = new bs();
        for (Map.Entry itemEntry : this.hiddenitems.entrySet()) {
            int id = (Integer)itemEntry.getKey();
            IDInfo info = (IDInfo)itemEntry.getValue();
            if (info.compounds.size() > 0) {
                ca compoundlist = new ca();
                for (bs compound : info.compounds) {
                    compoundlist.a((cf)compound);
                }
                savecompound.a("c" + id, (cf)compoundlist);
            }
            if (info.damages.size() <= 0) continue;
            byte[] damagearray = new byte[info.damages.size() * 2];
            int i = 0;
            Iterator iterator = info.damages.iterator();
            while (iterator.hasNext()) {
                int damage = (Integer)iterator.next();
                damagearray[i * 2] = (byte)(damage >> 8);
                damagearray[i * 2 + 1] = (byte)damage;
                ++i;
            }
            savecompound.a("d" + id, damagearray);
        }
        return savecompound;
    }

    public static void loadStates() {
        bs hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (cf)hashSave);
        int i = 0;
        while (i < 7) {
            bs statesave = hashSave.l("save" + i);
            if (statesave.c().size() > 0) {
                ItemVisibilityHash.statesSaved[i] = true;
            }
            ++i;
        }
    }

    public void loadState(int i) {
        bs hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (cf)hashSave);
        this.loadFromCompound(hashSave.l("save" + i));
        DropDownFile.dropDownInstance.updateState();
        ItemList.updateSearch();
        NEIClientConfig.vishash.save();
    }

    public void saveState(int i) {
        bs hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (cf)hashSave);
        bs saveCompound = this.getCurrentSaveCompound();
        saveCompound.a("saved", true);
        hashSave.a("save" + i, saveCompound);
        ItemVisibilityHash.statesSaved[i] = true;
        NEIClientConfig.saveConfig();
    }

    public void clearState(int i) {
        bs hashSave = NEIClientConfig.saveCompound.l("vis");
        NEIClientConfig.saveCompound.a("vis", (cf)hashSave);
        hashSave.a("save" + i, new bs("save" + i));
        ItemVisibilityHash.statesSaved[i] = false;
        NEIClientConfig.saveConfig();
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static class IDInfo {
        public TreeSet damages = new TreeSet();
        public ArrayList compounds = new ArrayList();
    }
}

