/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SubSetRangeTag;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.forge.GuiContainerManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ItemList {
    public static ArrayList items = new ArrayList();
    private static boolean matching = false;
    private static boolean loading = false;
    private static boolean research = false;
    private static boolean reload = false;

    public static ItemMatcher getSearchMatcher() {
        String matchstring = NEIClientConfig.getSearchExpression();
        SubSetRangeTag tagMatch = null;
        Pattern patternMatch = null;
        if (matchstring.startsWith("@") && matchstring.length() > 1) {
            tagMatch = DropDownFile.dropDownInstance.getTag(matchstring.substring(1), false);
        } else {
            matchstring = matchstring.replace(".", "");
            matchstring = matchstring.replace("?", ".");
            matchstring = matchstring.replace("*", ".+?");
            matchstring = matchstring.toLowerCase();
            try {
                patternMatch = Pattern.compile(matchstring);
            }
            catch (PatternSyntaxException e) {
                patternMatch = Pattern.compile("");
            }
        }
        return new ItemMatcher(patternMatch, tagMatch);
    }

    public static boolean itemMatchesSearch(wm item) {
        return ItemList.getSearchMatcher().matches(item);
    }

    public static boolean isMatching() {
        return matching;
    }

    public static void updateSearch() {
        if (matching) {
            research = true;
        } else {
            new ThreadMatchSearch().start();
        }
    }

    public static void loadItems() {
        if (loading) {
            reload = true;
        } else {
            new ThreadLoadItems().start();
        }
    }

    public static class ItemMatcher {
        Pattern patternMatch;
        SubSetRangeTag tagMatch;

        public ItemMatcher(Pattern pattern, SubSetRangeTag tag) {
            this.patternMatch = pattern;
            this.tagMatch = tag;
        }

        public boolean matches(wm item) {
            if (this.tagMatch != null) {
                return this.tagMatch.isItemInRange(item.c, 0);
            }
            return this.patternMatch == null || this.patternMatch.toString().equals("") || this.patternMatch.matcher(GuiContainerManager.concatenatedDisplayName(item, true).toLowerCase()).find();
        }
    }

    public static class ThreadLoadItems
    extends Thread {
        public ThreadLoadItems() {
            super("NEI Item Loading Thread");
        }

        @Override
        public void run() {
            loading = true;
            block2: while (loading) {
                ArrayList<wm> items = new ArrayList<wm>();
                ArrayList sublist = new ArrayList();
                DropDownFile.dropDownInstance.resetHashes();
                int itemID = 0;
                while (itemID < wk.f.length) {
                    if (reload) {
                        reload = false;
                        continue block2;
                    }
                    wk item = wk.f[itemID];
                    if (item != null && !ItemInfo.isHidden(item.cp)) {
                        sublist.clear();
                        item.a(itemID, null, sublist);
                        ArrayList damageranges = ItemInfo.getItemDamageVariants(item.cp);
                        if (sublist.size() > 0) {
                            ArrayList<Integer> discreteDamages = new ArrayList<Integer>();
                            for (wm stack : sublist) {
                                if (stack.p()) {
                                    stack = stack.m();
                                    items.add(stack);
                                    DropDownFile.dropDownInstance.addItemIfInRange(itemID, stack.k(), stack.d);
                                    continue;
                                }
                                discreteDamages.add(stack.k());
                            }
                            damageranges = damageranges == ItemInfo.defaultDamageRange ? NEIClientUtils.concatIntegersToRanges(discreteDamages) : NEIClientUtils.addIntegersToRanges(damageranges, discreteDamages);
                        }
                        boolean skipDamage0 = false;
                        ArrayList datalist = ItemInfo.getItemCompounds(itemID);
                        if (datalist != null && datalist.size() > 0 && NEIClientConfig.isActionPermissable("nbt")) {
                            skipDamage0 = true;
                            for (wm stack : datalist) {
                                stack = stack.m();
                                items.add(stack);
                                DropDownFile.dropDownInstance.addItemIfInRange(itemID, stack.k(), stack.d);
                            }
                        }
                        HashSet<String> damageIconSet = new HashSet<String>();
                        for (int[] damagerange : damageranges) {
                            int damage = damagerange[0];
                            while (damage <= damagerange[1]) {
                                wm itemstack = new wm(item, 1, damage);
                                try {
                                    lx icon = item.h(itemstack);
                                    String name = GuiContainerManager.concatenatedDisplayName(itemstack, false);
                                    String s = String.valueOf(name) + "@" + (icon == null ? 0 : icon.hashCode());
                                    if (!damageIconSet.contains(s)) {
                                        damageIconSet.add(s);
                                        if (damage != 0 || !skipDamage0) {
                                            items.add(itemstack);
                                            DropDownFile.dropDownInstance.addItemIfInRange(itemID, itemstack.k(), null);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    System.err.println("NEI: Omitting #" + itemID + ":" + damage + " " + item.getClass().getSimpleName() + " from list due to " + e.getClass().getSimpleName());
                                }
                                ++damage;
                            }
                        }
                    }
                    ++itemID;
                }
                loading = false;
                ItemList.items = items;
            }
            DropDownFile.dropDownInstance.updateState();
            ItemList.updateSearch();
        }
    }

    public static class ThreadMatchSearch
    extends Thread {
        public ThreadMatchSearch() {
            super("NEI Item Searching Thread");
        }

        @Override
        public void run() {
            matching = true;
            block0: while (matching) {
                ArrayList<ItemPanelStack> visibleitems = new ArrayList<ItemPanelStack>();
                ItemMatcher matcher = ItemList.getSearchMatcher();
                for (wm item : items) {
                    if (research) {
                        research = false;
                        continue block0;
                    }
                    if (!item.p() ? NEIClientConfig.vishash.isItemHidden(item.c, item.k()) : NEIClientConfig.vishash.isItemHidden(item.c, item.d)) continue;
                    if (!NEIClientConfig.canGetItem(new ItemKey(item)) || !matcher.matches(item)) continue;
                    visibleitems.add(new ItemPanelStack(item));
                }
                ItemPanel.visibleitems = visibleitems;
                matching = false;
            }
        }
    }
}

