/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.client.ClientPacketHandler;
import atomicstryker.multimine.common.CommonProxy;
import atomicstryker.multimine.common.ConnectionHandler;
import atomicstryker.multimine.common.MultiMineServer;
import atomicstryker.multimine.common.ServerPacketHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.util.HashSet;
import net.minecraftforge.common.Configuration;

@Mod(modid="AS_MultiMine", name="Multi Mine", version="1.2.8")
@NetworkMod(clientSideRequired=false, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"AS_MM"}, packetHandler=ClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"AS_MM"}, packetHandler=ServerPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class MultiMine {
    private static MultiMine instance;
    private boolean blockRegenEnabled;
    private long initialBlockRegenDelay;
    private long blockRegenInterval;
    private String excludedBlocksString;
    private HashSet excludedBlockSet;
    private String excludedItemsString;
    private HashSet excludedItemSet;
    @SidedProxy(clientSide="atomicstryker.multimine.client.ClientProxy", serverSide="atomicstryker.multimine.common.CommonProxy")
    public static CommonProxy proxy;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        instance = this;
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        this.blockRegenEnabled = config.get("general", "Block Regeneration Enabled", true).getBoolean(true);
        this.initialBlockRegenDelay = config.get("general", "Initial Block Regen Delay in ms", 5000).getInt();
        this.blockRegenInterval = config.get("general", "Block 10 percent Regen Interval in ms", 1000).getInt();
        this.excludedBlocksString = config.get("general", "Excluded Block IDs", "6,31,37,38,39,40,50,51,55,59,64,69,75,76,83,93,94,96,104,105,111,131,132,141,142").getString();
        this.excludedItemsString = config.get("general", "Excluded Item IDs", "290,291,292,293,294,359").getString();
        config.save();
        this.excludedBlockSet = new HashSet();
        this.excludedItemSet = new HashSet();
        this.setExcludedBlocksString(this.excludedBlocksString);
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        proxy.onLoad();
    }

    @Mod.ServerStarted
    public void serverStarted(FMLServerStartedEvent event) {
        new MultiMineServer();
    }

    public static MultiMine instance() {
        return instance;
    }

    public boolean getBlockRegenEnabled() {
        return this.blockRegenEnabled;
    }

    public long getInitialBlockRegenDelay() {
        return this.initialBlockRegenDelay;
    }

    public long getBlockRegenInterval() {
        return this.blockRegenInterval;
    }

    public String getExcludedBlocksString() {
        return this.excludedBlocksString;
    }

    public String getExcludedItemssString() {
        return this.excludedItemsString;
    }

    public void setExcludedBlocksString(String input) {
        String[] numbers;
        this.excludedBlocksString = input.trim();
        for (String s : numbers = this.excludedBlocksString.split(",")) {
            this.excludedBlockSet.add(Integer.parseInt(s));
        }
    }

    public boolean getIsExcludedBlock(int blockID) {
        return this.excludedBlockSet.contains(blockID);
    }

    public void setExcludedItemssString(String input) {
        String[] numbers;
        this.excludedItemsString = input.trim();
        for (String s : numbers = this.excludedItemsString.split(",")) {
            this.excludedItemSet.add(Integer.parseInt(s));
        }
    }

    public boolean getIsExcludedItem(wm itemStack) {
        return itemStack != null && this.excludedItemSet.contains(itemStack.c);
    }
}

