/*
 * Decompiled with CFR 0.152.
 */
package dark.library.terminal.commands;

import dark.library.access.interfaces.ISpecialAccess;
import dark.library.access.interfaces.ITerminal;
import dark.library.terminal.commands.CommandRegistry;
import dark.library.terminal.commands.TerminalCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class CommandHelp
extends TerminalCommand {
    @Override
    public String getCommandPrefix() {
        return "help";
    }

    @Override
    public boolean processCommand(EntityPlayer player, ITerminal TE, String[] args) {
        if (args.length > 1) {
            ArrayList<String> displayed = new ArrayList<String>();
            for (TerminalCommand cc : CommandRegistry.COMMANDS) {
                if (!cc.getCommandPrefix().equalsIgnoreCase(args[1]) || !cc.showOnHelp(player, TE) || !cc.canMachineUse(TE)) continue;
                TE.addToConsole("----------------------");
                TE.addToConsole(args[1] + " commands");
                TE.addToConsole("----------------------");
                List ccList = cc.getCmdUses(player, TE);
                for (String cm : ccList) {
                    if (displayed.contains(cm.toLowerCase())) continue;
                    TE.addToConsole(cm);
                    displayed.add(cm.toLowerCase());
                }
                TE.addToConsole("----------------------");
            }
            return true;
        }
        TE.addToConsole("----------------------");
        TE.addToConsole("Listing commands");
        TE.addToConsole("----------------------");
        TE.addToConsole("Help command");
        for (TerminalCommand cc : CommandRegistry.COMMANDS) {
            if (!cc.showOnHelp(player, TE) || !cc.canMachineUse(TE)) continue;
            List ccList = cc.getCmdUses(player, TE);
            for (String cm : ccList) {
                TE.addToConsole(cm);
            }
        }
        TE.addToConsole("-----------------------");
        return true;
    }

    @Override
    public boolean canPlayerUse(EntityPlayer var1, ISpecialAccess mm) {
        return true;
    }

    @Override
    public boolean showOnHelp(EntityPlayer player, ISpecialAccess mm) {
        return false;
    }

    @Override
    public List getCmdUses(EntityPlayer player, ISpecialAccess mm) {
        return null;
    }

    @Override
    public boolean canMachineUse(ISpecialAccess mm) {
        return true;
    }
}

