/*
 * Decompiled with CFR 0.152.
 */
package dark.library.terminal;

import calclavia.lib.TileEntityUniversalRunnable;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.PacketDispatcher;
import dark.library.access.AccessLevel;
import dark.library.access.UserAccess;
import dark.library.access.interfaces.ISpecialAccess;
import dark.library.access.interfaces.ITerminal;
import dark.library.terminal.commands.CommandRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public abstract class TileEntityTerminal
extends TileEntityUniversalRunnable
implements ISpecialAccess,
IPacketReceiver,
ITerminal {
    private final List terminalOutput = new ArrayList();
    private final List users = new ArrayList();
    public int playersUsing = 0;
    public static final int SCROLL_SIZE = 15;
    private int scroll = 0;

    @Override
    public void initiate() {
        super.initiate();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.playersUsing > 0 && this.ticks % 5L == 0L) {
            PacketManager.sendPacketToClients(this.func_70319_e(), this.field_70331_k, new Vector3(this), 12.0);
        }
    }

    public abstract String getChannel();

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return PacketManager.getPacket(this.getChannel(), this, new Object[]{PacketType.DESCRIPTION_DATA.ordinal(), nbt});
    }

    public void sendTerminalOutputToClients() {
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(PacketType.TERMINAL_OUTPUT.ordinal());
        data.add(this.getTerminalOuput().size());
        data.addAll(this.getTerminalOuput());
        Packet packet = PacketManager.getPacket(this.getChannel(), this, data.toArray());
        PacketManager.sendPacketToClients(packet, this.field_70331_k, new Vector3(this), 10.0);
    }

    public void sendCommandToServer(EntityPlayer entityPlayer, String cmdInput) {
        if (this.field_70331_k.field_72995_K) {
            Packet packet = PacketManager.getPacket(this.getChannel(), this, new Object[]{PacketType.GUI_COMMAND.ordinal(), entityPlayer.field_71092_bJ, cmdInput});
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetID, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            PacketType packetType = PacketType.values()[dataStream.readInt()];
            switch (packetType) {
                case DESCRIPTION_DATA: {
                    if (!this.field_70331_k.field_72995_K) break;
                    short size = dataStream.readShort();
                    if (size > 0) {
                        byte[] byteCode = new byte[size];
                        dataStream.readFully(byteCode);
                        this.func_70307_a(CompressedStreamTools.func_74792_a((byte[])byteCode));
                    }
                    break;
                }
                case GUI_COMMAND: {
                    if (this.field_70331_k.field_72995_K) break;
                    CommandRegistry.onCommand(this.field_70331_k.func_72924_a(dataStream.readUTF()), this, dataStream.readUTF());
                    this.sendTerminalOutputToClients();
                    break;
                }
                case GUI_EVENT: {
                    if (this.field_70331_k.field_72995_K) break;
                    if (dataStream.readBoolean()) {
                        ++this.playersUsing;
                        this.sendTerminalOutputToClients();
                        break;
                    }
                    --this.playersUsing;
                    break;
                }
                case TERMINAL_OUTPUT: {
                    if (!this.field_70331_k.field_72995_K) break;
                    int size = dataStream.readInt();
                    ArrayList oldTerminalOutput = new ArrayList(this.terminalOutput);
                    this.terminalOutput.clear();
                    for (int i = 0; i < size; ++i) {
                        this.terminalOutput.add(dataStream.readUTF());
                    }
                    if (!this.terminalOutput.equals(oldTerminalOutput) && this.terminalOutput.size() != oldTerminalOutput.size()) {
                        this.setScroll(this.getTerminalOuput().size() - 15);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"ICBM: Failed to receive packet for terminal.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public AccessLevel getUserAccess(String username) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (!((UserAccess)this.users.get((int)i)).username.equalsIgnoreCase(username)) continue;
            return ((UserAccess)this.users.get((int)i)).level;
        }
        return AccessLevel.NONE;
    }

    public boolean canUserAccess(String username) {
        return this.getUserAccess(username).ordinal() > AccessLevel.BASIC.ordinal();
    }

    @Override
    public List getUsers() {
        return this.users;
    }

    @Override
    public List getUsersWithAcess(AccessLevel level) {
        ArrayList<UserAccess> players = new ArrayList<UserAccess>();
        for (int i = 0; i < this.users.size(); ++i) {
            UserAccess ref = (UserAccess)this.users.get(i);
            if (ref.level != level) continue;
            players.add(ref);
        }
        return players;
    }

    @Override
    public boolean addUserAccess(String player, AccessLevel lvl, boolean save) {
        this.removeUserAccess(player);
        return this.users.add(new UserAccess(player, lvl, save));
    }

    @Override
    public boolean removeUserAccess(String player) {
        ArrayList<UserAccess> removeList = new ArrayList<UserAccess>();
        for (int i = 0; i < this.users.size(); ++i) {
            UserAccess ref = (UserAccess)this.users.get(i);
            if (!ref.username.equalsIgnoreCase(player)) continue;
            removeList.add(ref);
        }
        if (removeList != null && removeList.size() > 0) {
            return this.users.removeAll(removeList);
        }
        return false;
    }

    @Override
    public List getTerminalOuput() {
        return this.terminalOutput;
    }

    @Override
    public boolean addToConsole(String msg) {
        if (!this.field_70331_k.field_72995_K) {
            boolean usedLines = false;
            msg.trim();
            if (msg.length() > 23) {
                msg = msg.substring(0, 22);
            }
            this.getTerminalOuput().add(msg);
            this.sendTerminalOutputToClients();
            return true;
        }
        return false;
    }

    @Override
    public void scroll(int amount) {
        this.setScroll(this.scroll + amount);
    }

    @Override
    public void setScroll(int length) {
        this.scroll = Math.max(Math.min(length, this.getTerminalOuput().size()), 0);
    }

    @Override
    public int getScroll() {
        return this.scroll;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.wattsReceived = nbt.func_74769_h("wattsReceived");
        this.users.clear();
        NBTTagList userList = nbt.func_74761_m("Users");
        for (int i = 0; i < userList.func_74745_c(); ++i) {
            NBTTagCompound var4 = (NBTTagCompound)userList.func_74743_b(i);
            this.users.add(UserAccess.loadFromNBT(var4));
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74780_a("wattsReceived", this.wattsReceived);
        NBTTagList usersTag = new NBTTagList();
        for (int player = 0; player < this.users.size(); ++player) {
            UserAccess access = (UserAccess)this.users.get(player);
            if (access == null || !access.shouldSave) continue;
            NBTTagCompound accessData = new NBTTagCompound();
            access.writeToNBT(accessData);
            usersTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("Users", (NBTBase)usersTag);
    }

    public static enum PacketType {
        GUI_EVENT,
        GUI_COMMAND,
        TERMINAL_OUTPUT,
        DESCRIPTION_DATA;

    }
}

