/*
 * Decompiled with CFR 0.152.
 */
package dark.library.access;

import dark.library.access.AccessLevel;
import dark.library.access.UserAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import universalelectricity.prefab.flag.NBTFileLoader;

public class GlobalAccessManager {
    private static Map globalUserLists = new HashMap();
    private static NBTTagCompound masterSaveNbt = new NBTTagCompound();
    public static boolean loading = false;
    public static boolean hasLoaded = false;
    public static boolean needsSaving = false;

    public List getOrCreateList(String name, String owner) {
        if (name.toCharArray().length < 5 || owner.isEmpty() || name.startsWith("Default#")) {
            return null;
        }
        List list = this.getList(name);
        if (list == null) {
            list = this.createList(name, owner);
        }
        return list;
    }

    public List getUsersLists(String username) {
        ArrayList lists = new ArrayList();
        block0: for (Map.Entry entry : globalUserLists.entrySet()) {
            List list = (List)entry.getValue();
            for (UserAccess access : list) {
                if (!access.username.equalsIgnoreCase(username) || access.level.ordinal() < AccessLevel.ADMIN.ordinal()) continue;
                lists.add(entry.getKey());
                continue block0;
            }
        }
        return lists;
    }

    public List createList(String name, String owner) {
        ArrayList<UserAccess> list = new ArrayList<UserAccess>();
        list.add(new UserAccess(owner, AccessLevel.OWNER, true));
        globalUserLists.put(name, list);
        this.saveList(name, list);
        needsSaving = true;
        return list;
    }

    public List getList(String name) {
        if (globalUserLists.containsKey(name)) {
            return (List)globalUserLists.get(name);
        }
        List list = this.loadList(name);
        if (list != null) {
            globalUserLists.put(name, list);
        }
        return list;
    }

    public boolean addUser(String listName, UserAccess user) {
        if (user == null) {
            return false;
        }
        List userList = this.getList(listName);
        if (userList != null) {
            if (userList.contains(user)) {
                userList = UserAccess.removeUserAccess(user.username, userList);
            }
            if (userList.add(user)) {
                globalUserLists.put(listName, userList);
                this.saveList(listName, userList);
                needsSaving = true;
                return true;
            }
        }
        return false;
    }

    public boolean removeUser(String listName, UserAccess user) {
        if (user == null) {
            return false;
        }
        List userList = this.getList(listName);
        if (userList != null && userList.contains(user)) {
            userList = UserAccess.removeUserAccess(user.username, userList);
            globalUserLists.put(listName, userList);
            this.saveList(listName, userList);
            needsSaving = true;
            return true;
        }
        return false;
    }

    private List loadList(String name) {
        NBTTagCompound masterSave = GlobalAccessManager.getMasterSaveFile();
        if (masterSave != null && masterSave.func_74764_b(name)) {
            NBTTagCompound accessSave = masterSave.func_74775_l(name);
            return UserAccess.readListFromNBT(accessSave, "Users");
        }
        return null;
    }

    private void saveList(String name, List list) {
        NBTTagCompound masterSave = GlobalAccessManager.getMasterSaveFile();
        if (masterSave != null) {
            NBTTagCompound accessSave = masterSave.func_74775_l(name);
            UserAccess.writeListToNBT(accessSave, list);
            this.getMasterSaveFile().func_74766_a(name, accessSave);
        }
    }

    public static NBTTagCompound getMasterSaveFile() {
        if (masterSaveNbt.func_82582_d() && !loading) {
            hasLoaded = true;
            loading = true;
            NBTFileLoader.loadData("Global_Access_List");
            loading = false;
        }
        return masterSaveNbt;
    }
}

