/*
 * Decompiled with CFR 0.152.
 */
package calclavia.lib;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.PowerFramework;
import calclavia.lib.IUniversalEnergyTile;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.implement.IRotatable;
import universalelectricity.prefab.tile.TileEntityElectricityStorage;

public abstract class TileEntityUniversalStorable
extends TileEntityElectricityStorage
implements IUniversalEnergyTile,
IEnergyStorage {
    private IPowerProvider powerProvider;

    public TileEntityUniversalStorable() {
        if (PowerFramework.currentFramework != null && this.powerProvider == null) {
            this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
            this.powerProvider.configure(0, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        }
    }

    @Override
    public void initiate() {
        super.initiate();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
    }

    @Override
    public void func_70313_j() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        super.func_70313_j();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.powerProvider != null) {
            int requiredEnergy = (int)(this.getRequest().getWatts() * UniversalElectricity.TO_BC_RATIO);
            float energyReceived = this.powerProvider.useEnergy(requiredEnergy, requiredEnergy, true);
            this.onReceive(ElectricityPack.getFromWatts(UniversalElectricity.BC3_RATIO * (double)energyReceived, this.getVoltage()));
        }
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        if (this instanceof IRotatable) {
            return direction == ForgeDirection.getOrientation((int)this.func_70322_n()).getOpposite();
        }
        return true;
    }

    public ForgeDirection getDirection(IBlockAccess world, int x, int y, int z) {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    public void setDirection(World world, int x, int y, int z, ForgeDirection facingDirection) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, facingDirection.ordinal(), 2);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        if (this.getConsumingSides() != null) {
            return this.getConsumingSides().contains(direction.toForgeDirection());
        }
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.ticks > 0L;
    }

    @Override
    public int demandsEnergy() {
        return (int)(this.getRequest().getWatts() * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenElectricity = (double)i * UniversalElectricity.IC2_RATIO;
        double rejects = 0.0;
        if (givenElectricity > this.getMaxJoules()) {
            rejects = givenElectricity - this.getRequest().getWatts();
        }
        this.onReceive(new ElectricityPack(givenElectricity / this.getVoltage(), this.getVoltage()));
        return (int)(rejects * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int getStored() {
        return (int)(this.getJoules() * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public void setStored(int energy) {
        this.setJoules((double)energy * UniversalElectricity.IC2_RATIO);
    }

    @Override
    public int addEnergy(int amount) {
        this.setJoules(this.getJoules() + (double)amount * UniversalElectricity.IC2_RATIO);
        return this.getStored();
    }

    @Override
    public int getCapacity() {
        return (int)(this.getMaxJoules() * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getOutput() {
        return this.getMaxSafeInput();
    }

    @Override
    public boolean isTeleporterCompatible(Direction side) {
        return false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.canConnect(from)) {
            return (int)(this.getRequest().getWatts() * UniversalElectricity.TO_BC_RATIO);
        }
        return 0;
    }
}

