/*
 * Decompiled with CFR 0.152.
 */
package monnef.autoshutdown;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import monnef.autoshutdown.CommandAutoShutdown;
import monnef.autoshutdown.CommonProxy;
import monnef.autoshutdown.MinuteTicker;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;

@Mod(modid="autoshutdown", name="Auto-Shutdown", version="0.4.0")
@NetworkMod(clientSideRequired=false, serverSideRequired=true)
public class AutoShutdown {
    public static final int minimumCountedMinutes = 2;
    @Mod.Instance(value="autoshutdown")
    public static AutoShutdown instance;
    @SidedProxy(clientSide="monnef.autoshutdown.ClientProxy", serverSide="monnef.autoshutdown.CommonProxy")
    public static CommonProxy proxy;
    public static final String Name = "Auto-Shutdown";
    private static int shutdownAfterXMinutes;
    public static int minutesServerIsDead;
    public static boolean doSave;
    public static boolean active;
    private static MinecraftServer server;

    public void handleMetadata() {
        ModMetadata meta = FMLCommonHandler.instance().findContainerFor((Object)this).getMetadata();
        meta.autogenerated = false;
        meta.authorList = Arrays.asList("monnef");
        meta.description = "";
    }

    public static int getShutdownAfterXMinutes() {
        return shutdownAfterXMinutes;
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        server = ModLoader.getMinecraftServerInstance();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        shutdownAfterXMinutes = config.get("general", "minutes", 10).getInt();
        if (shutdownAfterXMinutes < 2) {
            AutoShutdown.println("Too small \"minutes\" value in config. Correcting shutdown timer to 2m.");
            shutdownAfterXMinutes = 2;
        }
        doSave = config.get("general", "force save", true).getBoolean(true);
        active = config.get("general", "enabled", true).getBoolean(true);
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        this.handleMetadata();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new MinuteTicker(), (Side)Side.SERVER);
        AutoShutdown.println("Initialized");
        AutoShutdown.println(AutoShutdown.getStatus());
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static void println(String msg) {
        String str = "[Auto-Shutdown] " + msg;
        if (server == null) {
            System.out.println(str);
        } else {
            server.f(str);
        }
    }

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        if (server == null) {
            server = ModLoader.getMinecraftServerInstance();
        }
        aa commandManager = server.E();
        hs serverCommandManager = (hs)commandManager;
        this.addCommands(serverCommandManager);
    }

    private void addCommands(hs manager) {
        manager.a((z)new CommandAutoShutdown());
    }

    public static String getStatus() {
        return "status: " + AutoShutdown.stringFromBool(active) + "; " + minutesServerIsDead + "/" + AutoShutdown.getShutdownAfterXMinutes() + "; save: " + AutoShutdown.stringFromBool(doSave);
    }

    public static String stringFromBool(boolean input) {
        return input ? "ON" : "OFF";
    }

    static {
        shutdownAfterXMinutes = Integer.MAX_VALUE;
        minutesServerIsDead = 0;
        doSave = true;
        active = true;
    }
}

