/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.launcher.version;

import com.google.gson.Gson;
import com.prupe.mcpatcher.JsonUtils;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.version.LatestVersion;
import com.prupe.mcpatcher.launcher.version.Version;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionList {
    public static final URL VERSION_LIST = Util.newURL("https://s3.amazonaws.com/Minecraft.Download/versions/versions.json");
    private static final URL VERSION_LIST2 = Util.newURL(VERSION_LIST.toString().replaceFirst("^https", "http"));
    List<Version> versions = new ArrayList<Version>();
    LatestVersion latest;

    public static File getPath() {
        return MCPatcherUtils.getMinecraftPath("versions", "versions.json");
    }

    public static void fetchRemoteVersionList(int timeoutMS) throws PatcherException {
        File local = VersionList.getPath();
        try {
            Util.fetchURL(VERSION_LIST, local, true, timeoutMS, Util.JSON_SIGNATURE);
        }
        catch (PatcherException e) {
            try {
                Util.fetchURL(VERSION_LIST2, local, true, timeoutMS, Util.JSON_SIGNATURE);
            }
            catch (PatcherException e1) {
                throw e;
            }
        }
    }

    public static VersionList getLocalVersionList() {
        VersionList list = JsonUtils.parseJson(VersionList.getPath(), VersionList.class);
        if (list != null) {
            Collections.sort(list.versions);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionList getBuiltInVersionList() {
        VersionList list = null;
        InputStream inputStream = null;
        try {
            inputStream = VersionList.class.getResourceAsStream("/resources/versions.json");
            list = JsonUtils.parseJson(inputStream, VersionList.class);
            if (list != null) {
                Collections.sort(list.versions);
            }
        }
        finally {
            MCPatcherUtils.close(inputStream);
        }
        return list;
    }

    private VersionList() {
    }

    public String toString() {
        return String.format("VersionList{latest=%s, %d versions}", this.latest, this.versions.size());
    }

    public Version getLatestVersion(boolean release, boolean snapshot, boolean local) {
        String relVersion = this.latest == null ? null : this.latest.release;
        String ssVersion = this.latest == null ? null : this.latest.snapshot;
        ArrayList<Version> tmpList = new ArrayList<Version>();
        tmpList.addAll(this.versions);
        Collections.reverse(tmpList);
        for (Version v : tmpList) {
            if (local && !v.getJsonPath().isFile()) continue;
            if (release && v.getId().equals(relVersion)) {
                return v;
            }
            if (!snapshot || !v.getId().equals(ssVersion)) continue;
            return v;
        }
        return null;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public void dump(PrintStream output) {
        output.println(this.toString());
        for (Version v : this.versions) {
            output.println(v.toString());
        }
        Gson gson = JsonUtils.newGson();
        gson.toJson((Object)this, (Type)((Object)VersionList.class), output);
        output.println();
    }
}

