/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.launcher.version;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prupe.mcpatcher.JsonUtils;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.version.Library;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipFile;

public class Version
implements Comparable<Version> {
    private static final String BASE_URL = "http://s3.amazonaws.com/Minecraft.Download/versions/";
    private static final String TAG_ID = "id";
    private static final String TAG_TIME = "time";
    private static final String TAG_RELEASE_TIME = "releaseTime";
    private static final String TAG_LIBRARIES = "libraries";
    private static final String TAG_NAME = "name";
    private static final String LEGACY = "legacy";
    private static final String LEGACY_VALUE = "${auth_player_name} ${auth_session}";
    private static final String USERNAME_SESSION = "username_session";
    private static final String USERNAME_SESSION_VALUE = "--username ${auth_player_name} --session ${auth_session}";
    private static final String USERNAME_SESSION_VERSION = "username_session_version";
    private static final String USERNAME_SESSION_VERSION_VALUE = "--username ${auth_player_name} --session ${auth_session} --version ${version_name}";
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), DateFormat.getDateTimeInstance(2, 2, Locale.US)};
    String id;
    String type = "release";
    String processArguments = "username_session_version";
    String minecraftArguments = "";
    String mainClass = "net.minecraft.client.main.Main";
    List<Library> libraries = new ArrayList<Library>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getLocalVersion(String id) {
        Version version;
        File local;
        FileInputStream input;
        block7: {
            input = null;
            local = Version.getJarPath(id);
            if (!local.isFile()) {
                return null;
            }
            Version.fetchJson(id, false);
            local = Version.getJsonPath(id);
            if (local.isFile()) break block7;
            Version version2 = null;
            MCPatcherUtils.close(input);
            return version2;
        }
        try {
            input = new FileInputStream(local);
            InputStreamReader reader = new InputStreamReader(input);
            version = JsonUtils.newGson().fromJson((Reader)reader, Version.class);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                Version version3 = null;
                return version3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        MCPatcherUtils.close(input);
        return version;
    }

    public static void fetchJson(String id, boolean forceRemote) throws PatcherException {
        Util.fetchURL(Version.getJsonURL(id), Version.getJsonPath(id), forceRemote, 30000, Util.JSON_SIGNATURE);
    }

    public static File getJsonPath(String id) {
        return MCPatcherUtils.getMinecraftPath("versions", id, id + ".json");
    }

    public static URL getJsonURL(String id) {
        return Util.newURL(BASE_URL + id + "/" + id + ".json");
    }

    public static void fetchJar(String id, boolean forceRemote) throws PatcherException {
        Util.fetchURL(Version.getJarURL(id), Version.getJarPath(id), forceRemote, 30000, Util.JAR_SIGNATURE);
    }

    public static File getJarPath(String id) {
        return MCPatcherUtils.getMinecraftPath("versions", id, id + ".jar");
    }

    public static URL getJarURL(String id) {
        return Util.newURL(BASE_URL + id + "/" + id + ".jar");
    }

    public static boolean deleteLocalFiles(String id) {
        File baseDir = Version.getJsonPath(id).getParentFile();
        File[] list = baseDir.listFiles();
        if (list != null) {
            for (File f : list) {
                File[] list1;
                if (f.isDirectory() && (list1 = baseDir.listFiles()) != null) {
                    for (File f1 : list1) {
                        f1.delete();
                    }
                }
                f.delete();
            }
        }
        baseDir.delete();
        return !baseDir.exists();
    }

    private Version() {
    }

    public String toString() {
        return String.format("Version{%s, %s}", this.type, this.id);
    }

    public String getId() {
        return this.id;
    }

    public boolean isSnapshot() {
        return "snapshot".equals(this.type);
    }

    public File getJsonPath() {
        return Version.getJsonPath(this.id);
    }

    public File getJarPath() {
        return Version.getJarPath(this.id);
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public boolean isComplete() {
        return this.getJsonPath().isFile() && this.getJarPath().isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPatched() {
        ZipFile zip;
        block4: {
            boolean bl;
            File jar = this.getJarPath();
            zip = null;
            try {
                zip = new ZipFile(jar);
                if (zip.getEntry("mcpatcher.properties") == null) break block4;
                bl = true;
            }
            catch (IOException e) {
                try {
                    Logger.log(e);
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(zip);
                    throw throwable;
                }
                MCPatcherUtils.close(zip);
            }
            MCPatcherUtils.close(zip);
            return bl;
        }
        MCPatcherUtils.close(zip);
        return false;
    }

    public Version copyToNewVersion(JsonObject base, String newid, List<Library> extraLibraries) {
        JsonObject json = JsonUtils.parseJson(this.getJsonPath());
        if (json == null) {
            return null;
        }
        if (base != null) {
            for (Map.Entry<String, JsonElement> entry : base.entrySet()) {
                json.add(entry.getKey(), entry.getValue());
            }
        }
        File outPath = Version.getJsonPath(newid);
        json.addProperty(TAG_ID, newid);
        Version.updateDateField(json, TAG_TIME);
        Version.updateDateField(json, TAG_RELEASE_TIME);
        if (extraLibraries != null) {
            for (Library library : extraLibraries) {
                Version.addLibrary(json, library);
            }
        }
        outPath.getParentFile().mkdirs();
        if (!JsonUtils.writeJson(json, outPath)) {
            return null;
        }
        return Version.getLocalVersion(newid);
    }

    private static void updateDateField(JsonObject json, String field) {
        JsonElement element = json.get(field);
        if (!element.isJsonPrimitive()) {
            return;
        }
        String oldValue = element.getAsString();
        if (MCPatcherUtils.isNullOrEmpty(oldValue)) {
            return;
        }
        for (DateFormat format : DATE_FORMATS) {
            try {
                String newValue = Version.changeDate(format, oldValue);
                json.addProperty(field, newValue);
                return;
            }
            catch (ParseException e) {
            }
        }
    }

    private static void addLibrary(JsonObject json, Library library) {
        JsonElement element = json.get(TAG_LIBRARIES);
        if (element == null || !element.isJsonArray()) {
            return;
        }
        JsonArray libraries = element.getAsJsonArray();
        for (JsonElement lib : libraries) {
            String name;
            if (lib == null || !lib.isJsonObject() || (element = lib.getAsJsonObject().get(TAG_NAME)) == null || !element.isJsonPrimitive() || MCPatcherUtils.isNullOrEmpty(name = element.getAsString()) || !name.startsWith(library.getPackageName() + ":" + library.getName() + ":")) continue;
            return;
        }
        libraries.add(JsonUtils.newGson().toJsonTree(library, (Type)((Object)Library.class)));
    }

    private static String changeDate(DateFormat format, String oldValue) throws ParseException {
        oldValue = oldValue.replaceFirst("(\\d\\d):(\\d\\d)$", "$1$2");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(oldValue));
        calendar.set(14, 0);
        calendar.add(13, -1);
        return DATE_FORMATS[0].format(calendar.getTime()).replaceFirst("(\\d\\d)(\\d\\d)$", "$1:$2");
    }

    public void addToClassPath(File libDir, List<File> jars) {
        if (this.libraries != null) {
            for (Library l : this.libraries) {
                l.addToClassPath(libDir, jars);
            }
        }
    }

    public void unpackNatives(File libDir, File destDir) throws IOException {
        if (this.libraries != null && !this.libraries.isEmpty()) {
            destDir.mkdirs();
            for (Library l : this.libraries) {
                l.unpackNatives(libDir, destDir);
            }
        }
    }

    public void fetchLibraries(File libDir) throws PatcherException {
        if (!MCPatcherUtils.isNullOrEmpty(this.libraries)) {
            for (Library l : this.libraries) {
                if (l.exclude()) continue;
                l.fetch(libDir);
            }
        }
    }

    public void setGameArguments(Map<String, String> args) {
        args.put("version_name", this.id);
        args.put("game_assets", MCPatcherUtils.getMinecraftPath("assets").getPath());
    }

    public void addGameArguments(Map<String, String> args, List<String> cmdLine) {
        String argTemplate = !this.minecraftArguments.isEmpty() ? this.minecraftArguments : (LEGACY.equalsIgnoreCase(this.processArguments) ? LEGACY_VALUE : (USERNAME_SESSION.equalsIgnoreCase(this.processArguments) ? USERNAME_SESSION_VALUE : USERNAME_SESSION_VERSION_VALUE));
        for (String s : argTemplate.split("\\s+")) {
            if (s.equals("")) continue;
            if (s.startsWith("${") && s.endsWith("}")) {
                String value = args.get(s.substring(2, s.length() - 1));
                cmdLine.add(value == null ? "" : value);
                continue;
            }
            cmdLine.add(s);
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public int compareTo(Version o) {
        MinecraftVersion v1 = MinecraftVersion.parseVersion(this.getId());
        MinecraftVersion v2 = MinecraftVersion.parseVersion(o.getId());
        if (v1 != null && v2 != null) {
            return v1.compareTo(v2);
        }
        if (v1 != null) {
            return 1;
        }
        if (v2 != null) {
            return -1;
        }
        return this.getId().compareTo(o.getId());
    }
}

