/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.launcher.version;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.version.Extract;
import com.prupe.mcpatcher.launcher.version.Rule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Library {
    private static final String DEFAULT_URL = "https://s3.amazonaws.com/Minecraft.Download/libraries/";
    static final String NATIVES_TYPE;
    static final String OS_TYPE;
    static final String OS_VERSION;
    String name;
    List<Rule> rules = new ArrayList<Rule>();
    Map<String, String> natives;
    Extract extract;
    String url;

    public static String getOSType() {
        return OS_TYPE;
    }

    private Library() {
    }

    public Library(String name, String url) {
        this.name = name;
        this.url = url;
        this.rules = null;
    }

    public Library(String name) {
        this(name, null);
    }

    private boolean isNative() {
        return !MCPatcherUtils.isNullOrEmpty(this.natives);
    }

    public String getPackageName() {
        String[] split = Library.splitName(this.name, null);
        return split == null ? null : split[0];
    }

    public String getName() {
        String[] split = Library.splitName(this.name, null);
        return split == null ? null : split[1];
    }

    public String getVersion() {
        String[] split = Library.splitName(this.name, null);
        return split == null ? null : split[2];
    }

    private static File getPath(File libDir, String packageName, String library, String version, String suffix) {
        File jar = new File(libDir, packageName.replace(".", File.separator));
        jar = new File(jar, library);
        jar = new File(jar, version);
        StringBuilder name = new StringBuilder();
        name.append(library);
        name.append('-');
        name.append(version);
        if (!MCPatcherUtils.isNullOrEmpty(suffix)) {
            name.append('-');
            name.append(suffix);
        }
        name.append(".jar");
        return new File(jar, name.toString());
    }

    private static String[] splitName(String name, String suffix) {
        String[] tokens = name.split(":");
        if (tokens.length < 3) {
            return null;
        }
        return new String[]{tokens[0].replace('.', '/'), tokens[1], tokens[2], tokens[1] + "-" + tokens[2] + (MCPatcherUtils.isNullOrEmpty(suffix) ? "" : "-" + suffix) + ".jar"};
    }

    public boolean exclude() {
        if (this.rules == null) {
            return false;
        }
        boolean allow = this.rules.isEmpty();
        for (Rule rule : this.rules) {
            allow = rule.evaluate(allow);
        }
        return !allow;
    }

    public File getPath(File libDir) {
        String[] elem = Library.splitName(this.name, this.isNative() ? this.natives.get(NATIVES_TYPE) : null);
        if (elem == null) {
            return null;
        }
        File path = libDir;
        for (String s : elem) {
            path = new File(path, s);
        }
        return path;
    }

    public URL getURL() {
        String[] elem = Library.splitName(this.name, this.isNative() ? this.natives.get(NATIVES_TYPE) : null);
        if (elem == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(MCPatcherUtils.isNullOrEmpty(this.url) ? DEFAULT_URL : this.url);
        for (String s : elem) {
            if (!sb.toString().endsWith("/")) {
                sb.append("/");
            }
            sb.append(s);
        }
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fetch(File libDir) throws PatcherException {
        File local = this.getPath(libDir);
        URL remote = this.getURL();
        if (!local.isFile()) {
            local.getParentFile().mkdirs();
            Util.fetchURL(remote, local, false, 30000, Util.JAR_SIGNATURE);
        }
    }

    public void addToClassPath(File libDir, List<File> jars) {
        if (this.isNative() || MCPatcherUtils.isNullOrEmpty(this.name) || this.exclude()) {
            return;
        }
        jars.add(this.getPath(libDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpackNatives(File libDir, File destDir) throws IOException {
        if (!this.isNative() || MCPatcherUtils.isNullOrEmpty(this.name) || this.exclude()) {
            return;
        }
        File jar = this.getPath(libDir);
        ZipFile zip = null;
        InputStream input = null;
        FileOutputStream output = null;
        try {
            if (!jar.isFile()) {
                throw new FileNotFoundException(jar.getAbsolutePath());
            }
            zip = new ZipFile(jar);
            block2: for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                File dest;
                String name = zipEntry.getName();
                if (this.extract != null && this.extract.exclude != null) {
                    for (String s : this.extract.exclude) {
                        if (!name.startsWith(s)) continue;
                        continue block2;
                    }
                }
                if ((dest = new File(destDir, name)).isFile() && dest.length() == zipEntry.getSize()) continue;
                input = zip.getInputStream(zipEntry);
                output = new FileOutputStream(dest);
                Util.copyStream(input, output);
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                input = null;
                output = null;
            }
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(zip);
            MCPatcherUtils.close(input);
            MCPatcherUtils.close(output);
            throw throwable;
        }
        MCPatcherUtils.close(zip);
        MCPatcherUtils.close(input);
        MCPatcherUtils.close(output);
    }

    static {
        OS_VERSION = System.getProperty("os.version");
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux") || os.contains("unix")) {
            NATIVES_TYPE = "linux";
            OS_TYPE = "linux";
        } else if (os.contains("win")) {
            NATIVES_TYPE = "windows";
            OS_TYPE = "windows";
        } else if (os.contains("mac") || os.contains("osx")) {
            NATIVES_TYPE = "macosx";
            OS_TYPE = "osx";
        } else if (os.contains("solaris") || os.contains("sunos")) {
            NATIVES_TYPE = "solaris";
            OS_TYPE = "solaris";
        } else {
            NATIVES_TYPE = null;
            OS_TYPE = "unknown";
        }
    }
}

