/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.launcher.profile;

import com.google.gson.Gson;
import com.prupe.mcpatcher.JsonUtils;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.launcher.profile.Authentication;
import com.prupe.mcpatcher.launcher.profile.Profile;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ProfileList {
    Map<String, Profile> profiles = new HashMap<String, Profile>();
    String selectedProfile;
    Map<String, Authentication> authenticationDatabase = new HashMap<String, Authentication>();

    public static ProfileList getProfileList() {
        return JsonUtils.parseJson(ProfileList.getProfilesPath(), ProfileList.class);
    }

    public static File getProfilesPath() {
        return MCPatcherUtils.getMinecraftPath("launcher_profiles.json");
    }

    private ProfileList() {
    }

    public String toString() {
        return String.format("ProfileList{%d profiles, selectedProfile=%s}", this.profiles.size(), this.selectedProfile);
    }

    public String getSelectedProfile() {
        return this.selectedProfile;
    }

    public Profile getProfile(String name) {
        return this.profiles.get(name);
    }

    public Map<String, Profile> getProfiles() {
        return this.profiles;
    }

    public void dump(PrintStream output) {
        output.println(this.toString());
        Gson gson = JsonUtils.newGson();
        gson.toJson((Object)this, (Type)((Object)ProfileList.class), output);
        output.println();
    }
}

