/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TileMapping {
    public static final String[] BLOCKS = new String[]{"grass_top", "stone", "dirt", "grass_side", "wood", "stoneslab_side", "stoneslab_top", "brick", "tnt_side", "tnt_top", "tnt_bottom", "web", "rose", "flower", "portal", "sapling", "stonebrick", "bedrock", "sand", "gravel", "tree_side", "tree_top", "blockIron", "blockGold", "blockDiamond", "blockEmerald", "blockRedstone", null, "mushroom_red", "mushroom_brown", "sapling_jungle", null, "oreGold", "oreIron", "oreCoal", "bookshelf", "stoneMoss", "obsidian", "grass_side_overlay", "tallgrass", null, "beacon", null, "workbench_top", "furnace_front", "furnace_side", "dispenser_front", null, "sponge", "glass", "oreDiamond", "oreRedstone", "leaves", "leaves_opaque", "stonebricksmooth", "deadbush", "fern", "daylightDetector_top", "daylightDetector_side", "workbench_side", "workbench_front", "furnace_front_lit", "furnace_top", "sapling_spruce", "cloth_0", "mobSpawner", "snow", "ice", "snow_side", "cactus_top", "cactus_side", "cactus_bottom", "clay", "reeds", "musicBlock", "jukebox_top", "waterlily", "mycel_side", "mycel_top", "sapling_birch", "torch", "doorWood_upper", "doorIron_upper", "ladder", "trapdoor", "fenceIron", "farmland_wet", "farmland_dry", "crops_0", "crops_1", "crops_2", "crops_3", "crops_4", "crops_5", "crops_6", "crops_7", "lever", "doorWood_lower", "doorIron_lower", "redtorch_lit", "stonebricksmooth_mossy", "stonebricksmooth_cracked", "pumpkin_top", "hellrock", "hellsand", "lightgem", "piston_top_sticky", "piston_top", "piston_side", "piston_bottom", "piston_inner_top", "stem_straight", "rail_turn", "cloth_15", "cloth_7", "redtorch", "tree_spruce", "tree_birch", "pumpkin_side", "pumpkin_face", "pumpkin_jack", "cake_top", "cake_side", "cake_inner", "cake_bottom", "mushroom_skin_red", "mushroom_skin_brown", "stem_bent", "rail", "cloth_14", "cloth_6", "repeater", "leaves_spruce", "leaves_spruce_opaque", "bed_feet_top", "bed_head_top", "melon_side", "melon_top", "cauldron_top", "cauldron_inner", null, "mushroom_skin_stem", "mushroom_inside", "vine", "blockLapis", "cloth_13", "cloth_5", "repeater_lit", "thinglass_top", "bed_feet_end", "bed_feet_side", "bed_head_side", "bed_head_end", "tree_jungle", "cauldron_side", "cauldron_bottom", "brewingStand_base", "brewingStand", "endframe_top", "endframe_side", "oreLapis", "cloth_12", "cloth_4", "goldenRail", "redstoneDust_cross", "redstoneDust_line", "enchantment_top", "dragonEgg", "cocoa_2", "cocoa_1", "cocoa_0", "oreEmerald", "tripWireSource", "tripWire", "endframe_eye", "whiteStone", "sandstone_top", "cloth_11", "cloth_3", "goldenRail_powered", "redstoneDust_cross_overlay", "redstoneDust_line_overlay", "enchantment_side", "enchantment_bottom", "commandBlock", "itemframe_back", "flowerPot", "comparator", "comparator_lit", null, null, "netherquartz", "sandstone_side", "cloth_10", "cloth_2", "detectorRail", "leaves_jungle", "leaves_jungle_opaque", "wood_spruce", "wood_jungle", "carrots_0", "carrots_1", "carrots_2", "carrots_3", "potatoes_3", null, null, null, "sandstone_bottom", "cloth_9", "cloth_1", "redstoneLight", "redstoneLight_lit", "stonebricksmooth_carved", "wood_birch", "anvil_base", "anvil_top_damaged_1", null, null, null, null, null, null, null, "netherBrick", "cloth_8", "netherStalk_0", "netherStalk_1", "netherStalk_2", "sandstone_carved", "sandstone_smooth", "anvil_top", "anvil_top_damaged_2", null, null, null, null, null, null, null, "destroy_0", "destroy_1", "destroy_2", "destroy_3", "destroy_4", "destroy_5", "destroy_6", "destroy_7", "destroy_8", "destroy_9", null, null, null, null, null, null};
    public static final String[] ITEMS = new String[]{"helmetCloth", "helmetChain", "helmetIron", "helmetDiamond", "helmetGold", "flintAndSteel", "flint", "coal", "string", "seeds", "apple", "appleGold", "egg", "sugar", "snowball", "slot_empty_helmet", "chestplateCloth", "chestplateChain", "chestplateIron", "chestplateDiamond", "chestplateGold", "bow", "brick", "ingotIron", "feather", "wheat", "painting", "reeds", "bone", "cake", "slimeball", "slot_empty_chestplate", "leggingsCloth", "leggingsChain", "leggingsIron", "leggingsDiamond", "leggingsGold", "arrow", "quiver", "ingotGold", "sulphur", "bread", "sign", "doorWood", "doorIron", "bed", "fireball", "slot_empty_leggings", "bootsCloth", "bootsChain", "bootsIron", "bootsDiamond", "bootsGold", "stick", "compass", "diamond", "redstone", "clay", "paper", "book", "map", "seeds_pumpkin", "seeds_melon", "slot_empty_boots", "swordWood", "swordStone", "swordIron", "swordDiamond", "swordGold", "fishingRod", "clock", "bowl", "mushroomStew", "yellowDust", "bucket", "bucketWater", "bucketLava", "milk", "dyePowder_black", "dyePowder_gray", "shovelWood", "shovelStone", "shovelIron", "shovelDiamond", "shovelGold", "fishingRod_empty", "diode", "porkchopRaw", "porkchopCooked", "fishRaw", "fishCooked", "rottenFlesh", "cookie", "shears", "dyePowder_red", "dyePowder_pink", "pickaxeWood", "pickaxeStone", "pickaxeIron", "pickaxeDiamond", "pickaxeGold", "bow_pull_0", "carrotOnAStick", "leather", "saddle", "beefRaw", "beefCooked", "enderPearl", "blazeRod", "melon", "dyePowder_green", "dyePowder_lime", "hatchetWood", "hatchetStone", "hatchetIron", "hatchetDiamond", "hatchetGold", "bow_pull_1", "potatoBaked", "potato", "carrots", "chickenRaw", "chickenCooked", "ghastTear", "goldNugget", "netherStalkSeeds", "dyePowder_brown", "dyePowder_yellow", "hoeWood", "hoeStone", "hoeIron", "hoeDiamond", "hoeGold", "bow_pull_2", "potatoPoisonous", "minecart", "boat", "speckledMelon", "fermentedSpiderEye", "spiderEye", "potion", "potion_contents", "dyePowder_blue", "dyePowder_lightBlue", "helmetCloth_overlay", null, null, null, null, "comparator", "carrotGolden", "minecartChest", "pumpkinPie", "monsterPlacer", "potion_splash", "eyeOfEnder", "cauldron", "blazePowder", "dyePowder_purple", "dyePowder_magenta", "chestplateCloth_overlay", null, null, null, null, "netherbrick", null, "minecartFurnace", null, "monsterPlacer_overlay", "ruby", "expBottle", "brewingStand", "magmaCream", "dyePowder_cyan", "dyePowder_orange", "leggingsCloth_overlay", null, null, null, null, null, null, null, null, "netherStar", "emerald", "writingBook", "writtenBook", "flowerPot", "dyePowder_silver", "dyePowder_white", "bootsCloth_overlay", null, null, null, null, null, null, null, null, "fireworks", "fireworksCharge", "fireworksCharge_overlay", "netherquartz", "emptyMap", "frame", "enchantedBook", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "skull_skeleton", "skull_wither", "skull_zombie", "skull_char", "skull_creeper", null, null, null, null, null, null, null, null, null, null, null, "record_13", "record_cat", "record_blocks", "record_chirp", "record_far", "record_mall", "record_mellohi", "record_stal", "record_strad", "record_ward", "record_11", "record_wait", null, null, null, null};
    private static final Map<String, TileMapping> allMappings = new HashMap<String, TileMapping>();
    private final String tilesheetName;
    private final String dirPrefix;
    private final Map<String, Integer> tiles = new HashMap<String, Integer>();

    public static TileMapping getTileMapping(String tilesheetName) {
        return allMappings.get(tilesheetName);
    }

    public TileMapping(String tilesheetName, String dirPrefix) {
        this.tilesheetName = tilesheetName;
        this.dirPrefix = dirPrefix;
        allMappings.put(tilesheetName, this);
    }

    public String getTilesheetName() {
        return this.tilesheetName;
    }

    public String getDirectoryPrefix() {
        return this.dirPrefix;
    }

    public void add(int tileNum, String basename) {
        if (tileNum >= 0 && tileNum < 256 && basename != null) {
            this.tiles.put(this.getDirectoryPrefix() + basename + ".png", tileNum);
        }
    }

    public void add(int row, int col, String basename) {
        this.add(row + 16 * col, basename);
    }

    public void addAll(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.add(i, names[i]);
        }
    }

    public List<String> getTileNames(int tileNum) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.tiles.entrySet()) {
            if (tileNum != entry.getValue()) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    public String[][] getTileNames() {
        String[][] lists = new String[256][];
        for (Map.Entry<String, Integer> entry : this.tiles.entrySet()) {
            String[] newList;
            String name = entry.getKey();
            int num = entry.getValue();
            String[] oldList = lists[num];
            if (oldList == null) {
                newList = new String[]{name};
            } else {
                newList = new String[oldList.length + 1];
                System.arraycopy(oldList, 0, newList, 0, oldList.length);
                newList[oldList.length] = name;
            }
            lists[num] = newList;
        }
        return lists;
    }

    static {
        TileMapping map = new TileMapping("/terrain.png", "/textures/blocks/");
        map.addAll(BLOCKS);
        map = new TileMapping("/gui/items.png", "/textures/items/");
        map.addAll(ITEMS);
        map = new TileMapping("/btwmodtex/btwterrain01.png", "/textures/blocks/");
        map.add(0, "fcBlockPedestalStone_top");
        map.add(0, "fcBlockColumnStone_top");
        map.add(0, "fcBlockPedestalStone_side");
        map.add(0, "fcBlockDecorativeStone");
        map.add(1, "fcBlockTableWoodOak_leg");
        map.add(1, "fcBlockTurntable_switch");
        map.add(1, "fcBlockHopper_side");
        map.add(1, "fcBlockSaw");
        map.add(1, "fcBlockGearBox");
        map.add(1, "fcBlockTableWoodOak_top");
        map.add(1, "fcBlockSlats_side");
        map.add(2, "FCBlockBlightL0_bottom");
        map.add(2, "FCBlockBlightL1_bottom");
        map.add(4, "fcBlockLightBlock");
        map.add(5, "fcBlockLightBlock_lit");
        map.add(6, "fcBlockBlockDispenser_top");
        map.add(7, "fcBlockBlockDispenser_front");
        map.add(8, "fcBlockBlockDispenser_side");
        map.add(9, "fcBlockBlockDispenser_bottom");
        map.add(9, "fcBlockHibachi_bottom");
        map.add(9, "fcBlockDetectorBlock_bottom");
        map.add(10, "fcBlockDetectorBlock_top");
        map.add(10, "fcBlockHandCrank_bottom");
        map.add(11, "fcBlockDetectorBlock_front");
        map.add(12, "fcBlockDetectorBlock_front_on");
        map.add(13, "fcBlockDetectorBlock_side");
        map.add(14, "fcBlockBlockDispenser_bottom");
        map.add(14, "fcBlockHibachi_bottom");
        map.add(14, "fcBlockDetectorBlock_bottom");
        map.add(15, "fcBlockCement");
        map.add(16, "fcBlockCement_drying");
        map.add(17, "fcBlockCauldron_top");
        map.add(18, "fcBlockCauldron_side");
        map.add(19, "fcBlockCauldron_bottom");
        map.add(19, "fcBlockCrucible_bottom");
        map.add(20, "fcBlockCompanionCube");
        map.add(21, "fcBlockCompanionCube_front");
        map.add(22, "fcBlockCompanionCube_guts");
        map.add(23, "fcBlockDetectorRailWood");
        map.add(24, "fcBlockDetectorRailObsidian");
        map.add(25, "fcBlockMillStone_top");
        map.add(26, "fcBlockMillStone_side");
        map.add(27, "fcBlockMillStone_bottom");
        map.add(27, "fcBlockTurntable_bottom");
        map.add(28, "fcBlockHandCrank_shaft");
        map.add(29, "fcBlockHandCrank_top");
        map.add(30, "fcBlockHandCrank_side");
        map.add(31, "fcBlockDetectorBlock_top");
        map.add(31, "fcBlockHandCrank_bottom");
        map.add(32, "fcBlockRope");
        map.add(33, "fcBlockAxle_side");
        map.add(34, "fcBlockAxle_end");
        map.add(35, "fcBlockTableWoodOak_leg");
        map.add(35, "fcBlockTurntable_switch");
        map.add(35, "fcBlockHopper_side");
        map.add(35, "fcBlockSaw");
        map.add(35, "fcBlockGearBox");
        map.add(35, "fcBlockTableWoodOak_top");
        map.add(35, "fcBlockSlats_side");
        map.add(36, "fcBlockScrewPump_bottom");
        map.add(36, "fcBlockGearBox_input");
        map.add(37, "fcBlockHopper_bottom");
        map.add(37, "fcBlockPulley_bottom");
        map.add(37, "fcBlockHopper_top");
        map.add(37, "fcBlockGearBox_output");
        map.add(38, "fcBlockTableWoodOak_leg");
        map.add(38, "fcBlockTurntable_switch");
        map.add(38, "fcBlockHopper_side");
        map.add(38, "fcBlockSaw");
        map.add(38, "fcBlockGearBox");
        map.add(38, "fcBlockTableWoodOak_top");
        map.add(38, "fcBlockSlats_side");
        map.add(39, "fcBlockAnchor_nub");
        map.add(40, "fcBlockAnchor_front");
        map.add(41, "fcBlockAnchor");
        map.add(42, "fcBlockCandle_c00");
        map.add(42, "fcBlockCrucible_top");
        map.add(42, "fcBlockVase_c00");
        map.add(43, "fcBlockCrucible_side");
        map.add(44, "fcBlockCauldron_bottom");
        map.add(44, "fcBlockCrucible_bottom");
        map.add(45, "fcBlockCrucible_contents");
        map.add(45, "fcBlockUnfiredPottery_cooking");
        map.add(45, "fcBlockHopper_contents");
        map.add(46, "fcBlockHopper_bottom");
        map.add(46, "fcBlockPulley_bottom");
        map.add(46, "fcBlockHopper_top");
        map.add(46, "fcBlockGearBox_output");
        map.add(47, "fcBlockTableWoodOak_leg");
        map.add(47, "fcBlockTurntable_switch");
        map.add(47, "fcBlockHopper_side");
        map.add(47, "fcBlockSaw");
        map.add(47, "fcBlockGearBox");
        map.add(47, "fcBlockTableWoodOak_top");
        map.add(47, "fcBlockSlats_side");
        map.add(48, "fcBlockHopper_bottom");
        map.add(48, "fcBlockPulley_bottom");
        map.add(48, "fcBlockHopper_top");
        map.add(48, "fcBlockGearBox_output");
        map.add(49, "fcBlockCrucible_contents");
        map.add(49, "fcBlockUnfiredPottery_cooking");
        map.add(49, "fcBlockHopper_contents");
        map.add(50, "fcBlockHopper_ladder");
        map.add(51, "fcBlockHopper_trap");
        map.add(52, "fcBlockHopper_grate");
        map.add(53, "fcBlockSlats");
        map.add(53, "fcBlockHopper_slats");
        map.add(54, "fcBlockSlabWicker");
        map.add(54, "fcBlockPlatform_bottom");
        map.add(54, "fcBlockWicker");
        map.add(54, "fcBlockHopper_wicker");
        map.add(54, "fcBlockPlatform_top");
        map.add(55, "fcBlockHopper_soulsand");
        map.add(56, "fcBlockSaw_front");
        map.add(57, "fcBlockTableWoodOak_leg");
        map.add(57, "fcBlockTurntable_switch");
        map.add(57, "fcBlockHopper_side");
        map.add(57, "fcBlockSaw");
        map.add(57, "fcBlockGearBox");
        map.add(57, "fcBlockTableWoodOak_top");
        map.add(57, "fcBlockSlats_side");
        map.add(58, "fcBlockSaw_blade");
        map.add(59, "fcBlockHibachi_top");
        map.add(60, "fcBlockHibachi_side");
        map.add(61, "fcBlockBlockDispenser_bottom");
        map.add(61, "fcBlockHibachi_bottom");
        map.add(61, "fcBlockDetectorBlock_bottom");
        map.add(62, "fcBlockPulley_top");
        map.add(62, "fcBlockBellows_bottom");
        map.add(62, "fcBlockBellows_top");
        map.add(63, "fcBlockPulley_side");
        map.add(64, "fcBlockHopper_bottom");
        map.add(64, "fcBlockPulley_bottom");
        map.add(64, "fcBlockHopper_top");
        map.add(64, "fcBlockGearBox_output");
        map.add(65, "fcBlockTurntable_top");
        map.add(66, "fcBlockTurntable_side");
        map.add(67, "fcBlockMillStone_bottom");
        map.add(67, "fcBlockTurntable_bottom");
        map.add(68, "fcBlockPulley_top");
        map.add(68, "fcBlockBellows_bottom");
        map.add(68, "fcBlockBellows_top");
        map.add(69, "fcBlockBellows_front");
        map.add(70, "fcBlockBellows_side");
        map.add(71, "fcBlockPulley_top");
        map.add(71, "fcBlockBellows_bottom");
        map.add(71, "fcBlockBellows_top");
        map.add(72, "fcBlockSlabWicker");
        map.add(72, "fcBlockPlatform_bottom");
        map.add(72, "fcBlockWicker");
        map.add(72, "fcBlockHopper_wicker");
        map.add(72, "fcBlockPlatform_top");
        map.add(73, "fcBlockPlatform_side");
        map.add(74, "fcBlockSlabWicker");
        map.add(74, "fcBlockPlatform_bottom");
        map.add(74, "fcBlockWicker");
        map.add(74, "fcBlockHopper_wicker");
        map.add(74, "fcBlockPlatform_top");
        map.add(75, "fcBlockUnfiredPottery");
        map.add(76, "fcBlockCrucible_contents");
        map.add(76, "fcBlockUnfiredPottery_cooking");
        map.add(76, "fcBlockHopper_contents");
        map.add(77, "fcBlockPlanter");
        map.add(78, "fcBlockPlanter_top_soil");
        map.add(79, "fcBlockAnvil");
        map.add(80, "fcBlockBuddyBlock");
        map.add(81, "fcBlockBuddyBlock_on");
        map.add(82, "fcBlockBuddyBlock_front");
        map.add(83, "fcBlockBuddyBlock_front_on");
        map.add(84, "fcBlockMiningCharge_top");
        map.add(85, "fcBlockMiningCharge_side");
        map.add(86, "fcBlockMiningCharge_side_vert");
        map.add(87, "fcBlockMiningCharge_bottom");
        map.add(88, "fcBlockUrn");
        map.add(89, "fcBlockPedestalStone_top");
        map.add(89, "fcBlockColumnStone_top");
        map.add(89, "fcBlockPedestalStone_side");
        map.add(89, "fcBlockDecorativeStone");
        map.add(90, "fcBlockColumnStone_side");
        map.add(91, "fcBlockPedestalStone_top");
        map.add(91, "fcBlockColumnStone_top");
        map.add(91, "fcBlockPedestalStone_side");
        map.add(91, "fcBlockDecorativeStone");
        map.add(92, "fcBlockPedestalStone_top");
        map.add(92, "fcBlockColumnStone_top");
        map.add(92, "fcBlockPedestalStone_side");
        map.add(92, "fcBlockDecorativeStone");
        map.add(93, "fcBlockTableWoodOak_leg");
        map.add(93, "fcBlockTurntable_switch");
        map.add(93, "fcBlockHopper_side");
        map.add(93, "fcBlockSaw");
        map.add(93, "fcBlockGearBox");
        map.add(93, "fcBlockTableWoodOak_top");
        map.add(93, "fcBlockSlats_side");
        map.add(94, "fcBlockTableWoodOak_leg");
        map.add(94, "fcBlockTurntable_switch");
        map.add(94, "fcBlockHopper_side");
        map.add(94, "fcBlockSaw");
        map.add(94, "fcBlockGearBox");
        map.add(94, "fcBlockTableWoodOak_top");
        map.add(94, "fcBlockSlats_side");
        map.add(95, "fcBlockSlabWicker");
        map.add(95, "fcBlockPlatform_bottom");
        map.add(95, "fcBlockWicker");
        map.add(95, "fcBlockHopper_wicker");
        map.add(95, "fcBlockPlatform_top");
        map.add(96, "fcBlockDung");
        map.add(97, "fcBlockSoulforgedSteel");
        map.add(97, "fcBlockInfernalEnchanter_bottom");
        map.add(98, "fcBlockConcentratedHellfire");
        map.add(99, "fcBlockPadding");
        map.add(100, "fcBlockStub");
        map.add(100, "fcBlockSoap_top");
        map.add(101, "fcBlockSoap");
        map.add(102, "fcBlockRope_top");
        map.add(103, "fcBlockRope_side");
        map.add(104, "fcBlockGrate");
        map.add(105, "fcBlockVineTrap");
        map.add(106, "fcBlockBloodWood");
        map.add(107, "fcBlockBloodWood_side");
        map.add(108, "fcBlockSaplingBloodWood");
        map.add(109, "fcBlockLeavesBloodWood_old");
        map.add(110, "fcBlockSlabWicker");
        map.add(110, "fcBlockPlatform_bottom");
        map.add(110, "fcBlockWicker");
        map.add(110, "fcBlockHopper_wicker");
        map.add(110, "fcBlockPlatform_top");
        map.add(111, "fcBlockPlanter_top_soulsand");
        map.add(112, "fcBlockLens_output");
        map.add(113, "fcBlockLens");
        map.add(114, "fcBlockLens_input");
        map.add(115, "fcBlockLens_spotlight");
        map.add(116, "fcBlockSlats");
        map.add(116, "fcBlockHopper_slats");
        map.add(117, "fcBlockPlanter_top_grass");
        map.add(118, "fcBlockHopper_ironbars");
        map.add(121, "fcBlockInfernalEnchanter_top");
        map.add(122, "fcBlockInfernalEnchanter_side");
        map.add(123, "fcBlockSoulforgedSteel");
        map.add(123, "fcBlockInfernalEnchanter_bottom");
        map.add(124, "fcBlockGroth_bottom");
        map.add(124, "fcBlockNetherrackGrothed_top");
        map.add(125, "fcBlockNetherrackGrothed_side");
        map.add(126, "fcBlockNetherrackGrothed_bottom");
        map.add(127, "fcBlockGroth_top");
        map.add(128, "fcBlockGroth_top_grown");
        map.add(129, "fcBlockGroth_side");
        map.add(130, "fcBlockGroth_bottom");
        map.add(130, "fcBlockNetherrackGrothed_top");
        map.add(134, "FCBlockSlabDirt_grass_side");
        map.add(135, "FCBlockSlabDirt_grass_side_overlay");
        map.add(136, "FCBlockFarmlandFertilized_wet");
        map.add(137, "FCBlockFarmlandFertilized_dry");
        map.add(138, "fcBlockScrewPump_top");
        map.add(139, "fcBlockScrewPump_front");
        map.add(140, "fcBlockDecorativeWoodSpruce");
        map.add(140, "fcBlockScrewPump_side");
        map.add(141, "fcBlockScrewPump_bottom");
        map.add(141, "fcBlockGearBox_input");
        map.add(142, "fcBlockStake_top");
        map.add(143, "fcBlockStake_top_string");
        map.add(144, "fcBlockStake_side");
        map.add(145, "fcBlockStake_side_string");
        map.add(146, "fcBlockStakeString");
        map.add(147, "fcBlockPlanter_top_fertilized");
        map.add(148, "fcBlockWhiteStone");
        map.add(148, "fcBlockDecorativeWhiteStone");
        map.add(149, "fcBlockWhiteCobble");
        map.add(150, "fcBlockBarrel_top");
        map.add(150, "fcBlockPowderKeg_bottom");
        map.add(151, "fcBlockBarrel_side");
        map.add(152, "fcBlockPowderKeg_top");
        map.add(153, "fcBlockPowderKeg_side");
        map.add(154, "fcBlockBarrel_top");
        map.add(154, "fcBlockPowderKeg_bottom");
        map.add(155, "fcBlockColumnWhiteStone_side");
        map.add(156, "fcBlockChoppingBlock_dirty");
        map.add(157, "fcBlockLightningRod");
        map.add(158, "fcBlockDecorativeNetherBrick");
        map.add(159, "fcBlockColumnNetherBrick_side");
        map.add(160, "fcBlockDecorativeBrick");
        map.add(161, "fcBlockColumnBrick_side");
        map.add(162, "fcBlockDecorativeSandstone_top");
        map.add(163, "fcBlockDecorativeSandstone_side");
        map.add(164, "fcBlockDecorativeSandstone_bottom");
        map.add(165, "fcBlockColumnSandstone_side");
        map.add(166, "fcBlockColumnStoneBrick_side");
        map.add(166, "fcBlockDecorativeStoneBrick");
        map.add(167, "fcBlockColumnStoneBrick_side");
        map.add(167, "fcBlockDecorativeStoneBrick");
        map.add(168, "FCBlockDecorativeWoodOak");
        map.add(169, "fcBlockColumnWoodOak_side");
        map.add(170, "fcBlockDecorativeWoodSpruce");
        map.add(170, "fcBlockScrewPump_side");
        map.add(171, "fcBlockColumnWoodSpruce_side");
        map.add(172, "fcBlockDecorativeWoodBirch");
        map.add(173, "fcBlockColumnWoodBirch_side");
        map.add(174, "fcBlockDecorativeWoodJungle");
        map.add(175, "fcBlockColumnWoodJungle_side");
        map.add(176, "fcBlockChoppingBlock");
        map.add(177, "FCBlockBlightL0_top");
        map.add(178, "FCBlockBlightL0_side");
        map.add(179, "FCBlockBlightL0_bottom");
        map.add(179, "FCBlockBlightL1_bottom");
        map.add(180, "FCBlockBlightL1_top");
        map.add(181, "FCBlockBlightL1_side");
        map.add(182, "FCBlockBlightL0_bottom");
        map.add(182, "FCBlockBlightL1_bottom");
        map.add(183, "FCBlockBlightL2_top");
        map.add(184, "FCBlockBlightL2_roots");
        map.add(185, "FCBlockBlightL2_side");
        map.add(186, "FCBlockBlightL2_bottom");
        map.add(187, "FCBlockBlightL3_top");
        map.add(188, "FCBlockBlightL3_roots");
        map.add(189, "FCBlockBlightL3_side");
        map.add(190, "FCBlockPackedEarth");
        map.add(192, "FCBlockSlabDirt_grass_snow_side");
        map.add(208, "fcBlockCandle_c00");
        map.add(208, "fcBlockCrucible_top");
        map.add(208, "fcBlockVase_c00");
        map.add(209, "fcBlockCandle_c01");
        map.add(209, "fcBlockVase_c02");
        map.add(210, "fcBlockVase_c03");
        map.add(210, "fcBlockCandle_c02");
        map.add(211, "fcBlockCandle_c03");
        map.add(211, "fcBlockVase_c04");
        map.add(212, "fcBlockVase_c05");
        map.add(212, "fcBlockCandle_c04");
        map.add(213, "fcBlockVase_c06");
        map.add(213, "fcBlockCandle_c05");
        map.add(214, "fcBlockVase_c07");
        map.add(214, "fcBlockCandle_c06");
        map.add(215, "fcBlockVase_c08");
        map.add(215, "fcBlockCandle_c07");
        map.add(216, "fcBlockVase_c09");
        map.add(216, "fcBlockCandle_c08");
        map.add(217, "fcBlockCandle_c09");
        map.add(217, "fcBlockVase_c10");
        map.add(218, "fcBlockCandle_c10");
        map.add(218, "fcBlockVase_c11");
        map.add(219, "fcBlockCandle_c11");
        map.add(219, "fcBlockVase_c12");
        map.add(220, "fcBlockCandle_c12");
        map.add(220, "fcBlockVase_c13");
        map.add(221, "fcBlockCandle_c13");
        map.add(221, "fcBlockVase_c14");
        map.add(222, "fcBlockVase_c15");
        map.add(222, "fcBlockCandle_c14");
        map.add(223, "fcBlockCandle_c15");
        map.add(223, "fcBlockVase_c01");
        map.add(224, "fcBlockCandle_c00");
        map.add(224, "fcBlockCrucible_top");
        map.add(224, "fcBlockVase_c00");
        map.add(225, "fcBlockCandle_c15");
        map.add(225, "fcBlockVase_c01");
        map.add(226, "fcBlockCandle_c01");
        map.add(226, "fcBlockVase_c02");
        map.add(227, "fcBlockVase_c03");
        map.add(227, "fcBlockCandle_c02");
        map.add(228, "fcBlockCandle_c03");
        map.add(228, "fcBlockVase_c04");
        map.add(229, "fcBlockVase_c05");
        map.add(229, "fcBlockCandle_c04");
        map.add(230, "fcBlockVase_c06");
        map.add(230, "fcBlockCandle_c05");
        map.add(231, "fcBlockVase_c07");
        map.add(231, "fcBlockCandle_c06");
        map.add(232, "fcBlockVase_c08");
        map.add(232, "fcBlockCandle_c07");
        map.add(233, "fcBlockVase_c09");
        map.add(233, "fcBlockCandle_c08");
        map.add(234, "fcBlockCandle_c09");
        map.add(234, "fcBlockVase_c10");
        map.add(235, "fcBlockCandle_c10");
        map.add(235, "fcBlockVase_c11");
        map.add(236, "fcBlockCandle_c11");
        map.add(236, "fcBlockVase_c12");
        map.add(237, "fcBlockCandle_c12");
        map.add(237, "fcBlockVase_c13");
        map.add(238, "fcBlockCandle_c13");
        map.add(238, "fcBlockVase_c14");
        map.add(239, "fcBlockVase_c15");
        map.add(239, "fcBlockCandle_c14");
        map.add(240, "fcBlockHemp_bottom_00");
        map.add(241, "fcBlockHemp_bottom_01");
        map.add(242, "fcBlockHemp_bottom_02");
        map.add(243, "fcBlockHemp_bottom_03");
        map.add(244, "fcBlockHemp_bottom_04");
        map.add(245, "fcBlockHemp_bottom_05");
        map.add(246, "fcBlockHemp_bottom_06");
        map.add(247, "fcBlockHemp_bottom_07");
        map.add(248, "fcBlockHemp_top");
        map = new TileMapping("/btwmodtex/btwitems01.png", "/textures/items/");
        map.add(0, "fcItemBucketCement");
        map.add(1, "fcItemNethercoal");
        map.add(2, "fcItemSeedsHemp");
        map.add(3, "fcItemHemp");
        map.add(4, "fcItemGear");
        map.add(5, "fcItemFlour");
        map.add(6, "fcItemFibersHemp");
        map.add(7, "fcItemLeatherScoured");
        map.add(8, "fcItemDonut");
        map.add(9, "fcItemRope");
        map.add(10, "fcItemSlats");
        map.add(11, "fcItemDung");
        map.add(12, "fcItemWaterWheel");
        map.add(13, "fcItemBladeWindMill");
        map.add(14, "fcItemWindMill");
        map.add(15, "fcItempFabric");
        map.add(16, "fcItemGrate");
        map.add(17, "fcItemWicker");
        map.add(18, "fcItemLeatherTanned");
        map.add(19, "fcItemStrap");
        map.add(20, "fcItemBelt");
        map.add(21, "fcItemFoulFood");
        map.add(22, "fcItemBladeWood");
        map.add(23, "fcItemGlue");
        map.add(24, "fcItemTallow");
        map.add(25, "fcItemHaft");
        map.add(26, "fcItemIngotSteel");
        map.add(27, "fcItemPickAxeRefined");
        map.add(28, "fcItemShovelRefined");
        map.add(29, "fcItemHoeRefined");
        map.add(30, "fcItemAxeBattle");
        map.add(31, "fcItemSwordRefined");
        map.add(32, "fcItemNetherrackGround");
        map.add(33, "fcItemDustHellfire");
        map.add(34, "fcItemConcentratedHellfire");
        map.add(35, "fcItemArmorPlate");
        map.add(36, "fcItemHelmetPlate");
        map.add(37, "fcItemChestplatePlate");
        map.add(38, "fcItemLeggingsPlate");
        map.add(39, "fcItemBootsPlate");
        map.add(40, "fcItemBowComposite");
        map.add(41, "fcItemArrowheadBroadhead");
        map.add(42, "fcItemArrowBroadhead");
        map.add(43, "fcItemDustCoal");
        map.add(44, "fcItemPadding");
        map.add(45, "fcItemFilament");
        map.add(46, "fcItemRedstoneEye");
        map.add(47, "fcItemUrn");
        map.add(48, "fcItemUrnSoul");
        map.add(49, "fcItemEggPoached");
        map.add(50, "fcItemPotash");
        map.add(51, "fcItemSoap");
        map.add(52, "fcItemDustSaw");
        map.add(53, "fcItemHelmetLeatherTanned");
        map.add(54, "fcItemChestplateLeatherTanned");
        map.add(55, "fcItemLeggingsLeatherTanned");
        map.add(56, "fcItemBootsLeatherTanned");
        map.add(57, "fcItemBowComposite_pull_0");
        map.add(58, "fcItemBowComposite_pull_1");
        map.add(59, "fcItemBowComposite_pull_2");
        map.add(60, "fcItemDynamite");
        map.add(61, "fcItemHarnessBreeding");
        map.add(62, "fcItemDustSoul");
        map.add(63, "fcItemMattock");
        map.add(64, "fcItemHatchetRefined");
        map.add(65, "fcItemNetherSludge");
        map.add(66, "fcItemBrickNether");
        map.add(67, "fcItemTuningFork");
        map.add(68, "fcItemScrollArcane");
        map.add(69, "fcItemCandle");
        map.add(70, "fcItemSporesNetherGroth");
        map.add(71, "fcItemMould");
        map.add(72, "fcItemCanvas");
        map.add(73, "fcItemKibble");
        map.add(74, "fcItemEggRaw");
        map.add(75, "fcItemEggFried");
        map.add(76, "fcItemScrew");
        map.add(77, "fcItemArrowRotten");
        map.add(78, "fcItemOcularOfEnder");
        map.add(79, "fcItemEnderSpectacles");
        map.add(80, "fcItemStake");
        map.add(81, "fcItemBrimstone");
        map.add(82, "fcItemNitre");
        map.add(83, "fcItemElement");
        map.add(84, "fcItemFuse");
        map.add(85, "fcItemBlastingOil");
        map.add(86, "fcItemWindMillVertical");
        map.add(87, "fcItemPotatoBoiled");
        map.add(88, "fcItemMuttonRaw");
        map.add(89, "fcItemMuttonCooked");
        map.add(90, "fcItemWitchWart");
        map.add(91, "fcItemCarrotCooked");
        map.add(92, "fcItemSandwichTasty");
        map.add(93, "fcItemSteakAndPotatoes");
        map.add(94, "fcItemHamAndEggs");
        map.add(95, "fcItemDinnerSteak");
        map.add(96, "fcItemDinnerPork");
        map.add(97, "fcItemKebabRaw");
        map.add(98, "fcItemKebabCooked");
        map.add(99, "fcItemSoupChicken");
        map.add(100, "fcItemChowder");
        map.add(101, "fcItemStewHearty");
        map.add(102, "fcItemDinnerWolf");
        map.add(103, "fcItemMushroomRed");
        map.add(104, "fcItemMushroomBrown");
        map.add(105, "fcItemNuggetIron");
        map.add(106, "fcItemMail");
        map.add(107, "fcItemMushroomOmletRaw");
        map.add(108, "fcItemMushroomOmletCooked");
        map.add(109, "fcItemEggScrambledRaw");
        map.add(110, "fcItemEggScrambledCooked");
        map.add(111, "fcItemNetherQuartz");
    }
}

