/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.UserInterface;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Util {
    public static final byte[] JSON_SIGNATURE = "{".getBytes();
    public static final byte[] JAR_SIGNATURE = "PK".getBytes();
    public static final int SHORT_TIMEOUT = 6000;
    public static final int LONG_TIMEOUT = 30000;
    static int bits;
    static File devDir;

    static byte b(int value, int index) {
        return (byte)(value >> index * 8 & 0xFF);
    }

    static byte[] marshal16(int value) {
        return new byte[]{Util.b(value, 1), Util.b(value, 0)};
    }

    static byte[] marshalString(String value) {
        byte[] bytes = value.getBytes();
        int len = bytes.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(len + 2);
        try {
            bos.write(Util.marshal16(len));
            bos.write(bytes);
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return bos.toByteArray();
    }

    static int demarshal(byte[] data, int offset, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result |= data[i + offset] & 0xFF;
        }
        return result;
    }

    static int demarshal(byte[] data) {
        return Util.demarshal(data, 0, data.length);
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = input.read(buffer)) >= 0) {
            output.write(buffer, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File input, File output) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(input);
            os = new FileOutputStream(output);
            Util.copyStream(is, os);
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(is);
            MCPatcherUtils.close(os);
            throw throwable;
        }
        MCPatcherUtils.close(is);
        MCPatcherUtils.close(os);
    }

    static boolean contains(byte[] array, int item) {
        byte itemb = (byte)item;
        for (byte b : array) {
            if (itemb != b) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String computeMD5(File file) {
        String md5;
        block5: {
            md5 = null;
            FileInputStream input = null;
            ByteArrayOutputStream output = null;
            DigestOutputStream dos = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                input = new FileInputStream(file);
                output = new ByteArrayOutputStream();
                dos = new DigestOutputStream(output, md);
                Util.copyStream(input, dos);
                MCPatcherUtils.close(dos);
                md5 = BinaryRegex.binToStr(md.digest()).replaceAll(" ", "");
                MCPatcherUtils.close(input);
            }
            catch (Exception e) {
                Logger.log(e);
                break block5;
            }
            finally {
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(dos);
                MCPatcherUtils.close(output);
            }
            MCPatcherUtils.close(dos);
            MCPatcherUtils.close(output);
        }
        return md5;
    }

    static void logOSInfo() {
        Logger.log(0, "MCPatcher version is %s", MCPatcher.VERSION_STRING);
        Logger.log(0, "OS: %s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        Logger.log(0, "JVM: %s %s (%d bit)", System.getProperty("java.vendor"), System.getProperty("java.version"), bits);
        Logger.log(0, "Classpath: %s", System.getProperty("java.class.path"));
    }

    public static URL newURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void fetchURL(URL url, File local, boolean forceRemote, int timeoutMS, byte[] signature) throws PatcherException {
        boolean alreadyExists = Util.checkSignature(local, signature);
        if (forceRemote || !alreadyExists) {
            UserInterface ui;
            FileOutputStream output;
            BufferedInputStream input;
            block16: {
                input = null;
                output = null;
                ui = MCPatcher.ui;
                try {
                    int count;
                    System.out.printf("Fetching %s...\n", url);
                    ui.setStatusText("Downloading %s...", local.getName());
                    URLConnection connection = null;
                    block8: for (int redirect = 1; redirect <= 5; ++redirect) {
                        connection = url.openConnection();
                        connection.setConnectTimeout(timeoutMS);
                        connection.setReadTimeout(timeoutMS / 2);
                        if (!(connection instanceof HttpURLConnection)) continue;
                        HttpURLConnection httpConnection = (HttpURLConnection)connection;
                        httpConnection.setInstanceFollowRedirects(true);
                        httpConnection.connect();
                        switch (httpConnection.getResponseCode() / 100) {
                            case 2: {
                                break block8;
                            }
                            case 3: {
                                String newURL = httpConnection.getHeaderField("Location");
                                if (!MCPatcherUtils.isNullOrEmpty(newURL) && ("http".equals((url = new URL(newURL)).getProtocol()) || "https".equals(url.getProtocol()) || "ftp".equals(url.getProtocol()))) {
                                    System.out.printf("Redirect #%d: %s\n", redirect, url);
                                    connection = null;
                                    continue block8;
                                }
                            }
                            default: {
                                throw new IOException("HTTP response code: " + httpConnection.getResponseCode());
                            }
                        }
                    }
                    if (connection == null) {
                        throw new IOException("Redirect limit exceeded");
                    }
                    input = new BufferedInputStream(connection.getInputStream());
                    if (!Util.checkSignature(input, signature)) break block16;
                    output = new FileOutputStream(local);
                    int expLen = connection.getContentLength();
                    if (expLen <= 0) {
                        Util.copyStream(input, output);
                        break block16;
                    }
                    byte[] buffer = new byte[1024];
                    int total = 0;
                    while ((count = input.read(buffer)) > 0) {
                        ui.updateProgress(total += count, expLen);
                        ((OutputStream)output).write(buffer, 0, count);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new PatcherException.DownloadException(e, url, local);
                    }
                    catch (Throwable throwable) {
                        MCPatcherUtils.close(input);
                        MCPatcherUtils.close(output);
                        ui.updateProgress(0, 0);
                        throw throwable;
                    }
                }
            }
            MCPatcherUtils.close(input);
            MCPatcherUtils.close(output);
            ui.updateProgress(0, 0);
        }
        if (!Util.checkSignature(local, signature)) {
            if (!alreadyExists) {
                local.delete();
            }
            throw new PatcherException.DownloadException(url, local);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSignature(File file, byte[] signature) {
        boolean bl;
        if (signature == null || signature.length <= 0) {
            return true;
        }
        if (!file.isFile()) {
            return false;
        }
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            bl = Util.checkSignature(input, signature);
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(input);
                throw throwable;
            }
            MCPatcherUtils.close(input);
            return bl2;
        }
        MCPatcherUtils.close(input);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSignature(BufferedInputStream input, byte[] signature) throws IOException {
        if (signature != null && signature.length > 0 && input.markSupported()) {
            try {
                input.mark(signature.length);
                byte[] header = new byte[signature.length];
                int count = input.read(header);
                boolean bl = count == header.length && Arrays.equals(signature, header);
                return bl;
            }
            finally {
                input.reset();
            }
        }
        return true;
    }

    public static <K, V> void reorderMap(LinkedHashMap<K, V> map, int fromIndex, int toIndex) {
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.addAll(map.keySet());
        Object target = keys.remove(fromIndex);
        if (toIndex >= keys.size()) {
            keys.add(target);
        } else if (toIndex >= 0) {
            keys.add(toIndex, target);
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (Object e : keys) {
            newMap.put(target, map.get(e));
        }
        map.clear();
        map.putAll(newMap);
    }

    public static <K, V> void sortMap(LinkedHashMap<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        ArrayList entries = new ArrayList();
        entries.addAll(map.entrySet());
        Collections.sort(entries, comparator);
        map.clear();
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        try {
            bits = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        }
        catch (Throwable e) {
            bits = 32;
        }
        try {
            File path = new File(MCPatcher.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            if (path.isDirectory()) {
                devDir = path.getParentFile().getParentFile().getParentFile();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            devDir = null;
        }
    }
}

