/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.ProfileManager;
import java.io.File;
import java.util.ArrayList;

public abstract class UserInterface {
    abstract boolean shouldExit();

    void show() {
    }

    File chooseMinecraftDir(File enteredMCDir) {
        return null;
    }

    boolean locateMinecraftDir(String enteredMCDir) {
        ArrayList<File> mcDirs = new ArrayList<File>();
        if (enteredMCDir == null) {
            mcDirs.add(MCPatcherUtils.getDefaultGameDir());
            mcDirs.add(new File("."));
            mcDirs.add(new File(".."));
        } else {
            mcDirs.add(new File(enteredMCDir).getAbsoluteFile());
        }
        for (File dir : mcDirs) {
            if (!MCPatcherUtils.setGameDir(dir)) continue;
            return true;
        }
        File minecraftDir = (File)mcDirs.get(0);
        do {
            if ((minecraftDir = this.chooseMinecraftDir(minecraftDir)) != null) continue;
            return false;
        } while (!MCPatcherUtils.setGameDir(minecraftDir) && !MCPatcherUtils.setGameDir(minecraftDir.getParentFile()));
        return true;
    }

    abstract boolean go(ProfileManager var1);

    public void updateProgress(int value, int max) {
    }

    public void setStatusText(String format, Object ... params) {
    }

    void showBetaWarning() {
    }

    static class CLI
    extends UserInterface {
        CLI() {
            Config.setReadOnly(true);
            Config.getInstance().selectPatchedProfile = false;
        }

        @Override
        boolean shouldExit() {
            return true;
        }

        @Override
        boolean go(ProfileManager profileManager) {
            boolean ok = false;
            try {
                profileManager.refresh(this);
                MCPatcher.refreshMinecraftPath();
                MCPatcher.refreshModList();
                MCPatcher.checkModApplicability();
                System.out.println();
                System.out.println("#### Class map:");
                MCPatcher.showClassMaps(System.out);
                MCPatcher.patch();
                System.out.println();
                System.out.println("#### Patch summary:");
                MCPatcher.showPatchResults(System.out);
                ok = true;
            }
            catch (Throwable e) {
                Logger.log(e);
            }
            return ok;
        }
    }
}

