/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.google.gson.JsonObject;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.JsonUtils;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.UserInterface;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.profile.Profile;
import com.prupe.mcpatcher.launcher.profile.ProfileList;
import com.prupe.mcpatcher.launcher.version.Library;
import com.prupe.mcpatcher.launcher.version.Version;
import com.prupe.mcpatcher.launcher.version.VersionList;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ProfileManager {
    private final Config config;
    private boolean remote = true;
    private boolean ready;
    private VersionList remoteVersions;
    private final List<String> unmoddedVersions = new ArrayList<String>();
    private final List<String> releaseVersions = new ArrayList<String>();
    private String inputVersion;
    private String outputVersion;
    private ProfileList profiles;
    private final List<String> unmoddedProfiles = new ArrayList<String>();
    private final List<String> moddedProfiles = new ArrayList<String>();
    private String inputProfile;
    private String outputProfile;

    ProfileManager(Config config) {
        this.config = config;
    }

    void setRemote(boolean remote) {
        this.remote = remote;
    }

    boolean isRemote() {
        return this.remote;
    }

    boolean setAsActive() {
        return this.config.selectPatchedProfile;
    }

    void refresh(UserInterface ui) throws PatcherException, IOException {
        this.refresh(ui, false);
    }

    void refresh(UserInterface ui, boolean forceRemote) throws PatcherException, IOException {
        this.ready = false;
        this.rebuildRemoteVersionList(ui, forceRemote);
        this.rebuildLocalVersionList(ui);
        this.addUnmoddedCustomVersions(ui);
        this.rebuildProfileList(ui);
        String profile = this.profiles.getSelectedProfile();
        if (this.moddedProfiles.contains(profile)) {
            this.selectOutputProfile(profile);
        } else if (this.unmoddedProfiles.contains(profile)) {
            this.selectInputProfile(profile);
        } else {
            this.selectDefaultProfile();
        }
        this.ready = true;
    }

    private void rebuildRemoteVersionList(UserInterface ui, boolean forceRemote) throws PatcherException, IOException {
        this.remoteVersions = null;
        File path = VersionList.getPath();
        PatcherException patcherException = null;
        if (this.isRemote() || forceRemote) {
            ui.setStatusText("Getting version list from %s...", VersionList.VERSION_LIST.getHost());
            int timeout = forceRemote ? 15000 : 6000;
            try {
                VersionList.fetchRemoteVersionList(timeout);
            }
            catch (PatcherException e) {
                Logger.log(e);
                patcherException = e;
            }
        }
        if (Util.checkSignature(path, Util.JSON_SIGNATURE)) {
            ui.setStatusText("Reading version list...", new Object[0]);
            this.remoteVersions = VersionList.getLocalVersionList();
            if (this.remoteVersions != null && !this.remoteVersions.getVersions().isEmpty()) {
                return;
            }
        }
        if (!forceRemote) {
            Logger.log(0, "WARNING: using included copy of versions.json, may be out of date", new Object[0]);
            this.remoteVersions = VersionList.getBuiltInVersionList();
            this.config.fetchRemoteVersionList = false;
        }
        if (this.remoteVersions == null || this.remoteVersions.getVersions().isEmpty()) {
            if (patcherException == null) {
                throw new IOException("Could not get list of Minecraft versions");
            }
            throw patcherException;
        }
    }

    private void rebuildLocalVersionList(UserInterface ui) throws IOException {
        this.unmoddedVersions.clear();
        this.releaseVersions.clear();
        OriginalVersion.clear();
        for (Version remote : this.remoteVersions.getVersions()) {
            Version local;
            if (MinecraftVersion.parseVersion(remote.getId()) == null || (local = Version.getLocalVersion(remote.getId())) == null || !local.isComplete()) continue;
            this.unmoddedVersions.add(0, local.getId());
            if (!local.isSnapshot()) {
                this.releaseVersions.add(0, local.getId());
            }
            OriginalVersion.register(local);
            ui.setStatusText("Found %d installed versions...", this.unmoddedVersions.size());
        }
        if (this.unmoddedVersions.isEmpty()) {
            throw new IOException("No installed unmodded versions found");
        }
    }

    private void addUnmoddedCustomVersions(UserInterface ui) {
        File[] files = MCPatcherUtils.getMinecraftPath("versions").listFiles();
        if (files == null) {
            return;
        }
        for (File subdir : files) {
            Version local;
            String id;
            if (!subdir.isDirectory() || this.unmoddedVersions.contains(id = subdir.getName()) || (local = Version.getLocalVersion(id)) == null || !local.isComplete()) continue;
            ui.setStatusText("Comparing %s...", id);
            String md5sum = Util.computeMD5(local.getJarPath());
            OriginalVersion orig = OriginalVersion.get(md5sum);
            if (orig == null) continue;
            this.unmoddedVersions.add(id);
            OriginalVersion.addVersionMap(id, orig);
        }
    }

    private void rebuildProfileList(UserInterface ui) throws IOException {
        ui.setStatusText("Reading launcher profiles...", new Object[0]);
        this.unmoddedProfiles.clear();
        this.moddedProfiles.clear();
        this.moddedProfiles.add("MCPatcher");
        this.profiles = ProfileList.getProfileList();
        if (this.profiles == null || this.profiles.getProfiles().isEmpty()) {
            throw new IOException("Could not get list of launcher profiles");
        }
        this.pruneConfigProfiles();
        for (String string : this.config.profiles.keySet()) {
            if (MCPatcherUtils.isNullOrEmpty(string) || this.moddedProfiles.contains(string)) continue;
            this.moddedProfiles.add(string);
        }
        for (Map.Entry entry : this.profiles.getProfiles().entrySet()) {
            String version;
            if (this.moddedProfiles.contains(entry.getKey()) || (version = ((Profile)entry.getValue()).getLastVersionId()) != null && !this.unmoddedVersions.contains(version)) continue;
            this.unmoddedProfiles.add((String)entry.getKey());
        }
    }

    private void pruneConfigProfiles() {
        Set<String> patchedBefore = this.config.getPatchedVersionMap().keySet();
        HashSet<String> rmProfile = new HashSet<String>();
        for (Map.Entry<String, Config.ProfileEntry> entry : this.config.profiles.entrySet()) {
            String name = entry.getKey();
            Config.ProfileEntry profile = entry.getValue();
            if (!name.equals("MCPatcher") && !this.profiles.getProfiles().containsKey(name) || profile == null || MCPatcherUtils.isNullOrEmpty(profile.versions) || MCPatcherUtils.isNullOrEmpty(profile.config)) {
                rmProfile.add(name);
                continue;
            }
            HashSet<String> rmVersion = new HashSet<String>();
            for (Map.Entry<String, Config.VersionEntry> entry1 : profile.versions.entrySet()) {
                Version version;
                name = entry1.getKey();
                if (name == null) {
                    rmVersion.add(name);
                    continue;
                }
                if (name.equals(profile.version) || (version = Version.getLocalVersion(name)) != null && version.isComplete()) continue;
                rmVersion.add(name);
            }
            for (String s : rmVersion) {
                Logger.log(0, "removing version %s from config since local version is no longer installed", name);
                profile.versions.remove(s);
            }
        }
        for (String s : rmProfile) {
            Logger.log(0, "removing profile %s no longer in launcher_profiles", s);
            String version = this.config.profiles.get((Object)s).version;
            if (!MCPatcherUtils.isNullOrEmpty(version)) {
                Version.deleteLocalFiles(version);
            }
            this.config.profiles.remove(s);
        }
        if (this.config.profiles.get("MCPatcher") == null) {
            this.config.profiles.put("MCPatcher", new Config.ProfileEntry());
        }
        patchedBefore.removeAll(this.config.getPatchedVersionMap().keySet());
        for (Profile profile : this.profiles.getProfiles().values()) {
            patchedBefore.remove(profile.getLastVersionId());
        }
        for (String s : patchedBefore) {
            Logger.log(0, "removing orphaned version %s", s);
            Version.deleteLocalFiles(s);
        }
    }

    private static String makePatchedVersionString(String inputVersion, String outputProfile) {
        return inputVersion + '-' + outputProfile.toLowerCase().replaceAll("[^a-zA-Z0-9_.]", "");
    }

    private String makePatchedVersionString() {
        return ProfileManager.makePatchedVersionString(this.inputVersion, this.outputProfile);
    }

    private List<String> getProfileVersions(Profile profile) {
        if (profile == null || profile.isSnapshotAllowed()) {
            return this.unmoddedVersions;
        }
        return this.releaseVersions;
    }

    private String getProfileVersion(Profile profile) {
        if (profile != null && !MCPatcherUtils.isNullOrEmpty(profile.getLastVersionId())) {
            String version = profile.getLastVersionId();
            if (this.unmoddedVersions.contains(version)) {
                return version;
            }
            version = this.config.getPatchedVersionMap().get(version);
            if (this.unmoddedVersions.contains(version)) {
                return version;
            }
            if (this.unmoddedVersions.contains(version = version.replaceFirst("-.*", ""))) {
                return version;
            }
        }
        return this.getProfileVersions(profile).get(0);
    }

    boolean isReady() {
        return this.ready;
    }

    List<String> getInputProfiles() {
        return this.unmoddedProfiles;
    }

    List<String> getInputVersions() {
        return this.unmoddedVersions;
    }

    List<String> getOutputProfiles() {
        return this.moddedProfiles;
    }

    int getSelectedInputVersionIndex() {
        return this.getInputVersions().indexOf(this.inputVersion);
    }

    int getSelectedOutputProfileIndex() {
        return this.getOutputProfiles().indexOf(this.outputProfile);
    }

    String getInputProfile() {
        return this.inputProfile;
    }

    String getOutputProfile() {
        return this.outputProfile;
    }

    String getInputVersion() {
        return this.inputVersion;
    }

    String getInputBaseVersion() {
        return OriginalVersion.getBaseVersion(this.inputVersion);
    }

    String getOutputVersion() {
        return this.outputVersion;
    }

    ProfileList getProfileList() {
        return this.profiles;
    }

    void selectInputProfile(String name) {
        this.inputProfile = null;
        this.outputProfile = null;
        if (!this.unmoddedProfiles.contains(name)) {
            name = this.unmoddedProfiles.get(0);
        }
        this.inputProfile = name;
        for (Map.Entry<String, Config.ProfileEntry> entry : this.config.profiles.entrySet()) {
            if (!name.equals(entry.getValue().original)) continue;
            this.outputProfile = entry.getKey();
            break;
        }
        if (MCPatcherUtils.isNullOrEmpty(this.outputProfile)) {
            this.outputProfile = "MCPatcher";
        }
        this.config.selectedProfile = this.outputProfile;
        this.config.getSelectedProfile().original = this.inputProfile;
        this.selectInputVersion(this.getProfileVersion(this.getInputProfileData()));
    }

    void selectOutputProfile(String name) {
        this.outputProfile = name;
        this.config.selectedProfile = name;
        Config.ProfileEntry profileEntry = this.config.getSelectedProfile();
        this.inputProfile = this.unmoddedProfiles.contains(profileEntry.original) ? profileEntry.original : null;
        Config.VersionEntry versionEntry = profileEntry.versions.get(profileEntry.version);
        if (versionEntry != null && this.unmoddedVersions.contains(versionEntry.original)) {
            this.inputVersion = versionEntry.original;
            this.outputVersion = this.makePatchedVersionString();
        } else {
            this.inputVersion = this.unmoddedVersions.get(0);
            versionEntry = new Config.VersionEntry();
            versionEntry.original = this.inputVersion;
            this.outputVersion = this.makePatchedVersionString();
            profileEntry.versions.put(this.outputVersion, versionEntry);
        }
    }

    void selectInputVersion(String name) {
        this.inputVersion = null;
        this.outputVersion = null;
        if (MCPatcherUtils.isNullOrEmpty(name)) {
            name = this.getProfileVersion(this.getInputProfileData());
        }
        if (this.unmoddedVersions.contains(name)) {
            this.inputVersion = name;
        } else if (this.config.getSelectedProfile().versions.get(name) != null) {
            this.inputVersion = this.config.getSelectedProfile().versions.get((Object)name).original;
            this.outputVersion = name;
        }
        if (!this.unmoddedVersions.contains(name)) {
            this.inputVersion = this.unmoddedVersions.get(0);
        }
        if (MCPatcherUtils.isNullOrEmpty(this.outputVersion)) {
            this.outputVersion = this.makePatchedVersionString();
        }
        this.config.getSelectedProfile().version = this.outputVersion;
        this.config.getSelectedVersion().original = this.inputVersion;
    }

    private void selectDefaultProfile() {
        this.inputProfile = null;
        this.config.selectedProfile = this.outputProfile = "MCPatcher";
        this.selectInputVersion(null);
    }

    File getInputJar() {
        if (MCPatcherUtils.isNullOrEmpty(this.inputVersion)) {
            return null;
        }
        return Version.getJarPath(this.inputVersion);
    }

    File getOutputJar() {
        if (MCPatcherUtils.isNullOrEmpty(this.outputVersion)) {
            return null;
        }
        return Version.getJarPath(this.outputVersion);
    }

    private Profile getInputProfileData() {
        return this.profiles.getProfile(this.inputProfile);
    }

    Profile getOutputProfileData() {
        if (MCPatcherUtils.isNullOrEmpty(this.outputProfile)) {
            return null;
        }
        ProfileList profiles = ProfileList.getProfileList();
        return profiles == null ? null : profiles.getProfile(this.outputProfile);
    }

    Version getOutputVersionData() {
        if (MCPatcherUtils.isNullOrEmpty(this.outputVersion)) {
            return null;
        }
        return Version.getLocalVersion(this.outputVersion);
    }

    Library getForgeLibrary() {
        Version local = Version.getLocalVersion(this.getInputVersion());
        if (local == null) {
            return null;
        }
        for (Library library : local.getLibraries()) {
            if (library.exclude() || !library.getName().equalsIgnoreCase("minecraftforge")) continue;
            return library;
        }
        return null;
    }

    private void addLauncherProfile(String profile, String version, String javaArgs) {
        Profile newProfile;
        Profile oldProfile = this.getInputProfileData();
        if (oldProfile == null) {
            oldProfile = new Profile();
        }
        boolean setActive = this.setAsActive();
        if (!Version.getJarPath(version).isFile()) {
            setActive = false;
        }
        if ((newProfile = oldProfile.copyToNewProfile(profile, version, setActive, javaArgs)) != null) {
            this.profiles.getProfiles().put(profile, newProfile);
            if (!this.moddedProfiles.contains(profile)) {
                this.moddedProfiles.add(profile);
            }
        }
    }

    void createOutputProfile(JsonObject baseVersion, String javaArgs, List<Library> extraLibraries) {
        Version version;
        if (!MCPatcherUtils.isNullOrEmpty(this.inputVersion) && !MCPatcherUtils.isNullOrEmpty(this.outputVersion) && (version = Version.getLocalVersion(this.inputVersion)) != null && version.isComplete()) {
            version.copyToNewVersion(baseVersion, this.outputVersion, extraLibraries);
        }
        this.addLauncherProfile(this.outputProfile, this.outputVersion, javaArgs);
    }

    void copyCurrentProfile(String newName) {
        String newVersion = ProfileManager.makePatchedVersionString(this.inputVersion, newName);
        this.addLauncherProfile(newName, newVersion, null);
        Config.ProfileEntry entry = this.config.profiles.get(this.outputProfile);
        Config.ProfileEntry newEntry = JsonUtils.cloneJson(entry, Config.ProfileEntry.class);
        newEntry.version = newVersion;
        this.config.profiles.put(newName, newEntry);
        if (!this.moddedProfiles.contains(newName)) {
            this.moddedProfiles.add(newName);
        }
        Config.VersionEntry version = JsonUtils.cloneJson(entry.versions.get(entry.version), Config.VersionEntry.class);
        version.original = this.inputVersion;
        newEntry.versions.clear();
        newEntry.versions.put(newVersion, version);
        this.selectOutputProfile(newName);
    }

    void deleteLocalVersion(String version) {
        if (!MCPatcherUtils.isNullOrEmpty(version) && !this.unmoddedVersions.contains(version)) {
            Version.deleteLocalFiles(version);
        }
    }

    void deleteProfile(String name, boolean deleteVersions) {
        Profile profile;
        if (MCPatcherUtils.isNullOrEmpty(name) || name.equals("MCPatcher")) {
            return;
        }
        Config.ProfileEntry entry = this.config.profiles.get(name);
        if (deleteVersions && entry != null) {
            this.deleteLocalVersion(entry.version);
        }
        if ((profile = this.profiles.getProfile(name)) != null) {
            profile.delete(this.inputProfile);
        }
        if (name.equals(this.config.selectedProfile)) {
            this.config.selectedProfile = "MCPatcher";
        }
        this.profiles.getProfiles().remove(name);
        if (!name.equals(this.outputProfile)) {
            this.config.profiles.remove(name);
        }
        this.moddedProfiles.remove(name);
    }

    File getLocalVersionPath(String name) {
        return Version.getJarPath(name).getParentFile();
    }

    void dumpJson(PrintStream out) {
        boolean selected;
        Object profile;
        String name;
        if (this.profiles == null) {
            out.printf("%s: (error)\n", "launcher_profiles.json");
        } else {
            out.printf("%s: (%d profiles)\n", "launcher_profiles.json", this.profiles.getProfiles().size());
            for (Map.Entry<String, Profile> entry : this.profiles.getProfiles().entrySet()) {
                name = entry.getKey();
                profile = entry.getValue();
                selected = name != null && name.equals(this.profiles.getSelectedProfile());
                out.printf("  %1s %s version=%s\n", selected ? "*" : "", name, ((Profile)profile).getLastVersionId());
            }
        }
        out.printf("%s: (%d profiles)\n", "mcpatcher.json", this.config.profiles.size());
        for (Map.Entry<String, Object> entry : this.config.profiles.entrySet()) {
            name = entry.getKey();
            profile = (Config.ProfileEntry)entry.getValue();
            selected = name != null && name.equals(this.config.selectedProfile);
            out.printf("  %1s %s original=%s (%d versions)\n", selected ? "*" : "", name, ((Config.ProfileEntry)profile).original, ((Config.ProfileEntry)profile).versions.size());
            for (Map.Entry<String, Config.VersionEntry> entry1 : ((Config.ProfileEntry)profile).versions.entrySet()) {
                name = entry1.getKey();
                Config.VersionEntry version = entry1.getValue();
                selected = name != null && name.equals(((Config.ProfileEntry)profile).version);
                out.printf("    %1s %s original=%s (%d mods)\n", selected ? "*" : "", name, version.original, version.mods.size());
            }
        }
        out.printf("%s%s: (%d/%d versions)\n", "versions.json", this.remote ? "" : " (local copy)", this.unmoddedVersions.size(), this.remoteVersions.getVersions().size());
        for (Version version : this.remoteVersions.getVersions()) {
            out.printf("  %1s %s%s\n", version.isComplete() ? "*" : "", version.getId(), version.isSnapshot() ? " (snapshot)" : "");
        }
    }

    void dumpLibs(PrintStream out, String versionString) throws Exception {
        Version version;
        if (MCPatcherUtils.isNullOrEmpty(versionString)) {
            versionString = this.getInputVersion();
        }
        if ((version = Version.getLocalVersion(versionString)) == null) {
            return;
        }
        Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element userlibraries = xml.createElement("eclipse-userlibraries");
        userlibraries.setAttribute("version", "2");
        xml.appendChild(xml.createComment(" Window > Preferences > Java > Build Path > User Libraries > Import "));
        xml.appendChild(userlibraries);
        Element userlibrary = xml.createElement("library");
        userlibrary.setAttribute("name", "mclibs");
        userlibrary.setAttribute("systemlibrary", "false");
        userlibraries.appendChild(userlibrary);
        File libDir = MCPatcherUtils.getMinecraftPath("libraries");
        for (Library library : version.getLibraries()) {
            if (library == null || library.exclude()) continue;
            Element archive = xml.createElement("archive");
            File path = library.getPath(libDir);
            if (!path.isFile()) continue;
            archive.setAttribute("path", path.getAbsolutePath());
            userlibrary.appendChild(archive);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(xml), new StreamResult(writer));
        String output = writer.getBuffer().toString();
        out.println(output);
    }

    private static class OriginalVersion {
        private static final Map<String, OriginalVersion> md5Map = new HashMap<String, OriginalVersion>();
        private static final Map<String, String> baseVersionMap = new HashMap<String, String>();
        final String version;
        final String md5sum;

        static void register(Version version) throws IOException {
            OriginalVersion o = new OriginalVersion(version);
            md5Map.put(o.md5sum, o);
        }

        static OriginalVersion get(String md5sum) {
            return md5Map.get(md5sum);
        }

        static void addVersionMap(String customVersion, OriginalVersion baseVersion) {
            baseVersionMap.put(customVersion, baseVersion.version);
        }

        static String getBaseVersion(String inputVersion) {
            String baseVersion = baseVersionMap.get(inputVersion);
            return MCPatcherUtils.isNullOrEmpty(baseVersion) ? inputVersion : baseVersion;
        }

        static void clear() {
            md5Map.clear();
            baseVersionMap.clear();
        }

        private OriginalVersion(Version version) throws IOException {
            this.version = version.getId();
            this.md5sum = Util.computeMD5(version.getJarPath());
            if (MCPatcherUtils.isNullOrEmpty(this.md5sum)) {
                throw new IOException("Could not determine md5sum of " + version.getJarPath());
            }
        }
    }
}

