/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.google.gson.JsonObject;
import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ExternalMod;
import com.prupe.mcpatcher.ForgeAdapter;
import com.prupe.mcpatcher.JarClassLoader;
import com.prupe.mcpatcher.JsonUtils;
import com.prupe.mcpatcher.LegacyVersionList;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MinecraftJar;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.ProfileManager;
import com.prupe.mcpatcher.UserInterface;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.version.Library;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

class ModList {
    static LegacyVersionList legacyVersionList;
    private final MinecraftVersion version;
    private final Map<String, BuiltInMod> builtInMods = new LinkedHashMap<String, BuiltInMod>();
    private final List<Mod> modsByIndex = new ArrayList<Mod>();
    private final Map<String, Mod> modsByName = new HashMap<String, Mod>();
    private boolean needReorder;
    private boolean applied;

    ModList(MinecraftVersion version) throws PatcherException, IOException, ClassNotFoundException {
        this.version = version;
        this.register(new BuiltInMod("__Base", BaseMod.class).setInternal(true));
        boolean found = false;
        if (version.compareTo("13w18a") < 0) {
            if (legacyVersionList == null) {
                legacyVersionList = ModList.getLegacyVersionList();
            }
            if (legacyVersionList != null) {
                for (LegacyVersionList.Version entry : legacyVersionList.find("20130818")) {
                    if (version.compareTo(entry.maxMinecraftVersion) > 0) continue;
                    ClassLoader loader = ModList.getLegacyClassLoader(entry);
                    for (LegacyVersionList.Mod mod : entry.mods) {
                        this.register(new BuiltInMod(mod, loader));
                    }
                    found = true;
                    break;
                }
            }
        }
        if (!found) {
            ClassLoader loader;
            if (Util.devDir == null) {
                loader = new JarClassLoader("/mods4.jar");
            } else {
                File local = new File(Util.devDir, "out/artifacts/mods4/mods4.jar");
                loader = new URLClassLoader(new URL[]{local.toURI().toURL()});
            }
            this.register(new BuiltInMod("__TexturePackBase", "com.prupe.mcpatcher.mal.BaseTexturePackMod", loader).setInternal(true));
            this.register(new BuiltInMod("__TilesheetBase", "com.prupe.mcpatcher.mal.BaseTilesheetMod", loader).setInternal(true));
            this.register(new BuiltInMod("__NBT", "com.prupe.mcpatcher.mal.NBTMod", loader).setInternal(true));
            this.register(new BuiltInMod("__BlockAPI", "com.prupe.mcpatcher.mal.BlockAPIMod", loader).setInternal(true));
            this.register(new BuiltInMod("__ItemAPI", "com.prupe.mcpatcher.mal.ItemAPIMod", loader).setInternal(true));
            this.register(new BuiltInMod("__BiomeAPI", "com.prupe.mcpatcher.mal.BiomeAPIMod", loader).setInternal(true));
            this.register(new BuiltInMod("Extended HD", "com.prupe.mcpatcher.mod.ExtendedHD", loader));
            this.register(new BuiltInMod("Random Mobs", "com.prupe.mcpatcher.mod.RandomMobs", loader));
            this.register(new BuiltInMod("Custom Colors", "com.prupe.mcpatcher.mod.CustomColors", loader));
            this.register(new BuiltInMod("Connected Textures", "com.prupe.mcpatcher.mod.ConnectedTextures", loader));
            this.register(new BuiltInMod("Better Glass", "com.prupe.mcpatcher.mod.BetterGlass", loader));
            this.register(new BuiltInMod("Better Skies", "com.prupe.mcpatcher.mod.BetterSkies", loader));
            this.register(new BuiltInMod("Custom Item Textures", "com.prupe.mcpatcher.mod.CustomItemTextures", loader));
        }
        this.loadBuiltInMods(true);
    }

    private static LegacyVersionList getLegacyVersionList() throws PatcherException {
        LegacyVersionList list;
        for (File dir : new File[]{Util.devDir, new File("."), new File("..")}) {
            File local;
            if (dir == null || !Util.checkSignature(local = new File(dir, "../mcpatcher-legacy/mcpatcher-legacy.json"), Util.JSON_SIGNATURE) || (list = JsonUtils.parseJson(local, LegacyVersionList.class)) == null) continue;
            return list;
        }
        File local = MCPatcherUtils.getMinecraftPath("mcpatcher-legacy.json");
        Util.fetchURL(LegacyVersionList.VERSIONS_URL, local, true, 30000, Util.JSON_SIGNATURE);
        list = JsonUtils.parseJson(local, LegacyVersionList.class);
        local.delete();
        return list;
    }

    private static ClassLoader getLegacyClassLoader(LegacyVersionList.Version version) throws MalformedURLException, PatcherException {
        String currentMD5;
        File local;
        for (File dir : new File[]{Util.devDir, new File("."), new File("..")}) {
            if (dir == null || !Util.checkSignature(local = new File(dir, "../mcpatcher-legacy/out/artifacts/" + version.id + version.getResource()), Util.JAR_SIGNATURE)) continue;
            return new URLClassLoader(new URL[]{local.toURI().toURL()});
        }
        Library library = new Library("com.prupe.mcpatcher:mcpatcher-legacy:" + version.libraryVersion, "https://bitbucket.org/prupe/mcpatcher-legacy/downloads/");
        local = library.getPath(MCPatcherUtils.getMinecraftPath("libraries"));
        boolean forceRemote = false;
        if (local.isFile() && !MCPatcherUtils.isNullOrEmpty(version.md5) && !version.md5.equals(currentMD5 = Util.computeMD5(local))) {
            forceRemote = true;
        }
        local.getParentFile().mkdirs();
        Util.fetchURL(version.getURL(), local, forceRemote, 30000, Util.JAR_SIGNATURE);
        return new URLClassLoader(new URL[]{local.toURI().toURL()});
    }

    private void register(BuiltInMod builtInMod) {
        try {
            Method preInit = builtInMod.modClass.getDeclaredMethod("preInitialize", new Class[0]);
            preInit.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.builtInMods.put(builtInMod.name, builtInMod);
    }

    void close() {
        for (Mod mod : this.modsByIndex) {
            mod.close();
        }
    }

    void loadBuiltInMods(boolean internal) {
        for (BuiltInMod builtInMod : this.builtInMods.values()) {
            if (this.modsByName.containsKey(builtInMod.name) || !MCPatcher.experimentalMods && builtInMod.experimental || internal != builtInMod.internal) continue;
            this.addNoReplace(this.newModInstance(builtInMod));
            this.needReorder = true;
        }
        if (this.needReorder) {
            while (this.needReorder) {
                this.needReorder = this.reorderBuiltinMods();
            }
            this.refreshInternalMods();
        }
    }

    void loadCustomMods(File directory) {
        if (directory.isDirectory()) {
            for (File f : directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            })) {
                try {
                    this.loadCustomModsFromJar(f);
                }
                catch (Throwable e) {
                    Logger.log(0, "Error loading mods from %s", f.getPath());
                    Logger.log(e);
                }
            }
        }
    }

    private void loadCustomModsFromJar(File file) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Logger.log(0, "Opening %s", file.getPath());
        JarFile jar = new JarFile(file);
        URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
        for (JarEntry entry : Collections.list(jar.entries())) {
            Mod mod;
            if (entry.isDirectory() || !MinecraftJar.isClassFile(entry.getName()) || !this.addNoReplace(mod = this.loadCustomMod(loader, ClassMap.filenameToClassName(entry.getName())))) continue;
            Logger.log(1, "new %s()", mod.getClass().getName());
            mod.customJar = file;
        }
    }

    private Mod loadCustomMod(File file, String className) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
            return this.loadCustomMod(loader, className);
        }
        catch (Throwable e) {
            Logger.log(e);
            return null;
        }
    }

    private Mod loadCustomMod(URLClassLoader loader, String className) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int flags;
        Class<?> cl = null;
        try {
            cl = loader.loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            Logger.log(1, "WARNING: skipping %s: %s", className, e.toString());
        }
        if (cl != null && !cl.isInterface() && Mod.class.isAssignableFrom(cl) && !Modifier.isAbstract(flags = cl.getModifiers()) && Modifier.isPublic(flags)) {
            return this.newModInstance(cl.asSubclass(Mod.class));
        }
        return null;
    }

    void loadImpliedMods(ProfileManager profileManager, UserInterface ui) throws Exception {
        Library forgeLibrary = profileManager.getForgeLibrary();
        if (forgeLibrary != null && !this.hasModSubclass(ForgeAdapter.class)) {
            ForgeAdapter forgeMod = new ForgeAdapter(ui, forgeLibrary);
            forgeMod.setEnabled(true);
            this.addFirstBuiltin(forgeMod);
        }
    }

    boolean hasModSubclass(Class<? extends Mod> modClass) {
        for (Mod mod : this.getAll()) {
            if (!modClass.isAssignableFrom(mod.getClass())) continue;
            return true;
        }
        return false;
    }

    List<Mod> getAll() {
        return this.modsByIndex;
    }

    List<Mod> getVisible() {
        ArrayList<Mod> visibleMods = new ArrayList<Mod>();
        for (Mod mod : this.modsByIndex) {
            if (mod.internal && !MCPatcher.showInternal) continue;
            visibleMods.add(mod);
        }
        return visibleMods;
    }

    ArrayList<Mod> getSelected() {
        ArrayList<Mod> list = new ArrayList<Mod>();
        for (Mod mod : this.modsByIndex) {
            if (!mod.okToApply() || !mod.isEnabled()) continue;
            list.add(mod);
        }
        return list;
    }

    HashMap<String, String> getReverseMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Mod mod : this.modsByIndex) {
            for (Map.Entry<String, String> entry : mod.getClassMap().getReverseClassMap().entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    Mod get(String name) {
        return this.modsByName.get(name);
    }

    Mod get(int index) {
        return this.modsByIndex.get(index);
    }

    int size() {
        return this.modsByIndex.size();
    }

    void enableValidMods(boolean enableAll) {
        for (int i = this.modsByIndex.size() - 1; i >= 0; --i) {
            Mod mod = this.modsByIndex.get(i);
            boolean enabled = mod.okToApply();
            if (enabled) {
                if (!enableAll) continue;
                this.selectMod(mod, true);
                continue;
            }
            this.selectMod(mod, false);
        }
    }

    void disableAll() {
        for (int i = this.modsByIndex.size() - 1; i >= 0; --i) {
            Mod mod = this.modsByIndex.get(i);
            this.selectMod(mod, false);
        }
    }

    boolean isApplied() {
        return this.applied;
    }

    void setApplied(boolean applied) {
        this.applied = applied;
    }

    void remove(Mod mod) {
        String name = mod.getName();
        for (int i = 0; i < this.modsByIndex.size(); ++i) {
            if (this.modsByIndex.get(i) != mod) continue;
            this.modsByIndex.remove(i);
            this.modsByName.remove(name);
        }
        mod.close();
    }

    int addFirst(Mod mod) {
        String name = mod.getName();
        Mod oldMod = this.modsByName.get(name);
        if (oldMod != null) {
            this.remove(oldMod);
        }
        this.modsByIndex.add(0, mod);
        this.modsByName.put(name, mod);
        return this.indexOfVisible(mod);
    }

    int addFirstBuiltin(Mod mod) {
        int i;
        String name = mod.getName();
        Mod oldMod = this.modsByName.get(name);
        if (oldMod != null) {
            this.remove(oldMod);
        }
        for (i = 0; i < this.modsByIndex.size() && ((oldMod = this.modsByIndex.get(i)) instanceof ExternalMod || this.indexOfVisible(oldMod) < 0); ++i) {
        }
        this.modsByIndex.add(i, mod);
        this.modsByName.put(name, mod);
        return this.indexOfVisible(mod);
    }

    int addLast(Mod mod) {
        String name = mod.getName();
        Mod oldMod = this.modsByName.get(name);
        if (oldMod != null) {
            this.remove(oldMod);
        }
        this.modsByIndex.add(mod);
        this.modsByName.put(name, mod);
        return this.indexOfVisible(mod);
    }

    int moveUp(int index, boolean toTop) {
        return this.move(index, -1, toTop);
    }

    int moveDown(int index, boolean toBottom) {
        return this.move(index, 1, toBottom);
    }

    private int move(int index, int direction, boolean allTheWay) {
        List<Mod> visibleMods = this.getVisible();
        int newIndex = !allTheWay ? index + direction : (direction < 0 ? 0 : visibleMods.size() - 1);
        if (index >= 0 && index < visibleMods.size() && newIndex >= 0 && newIndex < visibleMods.size() && newIndex != index) {
            List<Mod> mods = visibleMods.subList(Math.min(index, newIndex), Math.max(index, newIndex) + 1);
            block0: for (int i = 0; i < this.modsByIndex.size(); ++i) {
                for (int j = 0; j < mods.size(); ++j) {
                    if (this.modsByIndex.get(i) != mods.get(j)) continue;
                    this.modsByIndex.set(i, mods.get((j + direction + mods.size()) % mods.size()));
                    continue block0;
                }
            }
            index = newIndex;
        }
        return index;
    }

    int replace(Mod oldMod, Mod newMod) {
        int index = this.indexOf(oldMod);
        if (index >= 0 && oldMod.getName().equals(newMod.getName())) {
            this.modsByIndex.set(index, newMod);
            this.modsByName.put(newMod.getName(), newMod);
            oldMod.close();
            return this.indexOfVisible(newMod);
        }
        this.remove(oldMod);
        return this.addFirst(newMod);
    }

    private boolean addNoReplace(Mod mod) {
        if (mod == null) {
            return false;
        }
        String name = mod.getName();
        if (this.modsByName.containsKey(name)) {
            Logger.log(1, "WARNING: duplicate mod %s ignored", name);
            return false;
        }
        this.modsByName.put(name, mod);
        this.modsByIndex.add(mod);
        mod.setEnabled(mod.defaultEnabled);
        mod.loadOptions();
        return true;
    }

    int indexOf(Mod mod) {
        for (int i = 0; i < this.modsByIndex.size(); ++i) {
            if (mod != this.modsByIndex.get(i)) continue;
            return i;
        }
        return -1;
    }

    int indexOfVisible(Mod mod) {
        List<Mod> visible = this.getVisible();
        for (int i = 0; i < visible.size(); ++i) {
            if (mod != visible.get(i)) continue;
            return i;
        }
        return -1;
    }

    void selectMod(Mod mod, boolean enable) {
        HashMap<Mod, Boolean> changes = new HashMap<Mod, Boolean>();
        try {
            if (enable) {
                this.enableMod(changes, mod, false);
            } else {
                this.disableMod(changes, mod, false);
            }
        }
        catch (ModDependencyException e) {
            Logger.log(e);
        }
        for (Map.Entry entry : changes.entrySet()) {
            mod = (Mod)entry.getKey();
            mod.setEnabled((Boolean)entry.getValue());
        }
        this.refreshInternalMods();
    }

    private boolean reorderBuiltinMods() {
        ArrayList<String> builtIns = new ArrayList<String>();
        builtIns.addAll(this.builtInMods.keySet());
        for (int i = 0; i < this.modsByIndex.size(); ++i) {
            Mod mod1 = this.modsByIndex.get(i);
            int index1 = builtIns.indexOf(mod1.getName());
            if (index1 < 0) continue;
            for (int j = i + 1; j < this.modsByIndex.size(); ++j) {
                Mod mod2 = this.modsByIndex.get(j);
                int index2 = builtIns.indexOf(mod2.getName());
                if (index2 < 0 || index1 <= index2) continue;
                this.modsByIndex.set(i, mod2);
                this.modsByIndex.set(j, mod1);
                return true;
            }
        }
        return false;
    }

    void refreshInternalMods() {
        while (true) {
            for (int i = 0; i < this.modsByIndex.size() - 1; ++i) {
                Mod mod1 = this.modsByIndex.get(i);
                Mod mod = this.modsByIndex.get(i + 1);
                if (!mod1.internal || mod.internal || this.dependsOn(mod, mod1)) continue;
                this.modsByIndex.set(i, mod);
                this.modsByIndex.set(i + 1, mod1);
            }
            break;
        }
        if (!MCPatcher.showInternal) {
            for (Mod mod : this.modsByIndex) {
                if (!mod.internal) continue;
                mod.setEnabled(false);
            }
        }
        HashMap<Mod, Boolean> changes = new HashMap<Mod, Boolean>();
        for (Mod mod : this.modsByIndex) {
            try {
                if (mod.internal) continue;
                if (mod.isEnabled()) {
                    this.enableMod(changes, mod, false);
                    continue;
                }
                this.disableMod(changes, mod, false);
            }
            catch (ModDependencyException e) {
                Logger.log(e);
            }
        }
        for (Map.Entry entry : changes.entrySet()) {
            Mod mod = (Mod)entry.getKey();
            mod.setEnabled((Boolean)entry.getValue());
        }
    }

    private boolean dependsOn(Mod mod1, Mod mod2) {
        if (mod1 == null || mod2 == null) {
            return false;
        }
        if (mod1 == mod2) {
            return true;
        }
        for (Mod.Dependency dep : mod1.dependencies) {
            if (!dep.required || dep.name.equals(mod1.getName()) || !this.dependsOn(this.modsByName.get(dep.name), mod2)) continue;
            return true;
        }
        return false;
    }

    private void enableMod(HashMap<Mod, Boolean> inst, Mod mod, boolean recursive) throws ModDependencyException {
        if (mod == null) {
            return;
        }
        if (!mod.okToApply()) {
            throw new ModDependencyException(mod.getName() + " cannot be applied");
        }
        if (inst.containsKey(mod)) {
            if (!inst.get(mod).booleanValue()) {
                throw new ModDependencyException(mod.getName() + " is both conflicting and required");
            }
            return;
        }
        inst.put(mod, true);
        for (Mod.Dependency dep : mod.dependencies) {
            Mod dmod = this.modsByName.get(dep.name);
            if (dep.required) {
                if (dmod == null) {
                    throw new ModDependencyException("dependent mod " + dep.name + " not available");
                }
                this.enableMod(inst, dmod, true);
                continue;
            }
            this.disableMod(inst, dmod, true);
        }
        for (Mod dmod : this.modsByIndex) {
            if (dmod == mod) continue;
            for (Mod.Dependency dep : dmod.dependencies) {
                if (!dep.name.equals(mod.getName()) || dep.required) continue;
                this.disableMod(inst, dmod, true);
            }
        }
    }

    private void disableMod(HashMap<Mod, Boolean> inst, Mod mod, boolean recursive) throws ModDependencyException {
        if (mod == null) {
            return;
        }
        if (inst.containsKey(mod)) {
            if (inst.get(mod).booleanValue()) {
                throw new ModDependencyException(mod.getName() + " is both conflicting and required");
            }
            return;
        }
        inst.put(mod, false);
        for (Mod dmod : this.modsByIndex) {
            if (dmod == mod) continue;
            for (Mod.Dependency dep : dmod.dependencies) {
                if (!dep.name.equals(mod.getName()) || !dep.required) continue;
                this.disableMod(inst, dmod, true);
            }
        }
    }

    void loadSavedMods() {
        Config config = Config.getInstance();
        ArrayList<String> invalidEntries = new ArrayList<String>();
        this.needReorder = false;
        for (Map.Entry<String, Config.ModEntry> entry : config.getSelectedVersion().mods.entrySet()) {
            String name = entry.getKey();
            Config.ModEntry modEntry = entry.getValue();
            String type = modEntry.type;
            boolean enabled = modEntry.enabled;
            Mod mod = null;
            if (name != null && type != null) {
                File file;
                String path;
                if (type.equals("builtIn")) {
                    BuiltInMod builtInMod = this.builtInMods.get(name);
                    if (builtInMod == null) {
                        this.needReorder = true;
                    } else if (MCPatcher.experimentalMods || !builtInMod.experimental) {
                        mod = this.newModInstance(builtInMod);
                    }
                } else if (type.equals("externalZip")) {
                    path = modEntry.path;
                    List<Config.FileEntry> files = modEntry.files;
                    if (path != null && files != null && (file = new File(path)).isFile()) {
                        LinkedHashMap<String, String> fileMap = new LinkedHashMap<String, String>();
                        for (Config.FileEntry entry1 : files) {
                            fileMap.put(entry1.to, entry1.from);
                        }
                        try {
                            mod = new ExternalMod(new ZipFile(file), fileMap);
                        }
                        catch (IOException e) {
                            Logger.log(e);
                        }
                    }
                } else if (type.equals("externalJar")) {
                    path = modEntry.path;
                    String className = modEntry.className;
                    if (path != null && className != null && (file = new File(path)).exists() && (mod = this.loadCustomMod(file, className)) != null) {
                        mod.customJar = file;
                    }
                }
            }
            if (mod == null) {
                invalidEntries.add(name);
                continue;
            }
            this.addNoReplace(mod);
            mod.setEnabled(enabled);
        }
        for (String name : invalidEntries) {
            config.getSelectedVersion().mods.remove(name);
        }
        this.refreshInternalMods();
    }

    private void updateModElement(Mod mod, Config.ModEntry modEntry) {
        boolean bl = modEntry.enabled = mod.okToApply() && mod.isEnabled();
        if (mod instanceof ExternalMod) {
            ExternalMod extmod = (ExternalMod)mod;
            modEntry.type = "externalZip";
            modEntry.path = extmod.zipFile.getName();
            modEntry.className = null;
            ArrayList<Config.FileEntry> files = new ArrayList<Config.FileEntry>();
            files.clear();
            for (Map.Entry<String, String> entry : extmod.fileMap.entrySet()) {
                files.add(new Config.FileEntry(entry.getValue(), entry.getKey()));
            }
            modEntry.files = files;
        } else if (mod.customJar == null) {
            modEntry.type = "builtIn";
            modEntry.path = null;
            modEntry.className = null;
            modEntry.files = null;
        } else {
            modEntry.type = "externalJar";
            modEntry.path = mod.customJar.getPath();
            modEntry.className = mod.getClass().getCanonicalName();
            modEntry.files = null;
        }
    }

    void updateProperties() {
        Config.VersionEntry versionEntry = Config.getInstance().getSelectedVersion();
        HashMap<String, Config.ModEntry> oldEntries = new HashMap<String, Config.ModEntry>();
        oldEntries.putAll(versionEntry.mods);
        versionEntry.mods.clear();
        for (Mod mod : this.modsByIndex) {
            if (mod.internal) continue;
            Config.ModEntry modEntry = (Config.ModEntry)oldEntries.get(mod.getName());
            if (modEntry == null) {
                modEntry = new Config.ModEntry();
            }
            this.updateModElement(mod, modEntry);
            versionEntry.mods.put(mod.getName(), modEntry);
        }
    }

    private Mod newModInstance(Class<? extends Mod> modClass) {
        Mod mod;
        try {
            mod = modClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        try {
            boolean b;
            Method supportsVersion = modClass.getDeclaredMethod("supportsVersion", MinecraftVersion.class);
            if (supportsVersion.getReturnType() == Boolean.TYPE && Modifier.isStatic(supportsVersion.getModifiers()) && !(b = ((Boolean)supportsVersion.invoke(null, this.version)).booleanValue())) {
                return null;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return mod;
    }

    private Mod newModInstance(BuiltInMod builtInMod) {
        Mod mod = this.newModInstance(builtInMod.modClass);
        if (mod != null) {
            mod.internal = builtInMod.internal;
            mod.experimental = builtInMod.experimental;
        }
        return mod;
    }

    JsonObject getOverrideVersionJson() {
        JsonObject json = null;
        for (Mod mod : this.getSelected()) {
            JsonObject json1 = mod.getOverrideVersionJson();
            if (json1 == null) continue;
            json = json1;
        }
        return json;
    }

    String getExtraJavaArguments() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        for (Mod mod : this.getSelected()) {
            mod.addExtraJavaArguments(cmdLine);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : cmdLine) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    List<Library> getExtraLibraries() {
        ArrayList<Library> list = new ArrayList<Library>();
        for (Mod mod : this.getSelected()) {
            mod.addExtraLibraries(list);
        }
        return list;
    }

    private static class BuiltInMod {
        final String name;
        final Class<? extends Mod> modClass;
        boolean internal;
        boolean experimental;

        BuiltInMod(LegacyVersionList.Mod entry, ClassLoader loader) throws ClassNotFoundException {
            this(entry.name, entry.className, loader);
            this.setInternal(entry.isInternal());
            this.setExperimental(entry.isExperimental());
        }

        BuiltInMod(String name, String className, ClassLoader loader) throws ClassNotFoundException {
            this(name, loader.loadClass(className).asSubclass(Mod.class));
        }

        BuiltInMod(String name, Class<? extends Mod> modClass) {
            this.name = name;
            this.modClass = modClass;
        }

        BuiltInMod setInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        BuiltInMod setExperimental(boolean experimental) {
            this.experimental = experimental;
            return this;
        }
    }

    private class ModDependencyException
    extends Exception {
        ModDependencyException(String s) {
            super(s);
        }
    }
}

