/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MinecraftVersion
implements Comparable<MinecraftVersion> {
    private static final String VERSION_PATTERN = "(\\d[_.0-9]*[a-z]?)";
    private static final Pattern PRERELEASE_PATTERN = Pattern.compile("(?:pre|rc)(\\d+)$", 2);
    private static final int NOT_PRERELEASE = 9999;
    private static final Pattern RD_PATTERN = Pattern.compile("rd-(\\d+)", 2);
    private static final Pattern CLASSIC_PATTERN = Pattern.compile("c((\\d[_.0-9]*[a-z]?)([a-z][_.0-9]*)?)", 2);
    private static final Pattern INDEV_PATTERN = null;
    private static final Pattern INFDEV_PATTERN = Pattern.compile("inf-(\\d+)", 2);
    private static final Pattern ALPHA_PATTERN = Pattern.compile("a(\\d[_.0-9]*[a-z]?)", 2);
    private static final Pattern BETA_PATTERN = Pattern.compile("b(\\d[_.0-9]*[a-z]?)", 2);
    private static final Pattern RC_PATTERN = Pattern.compile("rc\\s?(\\d+)", 2);
    private static final Pattern FINAL_PATTERN = Pattern.compile("(\\d[_.0-9]*[a-z]?)", 2);
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(\\d+w\\d+[a-z])", 2);
    private static final List<Pattern> ALL_PATTERNS = new ArrayList<Pattern>();
    private final String versionString;
    private final int[] parsedVersion;
    private final boolean snapshot;
    private final int preRelease;
    private static final Map<MinecraftVersion, String> knownMD5s = new HashMap<MinecraftVersion, String>();
    private static final Map<String, MinecraftVersion> alternateMD5s = new HashMap<String, MinecraftVersion>();
    private static final List<MinecraftVersion> versionOrdering = new ArrayList<MinecraftVersion>();

    private static void addKnownVersion(String versionString, String md5) {
        try {
            MinecraftVersion version = MinecraftVersion.parseVersion(versionString);
            if (version == null) {
                throw new IllegalArgumentException("bad known version " + version);
            }
            if (md5 != null && !md5.matches("\\p{XDigit}{32}")) {
                throw new IllegalArgumentException("bad md5 sum for known version " + version);
            }
            versionOrdering.remove(version);
            versionOrdering.add(version);
            knownMD5s.put(version, md5);
            alternateMD5s.put(md5, version);
        }
        catch (Throwable e) {
            Logger.log(e);
        }
    }

    private static int findClosestKnownVersion(MinecraftVersion version) {
        Integer partialResult;
        int i;
        for (i = 0; i < versionOrdering.size() && ((partialResult = version.comparePartial(versionOrdering.get(i))) == null || partialResult > 0); ++i) {
        }
        return i;
    }

    public static MinecraftVersion parseVersion(String versionString) {
        if (versionString == null) {
            return null;
        }
        versionString = MinecraftVersion.shortenVersionString(versionString);
        int preRelease = 9999;
        Matcher preMatcher = PRERELEASE_PATTERN.matcher(versionString);
        if (preMatcher.find()) {
            try {
                preRelease = Integer.parseInt(preMatcher.group(1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (preMatcher.start() > 0) {
                versionString = preMatcher.replaceFirst("");
            }
        }
        if (versionString.matches("2\\.0_(blue|purple|red)")) {
            return new MinecraftVersion(ALL_PATTERNS.indexOf(FINAL_PATTERN), versionString, "1.5.1." + versionString, preRelease);
        }
        for (int i = 0; i < ALL_PATTERNS.size(); ++i) {
            Matcher matcher;
            if (ALL_PATTERNS.get(i) == null || !(matcher = ALL_PATTERNS.get(i).matcher(versionString)).matches()) continue;
            return new MinecraftVersion(i, matcher, preRelease);
        }
        return null;
    }

    private static String shortenVersionString(String versionString) {
        versionString = versionString.toLowerCase();
        versionString = versionString.replaceFirst("^minecraft", "");
        versionString = versionString.replaceFirst("prerelease", "pre");
        versionString = versionString.replaceAll("\\s", "");
        versionString = versionString.replaceFirst("^alpha[- ]", "a");
        versionString = versionString.replaceFirst("^beta[- ]", "b");
        return versionString;
    }

    private static int[] splitVersionString(int era, String versionString) {
        String[] token = versionString.split("[^0-9]+");
        int[] parsed = new int[token.length + 1];
        parsed[0] = era;
        for (int i = 0; i < token.length; ++i) {
            if (token[i].isEmpty()) continue;
            try {
                parsed[i + 1] = Integer.parseInt(token[i]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return parsed;
    }

    private MinecraftVersion(int era, Matcher matcher, int preRelease) {
        this.versionString = matcher.group(0);
        this.preRelease = preRelease;
        this.parsedVersion = MinecraftVersion.splitVersionString(era, matcher.group(1));
        if (era == ALL_PATTERNS.indexOf(SNAPSHOT_PATTERN)) {
            this.snapshot = true;
            this.parsedVersion[0] = ALL_PATTERNS.indexOf(FINAL_PATTERN);
        } else {
            this.snapshot = false;
        }
    }

    private MinecraftVersion(int era, String versionString, String fakeVersionString, int preRelease) {
        this.versionString = versionString;
        this.preRelease = preRelease;
        this.parsedVersion = MinecraftVersion.splitVersionString(era, fakeVersionString);
        this.snapshot = false;
    }

    public boolean isPrerelease() {
        return this.preRelease != 9999 || this.snapshot;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String toString() {
        return this.getVersionString();
    }

    private Integer comparePartial(MinecraftVersion that) {
        int i;
        if (this.snapshot != that.snapshot) {
            return null;
        }
        int[] a = this.parsedVersion;
        int[] b = that.parsedVersion;
        for (i = 0; i < a.length && i < b.length; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i];
        }
        if (i < a.length) {
            return a[i];
        }
        if (i < b.length) {
            return -b[i];
        }
        i = this.preRelease - that.preRelease;
        if (i != 0) {
            return i;
        }
        return this.getVersionString().compareTo(that.getVersionString());
    }

    @Override
    public int compareTo(MinecraftVersion that) {
        int j;
        Integer partialResult = this.comparePartial(that);
        if (partialResult != null) {
            return partialResult;
        }
        int i = MinecraftVersion.findClosestKnownVersion(this);
        if (i != (j = MinecraftVersion.findClosestKnownVersion(that))) {
            return i - j;
        }
        return this.getVersionString().compareTo(that.getVersionString());
    }

    @Override
    public int compareTo(String versionString) {
        return this.compareTo(MinecraftVersion.parseVersion(versionString));
    }

    public boolean equals(Object that) {
        return that instanceof MinecraftVersion && this.compareTo((MinecraftVersion)that) == 0;
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    static String getOriginalMD5(MinecraftVersion version) {
        return knownMD5s.get(version);
    }

    boolean isNewerThanAnyKnownVersion() {
        if (versionOrdering.isEmpty()) {
            return true;
        }
        MinecraftVersion highestVersion = versionOrdering.get(versionOrdering.size() - 1);
        return this.compareTo(highestVersion) > 0;
    }

    static boolean isKnownMD5(String md5) {
        return md5 != null && (knownMD5s.containsValue(md5) || alternateMD5s.containsKey(md5));
    }

    static {
        ALL_PATTERNS.add(RD_PATTERN);
        ALL_PATTERNS.add(CLASSIC_PATTERN);
        ALL_PATTERNS.add(INDEV_PATTERN);
        ALL_PATTERNS.add(INFDEV_PATTERN);
        ALL_PATTERNS.add(ALPHA_PATTERN);
        ALL_PATTERNS.add(BETA_PATTERN);
        ALL_PATTERNS.add(RC_PATTERN);
        ALL_PATTERNS.add(FINAL_PATTERN);
        ALL_PATTERNS.add(SNAPSHOT_PATTERN);
        try {
            MinecraftVersion.addKnownVersion("a1.2.6", "ddd5e39467f28d1ea1a03b4d9e790867");
            MinecraftVersion.addKnownVersion("b1.0.2", "d200c465b8c167cc8df6537531fc9a48");
            MinecraftVersion.addKnownVersion("b1.1_02", "7d547e495a770c62054ef136add43034");
            MinecraftVersion.addKnownVersion("b1.2", "6426223efe23c3931a4ef89685be3349");
            MinecraftVersion.addKnownVersion("b1.2_01", "486d83ec00554b45ffa21af2faa0116a");
            MinecraftVersion.addKnownVersion("b1.2_02", "6d0d87905008db07bb80c61d7e8f9fb6");
            MinecraftVersion.addKnownVersion("b1.3", "de2164df461d028229ed2e101181bbd4");
            MinecraftVersion.addKnownVersion("b1.3_01", "4203826f35e1036f089919032c3d19d1");
            MinecraftVersion.addKnownVersion("b1.4", "71e64b61175b371ed148b385f2d14ebf");
            MinecraftVersion.addKnownVersion("b1.4_01", "9379e54b581ba4ef3acc3e326e87db91");
            MinecraftVersion.addKnownVersion("b1.5", "24289130902822d73f8722b52bc07cdb");
            MinecraftVersion.addKnownVersion("b1.5_01", "d02fa9998e30693d8d989d5f88cf0040");
            MinecraftVersion.addKnownVersion("b1.6", "d531e221227a65392259d3141893280d");
            MinecraftVersion.addKnownVersion("b1.6.1", "a7e82c441a57ef4068c533f4d777336a");
            MinecraftVersion.addKnownVersion("b1.6.2", "01330b1c930102a683a4dd8d792e632e");
            MinecraftVersion.addKnownVersion("b1.6.4", "5c4df6f120336f113180698613853dba");
            MinecraftVersion.addKnownVersion("b1.6.5", "2aba888864b32038c8d22ee5df71b7c8");
            MinecraftVersion.addKnownVersion("b1.6.6", "ce80072464433cd5b05d505aa8ff29d1");
            MinecraftVersion.addKnownVersion("b1.7_01", "defc33265dfbb21afb37da7c400800e9");
            MinecraftVersion.addKnownVersion("b1.7.2", "dd9215ab1141170d4871f42bff4ab302");
            MinecraftVersion.addKnownVersion("b1.7.3", "eae3353fdaa7e10a59b4cb5b45bfa10d");
            MinecraftVersion.addKnownVersion("b1.8pre1", "7ce3238b148bb67a3b84cf59b7516f55");
            MinecraftVersion.addKnownVersion("b1.8pre2", "bff1cf2e4586012ac8907b8e7945d4c3");
            MinecraftVersion.addKnownVersion("b1.8", "a59a9fd4c726a573b0a2bdd10d857f59");
            MinecraftVersion.addKnownVersion("b1.8.1", "f8c5a2ccd3bc996792bbe436d8cc08bc");
            MinecraftVersion.addKnownVersion("b1.9pre1", "b4d9681a1118949d7753e19c35c61ec7");
            MinecraftVersion.addKnownVersion("b1.9pre2", "962d79abeca031b44cf8dac8d4fcabe9");
            MinecraftVersion.addKnownVersion("b1.9pre3", "334827dbe9183af6d650b39321a99e21");
            MinecraftVersion.addKnownVersion("b1.9pre4", "cae41f3746d3c4c440b2d63a403770e7");
            MinecraftVersion.addKnownVersion("b1.9pre5", "6258c4f293b939117efe640eda76dca4");
            MinecraftVersion.addKnownVersion("b1.9pre6", "2468205154374afe5f9caaba2ffbf5f8");
            MinecraftVersion.addKnownVersion("rc1", "22d708f84dc44fba200c2a5e4261959c");
            MinecraftVersion.addKnownVersion("rc2pre1", "e8e264bcff34aecbc7ef7f850858c1d6");
            MinecraftVersion.addKnownVersion("rc2", "bd569d20dd3dd898ff4371af9bbe14e1");
            MinecraftVersion.addKnownVersion("1.0.0", "3820d222b95d0b8c520d9596a756a6e6");
            MinecraftVersion.addKnownVersion("11w47a", "2ad75c809570663ec561ca707983a45b");
            MinecraftVersion.addKnownVersion("11w48a", "cd86517284d62a0854234ae12abd019c");
            MinecraftVersion.addKnownVersion("11w49a", "a1f7969b6b546c492fecabfcb8e8525a");
            MinecraftVersion.addKnownVersion("11w50a", "8763eb2747d57e2958295bbd06e764b1");
            MinecraftVersion.addKnownVersion("12w01a", "468f1b4022eb81d5ca2f316e24a7ffe5");
            MinecraftVersion.addKnownVersion("1.1", "e92302d2acdba7c97e0d8df1e10d2006");
            MinecraftVersion.addKnownVersion("12w03a", "ea85d9c4058ba9e47d8130bd1bff8be9");
            MinecraftVersion.addKnownVersion("12w04a", "c2e2d8c38288ac122001f2ed11c4d83a");
            MinecraftVersion.addKnownVersion("12w05a", "feabb7967bd528a9f3309a2d660d555d");
            MinecraftVersion.addKnownVersion("12w05b", "70affb4ae7da7e8b24f1bbbcbe58cf0f");
            MinecraftVersion.addKnownVersion("12w06a", "9cfaa4adec02642574ffb7c23a084d74");
            MinecraftVersion.addKnownVersion("12w07a", "d60621a26a64f3bda2849c32da6765c6");
            MinecraftVersion.addKnownVersion("12w07b", "88a9a9055d0d1d17b1c797e280508d83");
            MinecraftVersion.addKnownVersion("12w08a", "1d04d6b190a2ad14d8996802b9286bef");
            MinecraftVersion.addKnownVersion("1.2", "ee18a8cc1db8d15350bceb6ee71292f4");
            MinecraftVersion.addKnownVersion("1.2.2", "6189e96efaea11e5164b4a4755574324");
            MinecraftVersion.addKnownVersion("1.2.3", "12f6c4b1bdcc63f029e3c088a364b8e4");
            MinecraftVersion.addKnownVersion("1.2.4", "25423eab6d8707f96cc6ad8a21a7250a");
            MinecraftVersion.addKnownVersion("1.2.5", "8e8778078a175a33603a585257f28563");
            MinecraftVersion.addKnownVersion("12w15a", "90626a5c36f87aadbc7e79da1f076e93");
            MinecraftVersion.addKnownVersion("12w16a", "19ec24b0987e93da972147d1788c5227");
            MinecraftVersion.addKnownVersion("12w17a", "fc5826a699541df023762c6b8516e20e");
            MinecraftVersion.addKnownVersion("12w18a", "63bdc3586a192ddd13e7a8c08e864ec4");
            MinecraftVersion.addKnownVersion("12w19a", "113b505ad24b11a6cf801bd3516e7cc3");
            MinecraftVersion.addKnownVersion("12w21a", "51ea290e859130e14077758b545e8e91");
            MinecraftVersion.addKnownVersion("12w21b", "57b7376824b6635ea36b7591dd4da3ef");
            MinecraftVersion.addKnownVersion("12w22a", "fed0bfb2b0de4596c81dd698f73bdf4b");
            MinecraftVersion.addKnownVersion("12w23a", "42a509057902760abc3abd7227d028fc");
            MinecraftVersion.addKnownVersion("12w23b", "5798c9af6844333ee82fc9b11c6c47ea");
            MinecraftVersion.addKnownVersion("12w24a", "ac908492cdfe6c1d81183d2d2d7959a1");
            MinecraftVersion.addKnownVersion("12w25a", "b904c9d0d976039047e421a66a1a912d");
            MinecraftVersion.addKnownVersion("12w26a", "c3b849226a93a5aeffcabed61720cf45");
            MinecraftVersion.addKnownVersion("12w27a", "a3412d58aa1e5bcb6472fcf1c7e72ac1");
            MinecraftVersion.addKnownVersion("12w30a", "07dbdc7266019ab1d42c61f42b809f4d");
            MinecraftVersion.addKnownVersion("12w30b", "287bc65621e66a0d2287ff4eb424e90a");
            MinecraftVersion.addKnownVersion("12w30c", "1a1fb1f68354ca0a71fc723f36b97a81");
            MinecraftVersion.addKnownVersion("12w30d", "f2b0315ce33a3b473a523f5fa151a06d");
            MinecraftVersion.addKnownVersion("12w30e", "d466309bafbdece16b0a74a4290dbee1");
            MinecraftVersion.addKnownVersion("1.3", "a6effac1eaccf5d429aae340cf95ed5d");
            MinecraftVersion.addKnownVersion("1.3.1", "266ccbc9798afd2eadf3d6c01b4c562a");
            MinecraftVersion.addKnownVersion("1.3.2", "969699f13e5bbe7f12e40ac4f32b7d9a");
            MinecraftVersion.addKnownVersion("12w32a", "0de5595692a736307e96e3fec050a98e");
            MinecraftVersion.addKnownVersion("12w34a", "562b82c59fa6870c10e79d9474edb356");
            MinecraftVersion.addKnownVersion("12w34b", "d71d0a4013555753dbaa31b3aed02815");
            MinecraftVersion.addKnownVersion("12w36a", "a2924e04c571a3cf7a9d8fb1955e6f4b");
            MinecraftVersion.addKnownVersion("12w37a", "cd025f4b67f5b7811dc5c96542bdaf5e");
            MinecraftVersion.addKnownVersion("12w38a", "8e6c588f9cf2502076ee64ad77d5f54d");
            MinecraftVersion.addKnownVersion("12w38b", "211bf5190199fa59d1b6fa0997daa1d7");
            MinecraftVersion.addKnownVersion("12w39a", "f8e8d69ee0a5ef5a70db1c631f93ef5d");
            MinecraftVersion.addKnownVersion("12w39b", "afcc7775ab7b2b6659bcee50dfb9dbc8");
            MinecraftVersion.addKnownVersion("12w40a", "fd1f030c0230db3f24c5ecfb971a977d");
            MinecraftVersion.addKnownVersion("12w40b", "c549b63c7bafec08f0b2fa291c881be6");
            MinecraftVersion.addKnownVersion("12w41a", "b6f1227e4bb0a8d9155fc2093319fc26");
            MinecraftVersion.addKnownVersion("12w41b", "a6269139ef11b1815eb597132533cdfb");
            MinecraftVersion.addKnownVersion("12w42a", "5d25fdfe0f202ec380e8d429b2d6a81f");
            MinecraftVersion.addKnownVersion("12w42b", "c610c644ef5c27d2f91cf512e2e23c28");
            MinecraftVersion.addKnownVersion("1.4", "32a654388b54d3e4bb29c1a46e7d6a12");
            MinecraftVersion.addKnownVersion("1.4.1", "542621a5298659dc65f383f35170fc4c");
            MinecraftVersion.addKnownVersion("1.4.2", "771175c01778ea67395bc6919a5a9dc5");
            MinecraftVersion.addKnownVersion("1.4.3", "9cc3295931edb6339f22989fe1b612a6");
            MinecraftVersion.addKnownVersion("1.4.4", "7aa46c8058cba2f38e9d2ddddcc77c72");
            MinecraftVersion.addKnownVersion("1.4.5", "469c9743ba88b7aa498769db75e31b1c");
            MinecraftVersion.addKnownVersion("1.4.5", "b15e2b2b6b4629f0d99a95b6b44412a0");
            MinecraftVersion.addKnownVersion("12w49a", "258b8a5922d046e0f93b338dfa79df36");
            MinecraftVersion.addKnownVersion("12w50a", "47bb6d5db217b39c44f5e116fc59d7ba");
            MinecraftVersion.addKnownVersion("12w50b", "ce8bf157d021157b0a122c03501e5973");
            MinecraftVersion.addKnownVersion("1.4.6", "48677dc4c2b98c29918722b5ab27b4fd");
            MinecraftVersion.addKnownVersion("1.4.7", "8e80fb01b321c6b3c7efca397a3eea35");
            MinecraftVersion.addKnownVersion("13w01a", "57dd5c298dff8906b4fe406f81d6914d");
            MinecraftVersion.addKnownVersion("13w01b", "0a1cb9b3ea4381d898316109e58f5635");
            MinecraftVersion.addKnownVersion("13w02a", "1b794176aabd9c0e2be09ee9c8a45d77");
            MinecraftVersion.addKnownVersion("13w02b", "13891f6610b6739ac79f40147cca31d5");
            MinecraftVersion.addKnownVersion("13w03a", "1c8698800c60ee72589165914f860554");
            MinecraftVersion.addKnownVersion("13w03a", "599a59bfd0a1645453b51b343b4c78c8");
            MinecraftVersion.addKnownVersion("13w04a", "7bfbc543df06f7eb5fe6a2971a085c39");
            MinecraftVersion.addKnownVersion("13w05a", "e4e99faf111be767a07fab45ca386613");
            MinecraftVersion.addKnownVersion("13w05a", "e8f17d5e7c54eb38feb3034fb0385ee5");
            MinecraftVersion.addKnownVersion("13w05b", "496002660846f2eb455cba407cd26818");
            MinecraftVersion.addKnownVersion("13w06a", "1bdd3df77601b37f127d057ac6d686cd");
            MinecraftVersion.addKnownVersion("13w06a", "62bbd3e4ed36e7572f45c4e802759a09");
            MinecraftVersion.addKnownVersion("13w07a", "6c048588e57aee5b02b6bde7978d8f95");
            MinecraftVersion.addKnownVersion("13w09a", "2821913edf037588e7df890dfa6c0d2a");
            MinecraftVersion.addKnownVersion("13w09b", "fb5ba640847d430c3b45f6c3a9649ab8");
            MinecraftVersion.addKnownVersion("13w09c", "d2534381656da5069b96cc89e28158ef");
            MinecraftVersion.addKnownVersion("13w10a", "825d813c9c3fb9341b04ff0759f028d8");
            MinecraftVersion.addKnownVersion("13w10b", "12bb0e9aa07c12073458fc8b93e23f0f");
            MinecraftVersion.addKnownVersion("1.5", "d39baadeeb124a29b2542d778713493f");
            MinecraftVersion.addKnownVersion("1.5", "fd11cbc5b01aae1d62cff0145171f3d9");
            MinecraftVersion.addKnownVersion("13w11a", "7ea28c690bec31ddac16c231e4d6d92c");
            MinecraftVersion.addKnownVersion("1.5.1", "dcee28c1b1cea2b36816a60e8adafea4");
            MinecraftVersion.addKnownVersion("1.5.1", "5c1219d869b87d233de3033688ec7567");
            MinecraftVersion.addKnownVersion("2.0_blue", "b16c06933f2aa43594ea7a150a126a07");
            MinecraftVersion.addKnownVersion("2.0_purple", "6023b7c3626d987d9c85c8e2617d3705");
            MinecraftVersion.addKnownVersion("2.0_red", "ee00fb8745c03af3fabe8a92cd52ebaf");
            MinecraftVersion.addKnownVersion("1.5.2", "c79b8234a7a3e8e457ac6e37c478691f");
            MinecraftVersion.addKnownVersion("1.5.2", "6897c3287fb971c9f362eb3ab20f5ddd");
            MinecraftVersion.addKnownVersion("13w16a", "d8743a2434a57ca5c1d8708f3e8bd666");
            MinecraftVersion.addKnownVersion("13w16a", "01d0a4013bf416eaeb3c1f67a81ba4db");
            MinecraftVersion.addKnownVersion("13w16b", "b0ebfdaf3c7baeb892da2c9138e379e9");
            MinecraftVersion.addKnownVersion("13w17a", "ea6b4cd61880d12c6781725323e1d0e1");
            MinecraftVersion.addKnownVersion("13w18a", "4f899d67d62dd605ad10b4da8d221d7f");
            MinecraftVersion.addKnownVersion("13w18b", "1f5ec00f68592fcf298cfa22214a7e91");
            MinecraftVersion.addKnownVersion("13w18c", "f5f847516e11101aca961e89c7163d41");
            MinecraftVersion.addKnownVersion("13w19a", "4c2ecdebff5f2c7b41e423c58be67b98");
            MinecraftVersion.addKnownVersion("13w21a", "6df497d9b4e425f54c6ce50d2fd5f68f");
            MinecraftVersion.addKnownVersion("13w21b", "b1fe1a3ccccf8bf032ed6c73d5f31ee6");
            MinecraftVersion.addKnownVersion("13w22a", "bd610b1dc3bb9671dc72391db5918ffa");
            MinecraftVersion.addKnownVersion("13w23a", "705c39f24f367e61947c8971cab7eff9");
            MinecraftVersion.addKnownVersion("13w23b", "447dc4eb124ef2a0e3f45f3dda617cbd");
            MinecraftVersion.addKnownVersion("13w24a", "6164313863f51af4f0ea206fc351dacf");
            MinecraftVersion.addKnownVersion("13w24b", "83159880733a65b47c69a4e7da6b44c7");
            MinecraftVersion.addKnownVersion("13w25a", "72467d2bde4354800f6cc19442052ed5");
            MinecraftVersion.addKnownVersion("13w25b", "f2e460ccece33d996284d9e02b6f9afc");
            MinecraftVersion.addKnownVersion("13w25c", "4face5c5bc04f50c58ddbd94e88b9d80");
            MinecraftVersion.addKnownVersion("13w26a", "7f13896abb48ff5b3d391daf5580388d");
            MinecraftVersion.addKnownVersion("1.6", "7761a19e4d6880451bf3a4943d298379");
            MinecraftVersion.addKnownVersion("1.6", "6a64a2136e3a3fe4d29b0a0df30b25fc");
            MinecraftVersion.addKnownVersion("1.6.1", "3c56fb4b77b1ca37dde69b5eb896fc4d");
            MinecraftVersion.addKnownVersion("1.6.2", "87dec34e35f3323a92474cd0b45fff8e");
            MinecraftVersion.addKnownVersion("1.6.2", "349e373456ea2a97fab42dd9d938e784");
            MinecraftVersion.addKnownVersion("1.6.2", "1d43cdba8b9752d7f557ab7d3e365964");
            MinecraftVersion.addKnownVersion("1.6.3", "3aba46ba846ced2093c0cd37af370d65");
            MinecraftVersion.addKnownVersion("1.6.3", "233effe2110d40a0519cf1489e4ccb1c");
            MinecraftVersion.addKnownVersion("1.6.4", "2e5044f5359e82245551167a237f3167");
            MinecraftVersion.addKnownVersion("13w36a", "36e6ccf248f0d28bd682f1ac2971ae8d");
            MinecraftVersion.addKnownVersion("13w36b", "7a517f489ecad1190c4aa6de5b9962fb");
            MinecraftVersion.addKnownVersion("13w37a", "1ecf5d29e066851a67680e1b3913f985");
            MinecraftVersion.addKnownVersion("13w37b", "32852c180835fcc7ce8784990dbe459a");
            MinecraftVersion.addKnownVersion("13w38a", "b66bc2e70faa94ff2ddf8f4bf0bec948");
            MinecraftVersion.addKnownVersion("13w38b", "02123a03b389443c8fa8a6f6cbccb34d");
            MinecraftVersion.addKnownVersion("13w38c", "eba542003ead603b85051c3498543e7b");
            MinecraftVersion.addKnownVersion("13w39a", "1bd52bdfeda64c3d3845245a5067918d");
            MinecraftVersion.addKnownVersion("13w39b", "c51a147ed0a629c479320e5e9e63bb3e");
            MinecraftVersion.addKnownVersion("13w41a", "063265e1ce84241c01edf7163a7815df");
            MinecraftVersion.addKnownVersion("13w41b", "e3dd0af40c588f4699b48ec865f8793e");
            MinecraftVersion.addKnownVersion("13w42a", "0709f20f4e8d3e8581c6aaab008158b8");
            MinecraftVersion.addKnownVersion("13w42b", "c839b4f314a687c75fa73a77a1480f0d");
            MinecraftVersion.addKnownVersion("13w43a", "62bfa5d9712b0ab856b78425326bc878");
            MinecraftVersion.addKnownVersion("1.7", "9f7754f6633b15aa695898c9a93c32c8");
            MinecraftVersion.addKnownVersion("1.7.1", "08c354313f902913b6e66f6d73938479");
            for (int i = 0; i < versionOrdering.size(); ++i) {
                MinecraftVersion a = versionOrdering.get(i);
                for (int j = 0; j < versionOrdering.size(); ++j) {
                    MinecraftVersion b = versionOrdering.get(j);
                    Integer result = a.comparePartial(b);
                    if (i == j) {
                        if (result != null && result == 0) continue;
                        throw new RuntimeException("incorrect ordering in known version table: " + a.getVersionString() + " != " + b.getVersionString());
                    }
                    if (i > j) {
                        if (result == null || result > 0) continue;
                        throw new RuntimeException("incorrect ordering in known version table: " + a.getVersionString() + " <= " + b.getVersionString());
                    }
                    if (result == null || result < 0) continue;
                    throw new RuntimeException("incorrect ordering in known version table: " + a.getVersionString() + " >= " + b.getVersionString());
                }
            }
        }
        catch (Throwable e) {
            Logger.log(e);
        }
    }
}

